/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;

public class SingletonIteration<E, X extends Exception>
extends AbstractCloseableIteration<E, X> {
    private final AtomicReference<E> value;

    public SingletonIteration(E value) {
        this.value = new AtomicReference<E>(value);
    }

    @Override
    public boolean hasNext() {
        return this.value.get() != null;
    }

    @Override
    public E next() throws X {
        E result = this.value.getAndSet(null);
        if (result == null) {
            this.close();
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleClose() throws X {
        try {
            super.handleClose();
        }
        finally {
            this.value.set(null);
        }
    }
}

