/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class PatternFilter
extends FilterPlanNode {
    private final Pattern pattern;

    public PatternFilter(PlanNode parent, String pattern, String flags) {
        super(parent);
        if (flags != null && flags.length() > 0) {
            int flag = 0;
            if (flags.contains("i")) {
                flag |= 2;
            }
            if (flags.contains("d")) {
                flag |= 1;
            }
            if (flags.contains("m")) {
                flag |= 8;
            }
            if (flags.contains("s")) {
                flag |= 0x20;
            }
            if (flags.contains("u")) {
                flag |= 0x40;
            }
            if (flags.contains("x")) {
                flag |= 4;
            }
            if (flags.contains("U")) {
                flag |= 0x100;
            }
            this.pattern = Pattern.compile(pattern, flag);
        } else {
            this.pattern = Pattern.compile(pattern);
        }
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        Value literal = t.getValue();
        return this.pattern.matcher(literal.stringValue()).matches();
    }

    @Override
    public String toString() {
        return "PatternFilter{pattern=" + this.pattern + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PatternFilter that = (PatternFilter)o;
        return this.pattern.equals(that.pattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pattern);
    }
}

