/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.vocabulary;

import java.util.HashMap;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.vocabulary.Vocabularies;

public class XSD {
    public static final String NAMESPACE = "http://www.w3.org/2001/XMLSchema#";
    public static final String PREFIX = "xsd";
    public static final Namespace NS = Vocabularies.createNamespace("xsd", "http://www.w3.org/2001/XMLSchema#");
    public static final IRI DURATION = XSD.create("duration");
    public static final IRI DATETIME = XSD.create("dateTime");
    public static final IRI DATETIMESTAMP = XSD.create("dateTimeStamp");
    public static final IRI DAYTIMEDURATION = XSD.create("dayTimeDuration");
    public static final IRI TIME = XSD.create("time");
    public static final IRI DATE = XSD.create("date");
    public static final IRI GYEARMONTH = XSD.create("gYearMonth");
    public static final IRI GYEAR = XSD.create("gYear");
    public static final IRI GMONTHDAY = XSD.create("gMonthDay");
    public static final IRI GDAY = XSD.create("gDay");
    public static final IRI GMONTH = XSD.create("gMonth");
    public static final IRI STRING = XSD.create("string");
    public static final IRI BOOLEAN = XSD.create("boolean");
    public static final IRI BASE64BINARY = XSD.create("base64Binary");
    public static final IRI HEXBINARY = XSD.create("hexBinary");
    public static final IRI FLOAT = XSD.create("float");
    public static final IRI DECIMAL = XSD.create("decimal");
    public static final IRI DOUBLE = XSD.create("double");
    public static final IRI ANYURI = XSD.create("anyURI");
    public static final IRI QNAME = XSD.create("QName");
    public static final IRI NOTATION = XSD.create("NOTATION");
    public static final IRI NORMALIZEDSTRING = XSD.create("normalizedString");
    public static final IRI TOKEN = XSD.create("token");
    public static final IRI LANGUAGE = XSD.create("language");
    public static final IRI NMTOKEN = XSD.create("NMTOKEN");
    public static final IRI NMTOKENS = XSD.create("NMTOKENS");
    public static final IRI NAME = XSD.create("Name");
    public static final IRI NCNAME = XSD.create("NCName");
    public static final IRI ID = XSD.create("ID");
    public static final IRI IDREF = XSD.create("IDREF");
    public static final IRI IDREFS = XSD.create("IDREFS");
    public static final IRI ENTITY = XSD.create("ENTITY");
    public static final IRI ENTITIES = XSD.create("ENTITIES");
    public static final IRI INTEGER = XSD.create("integer");
    public static final IRI LONG = XSD.create("long");
    public static final IRI INT = XSD.create("int");
    public static final IRI SHORT = XSD.create("short");
    public static final IRI BYTE = XSD.create("byte");
    public static final IRI NON_POSITIVE_INTEGER = XSD.create("nonPositiveInteger");
    public static final IRI NEGATIVE_INTEGER = XSD.create("negativeInteger");
    public static final IRI NON_NEGATIVE_INTEGER = XSD.create("nonNegativeInteger");
    public static final IRI POSITIVE_INTEGER = XSD.create("positiveInteger");
    public static final IRI UNSIGNED_LONG = XSD.create("unsignedLong");
    public static final IRI UNSIGNED_INT = XSD.create("unsignedInt");
    public static final IRI UNSIGNED_SHORT = XSD.create("unsignedShort");
    public static final IRI UNSIGNED_BYTE = XSD.create("unsignedByte");
    public static final IRI YEARMONTHDURATION = XSD.create("yearMonthDuration");

    private static IRI create(String localName) {
        return Vocabularies.createIRI(NAMESPACE, localName);
    }

    public static enum Datatype {
        DURATION(DURATION, true, true, false, false, false, false, false),
        DATETIME(DATETIME, true, false, false, false, false, false, true),
        DATETIMESTAMP(DATETIMESTAMP, false, false, false, true, false, false, true),
        DAYTIMEDURATION(DAYTIMEDURATION, false, true, false, true, false, false, false),
        TIME(TIME, true, false, false, false, false, false, true),
        DATE(DATE, true, false, false, false, false, false, true),
        GYEARMONTH(GYEARMONTH, true, false, false, false, false, false, true),
        GYEAR(GYEAR, true, false, false, false, false, false, true),
        GMONTHDAY(GMONTHDAY, true, false, false, false, false, false, true),
        GDAY(GDAY, true, false, false, false, false, false, true),
        GMONTH(GMONTH, true, false, false, false, false, false, true),
        STRING(STRING, true, false, false, false, false, false, false),
        BOOLEAN(BOOLEAN, true, false, false, false, false, false, false),
        BASE64BINARY(BASE64BINARY, true, false, false, false, false, false, false),
        HEXBINARY(HEXBINARY, true, false, false, false, false, false, false),
        FLOAT(FLOAT, true, false, false, false, false, true, false),
        DECIMAL(DECIMAL, true, false, false, false, true, false, false),
        DOUBLE(DOUBLE, true, false, false, false, false, true, false),
        ANYURI(ANYURI, true, false, false, false, false, false, false),
        QNAME(QNAME, true, false, false, false, false, false, false),
        NOTATION(NOTATION, true, false, false, false, false, false, false),
        NORMALIZEDSTRING(NORMALIZEDSTRING, false, false, false, true, false, false, false),
        TOKEN(TOKEN, false, false, false, true, false, false, false),
        LANGUAGE(LANGUAGE, false, false, false, true, false, false, false),
        NMTOKEN(NMTOKEN, false, false, false, true, false, false, false),
        NMTOKENS(NMTOKENS, false, false, false, true, false, false, false),
        NAME(NAME, false, false, false, true, false, false, false),
        NCNAME(NCNAME, false, false, false, true, false, false, false),
        ID(ID, false, false, false, true, false, false, false),
        IDREF(IDREF, false, false, false, true, false, false, false),
        IDREFS(IDREFS, false, false, false, true, false, false, false),
        ENTITY(ENTITY, false, false, false, true, false, false, false),
        ENTITIES(ENTITIES, false, false, false, true, false, false, false),
        INTEGER(INTEGER, false, false, true, true, true, false, false),
        LONG(LONG, false, false, true, true, true, false, false),
        INT(INT, false, false, true, true, true, false, false),
        SHORT(SHORT, false, false, true, true, true, false, false),
        BYTE(BYTE, false, false, true, true, true, false, false),
        NON_POSITIVE_INTEGER(NON_POSITIVE_INTEGER, false, false, true, true, true, false, false),
        NEGATIVE_INTEGER(NEGATIVE_INTEGER, false, false, true, true, true, false, false),
        NON_NEGATIVE_INTEGER(NON_NEGATIVE_INTEGER, false, false, true, true, true, false, false),
        POSITIVE_INTEGER(POSITIVE_INTEGER, false, false, true, true, true, false, false),
        UNSIGNED_LONG(UNSIGNED_LONG, false, false, true, true, true, false, false),
        UNSIGNED_INT(UNSIGNED_INT, false, false, true, true, true, false, false),
        UNSIGNED_SHORT(UNSIGNED_SHORT, false, false, true, true, true, false, false),
        UNSIGNED_BYTE(UNSIGNED_BYTE, false, false, true, true, true, false, false),
        YEARMONTHDURATION(YEARMONTHDURATION, false, true, false, true, false, false, false);

        private final IRI iri;
        private final boolean primitive;
        private final boolean duration;
        private final boolean integer;
        private final boolean derived;
        private final boolean decimal;
        private final boolean floatingPoint;
        private final boolean calendar;
        static HashMap<IRI, Optional<Datatype>> reverseLookup;

        private Datatype(IRI iri, boolean primitive, boolean duration, boolean integer, boolean derived, boolean decimal, boolean floatingPoint, boolean calendar) {
            this.iri = iri;
            this.primitive = primitive;
            this.duration = duration;
            this.integer = integer;
            this.derived = derived;
            this.decimal = decimal;
            this.floatingPoint = floatingPoint;
            this.calendar = calendar;
        }

        public boolean isPrimitiveDatatype() {
            return this.primitive;
        }

        public boolean isDerivedDatatype() {
            return this.derived;
        }

        public boolean isBuiltInDatatype() {
            return this.isPrimitiveDatatype() || this.isDerivedDatatype();
        }

        public boolean isNumericDatatype() {
            return this.isDecimalDatatype() || this.isFloatingPointDatatype();
        }

        public boolean isDecimalDatatype() {
            return this.decimal;
        }

        public boolean isIntegerDatatype() {
            return this.integer;
        }

        public boolean isFloatingPointDatatype() {
            return this.floatingPoint;
        }

        public boolean isCalendarDatatype() {
            return this.calendar;
        }

        public boolean isDurationDatatype() {
            return this.duration;
        }

        public boolean isOrderedDatatype() {
            return this.isNumericDatatype() || this.isCalendarDatatype();
        }

        public static Optional<Datatype> from(IRI datatype) {
            return reverseLookup.getOrDefault(datatype, Optional.empty());
        }

        public IRI getIri() {
            return this.iri;
        }

        static {
            reverseLookup = new HashMap();
            for (Datatype value : Datatype.values()) {
                reverseLookup.put(value.iri, Optional.of(value));
            }
        }
    }
}

