/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;
import org.eclipse.rdf4j.sail.memory.model.MemValue;
import org.eclipse.rdf4j.sail.memory.model.MemValueFactory;

class MemEvaluationStatistics
extends EvaluationStatistics {
    private final MemValueFactory valueFactory;
    private final MemStatementList memStatementList;

    MemEvaluationStatistics(MemValueFactory valueFactory, MemStatementList memStatementList) {
        this.valueFactory = valueFactory;
        this.memStatementList = memStatementList;
    }

    protected EvaluationStatistics.CardinalityCalculator createCardinalityCalculator() {
        return new MemCardinalityCalculator();
    }

    protected class MemCardinalityCalculator
    extends EvaluationStatistics.CardinalityCalculator {
        protected MemCardinalityCalculator() {
        }

        public double getCardinality(StatementPattern sp) {
            Value pred;
            Value subj = this.getConstantValue(sp.getSubjectVar());
            if (subj == null || !subj.isResource()) {
                subj = null;
            }
            if ((pred = this.getConstantValue(sp.getPredicateVar())) == null || !pred.isIRI()) {
                pred = null;
            }
            Value obj = this.getConstantValue(sp.getObjectVar());
            Value context = this.getConstantValue(sp.getContextVar());
            if (context == null || !context.isResource()) {
                context = null;
            }
            MemResource memSubj = MemEvaluationStatistics.this.valueFactory.getMemResource((Resource)subj);
            MemIRI memPred = MemEvaluationStatistics.this.valueFactory.getMemURI((IRI)pred);
            MemValue memObj = MemEvaluationStatistics.this.valueFactory.getMemValue(obj);
            MemResource memContext = MemEvaluationStatistics.this.valueFactory.getMemResource((Resource)context);
            if (subj != null && memSubj == null || pred != null && memPred == null || obj != null && memObj == null || context != null && memContext == null) {
                return 0.0;
            }
            int minListSizes = Integer.MAX_VALUE;
            if (memSubj != null) {
                minListSizes = Math.min(minListSizes, memSubj.getSubjectStatementCount());
            }
            if (memPred != null) {
                minListSizes = Math.min(minListSizes, memPred.getPredicateStatementCount());
            }
            if (memObj != null) {
                minListSizes = Math.min(minListSizes, memObj.getObjectStatementCount());
            }
            if (memContext != null) {
                minListSizes = Math.min(minListSizes, memContext.getContextStatementCount());
            }
            double cardinality = minListSizes == Integer.MAX_VALUE ? (double)MemEvaluationStatistics.this.memStatementList.size() : (double)minListSizes;
            return cardinality;
        }

        protected Value getConstantValue(Var var) {
            if (var != null) {
                return var.getValue();
            }
            return null;
        }
    }
}

