/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.function.Function;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalFilterByQuery
extends FilterPlanNode {
    private static final Logger logger = LoggerFactory.getLogger(ExternalFilterByQuery.class);
    private final SailConnection connection;
    private final ParsedQuery query;
    private final StatementMatcher.Variable queryVariable;
    private final Function<ValidationTuple, Value> filterOn;
    private final String queryString;

    public ExternalFilterByQuery(SailConnection connection, PlanNode parent, String queryFragment, StatementMatcher.Variable queryVariable, Function<ValidationTuple, Value> filterOn) {
        super(parent);
        this.connection = connection;
        this.queryVariable = queryVariable;
        this.filterOn = filterOn;
        QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get(QueryLanguage.SPARQL).get();
        this.queryString = queryFragment = "SELECT ?" + queryVariable.getName() + " WHERE {\n" + queryFragment + "\n}";
        try {
            this.query = queryParserFactory.getParser().parseQuery(queryFragment, null);
        }
        catch (MalformedQueryException e) {
            logger.error("Malformed query: \n{}", (Object)queryFragment);
            throw e;
        }
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        Value value = this.filterOn.apply(t);
        MapBindingSet bindings = new MapBindingSet();
        bindings.addBinding(this.queryVariable.getName(), value);
        try (CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingSet = this.connection.evaluate(this.query.getTupleExpr(), this.query.getDataset(), bindings, false);){
            boolean bl = bindingSet.hasNext();
            return bl;
        }
    }

    @Override
    public String toString() {
        return "ExternalFilterByQuery{, queryString=" + this.queryString.replace("\n", "\t") + ", queryVariable='" + this.queryVariable.toString().replace("\n", "  ") + '\'' + '}';
    }
}

