/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.manager;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.impl.TreeModelFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResolver;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.repository.manager.RepositoryInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepositoryManager
implements RepositoryResolver,
HttpClientDependent {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String NAMESPACE = "http://www.openrdf.org/config/repository/proxy#";
    public static final IRI PROXIED_ID = SimpleValueFactory.getInstance().createIRI("http://www.openrdf.org/config/repository/proxy#", "proxiedID");
    private ModelFactory modelFactory = new TreeModelFactory();
    protected Map<String, Repository> initializedRepositories;
    private boolean initialized;

    protected RepositoryManager() {
        this(new HashMap<String, Repository>());
    }

    protected RepositoryManager(Map<String, Repository> initializedRepositories) {
        this.setInitializedRepositories(initializedRepositories);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public abstract HttpClient getHttpClient();

    public abstract void setHttpClient(HttpClient var1);

    public ModelFactory getModelFactory() {
        return this.modelFactory;
    }

    public void setModelFactory(ModelFactory modelFactory) {
        Objects.requireNonNull(modelFactory);
        this.modelFactory = modelFactory;
    }

    @Deprecated
    public void initialize() throws RepositoryException {
        this.init();
    }

    public void init() throws RepositoryException {
        this.initialized = true;
    }

    @Deprecated
    protected Repository createSystemRepository() throws RepositoryException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Repository getSystemRepository() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Repository Manager is not initialized");
        }
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            Repository systemRepository = this.initializedRepositories.get("SYSTEM");
            if (systemRepository != null && systemRepository.isInitialized()) {
                return systemRepository;
            }
            systemRepository = this.createSystemRepository();
            if (systemRepository != null) {
                this.initializedRepositories.put("SYSTEM", systemRepository);
            }
            return systemRepository;
        }
    }

    public String getNewRepositoryID(String baseName) throws RepositoryException, RepositoryConfigException {
        if (baseName != null) {
            baseName = baseName.trim();
            int length = baseName.length();
            StringBuilder buffer = new StringBuilder(length);
            for (char c : baseName.toCharArray()) {
                if (Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '.') {
                    buffer.append(Character.toLowerCase(c));
                    continue;
                }
                if (c == '\"' || c == '\'') continue;
                buffer.append('-');
            }
            baseName = buffer.toString();
        }
        if (baseName != null && baseName.length() > 0 && !this.hasRepositoryConfig(baseName)) {
            return baseName;
        }
        if (baseName == null || baseName.length() == 0) {
            baseName = "repository-";
        } else if (!baseName.endsWith("-")) {
            baseName = baseName + "-";
        }
        int index = 2;
        while (this.hasRepositoryConfig(baseName + index)) {
            ++index;
        }
        return baseName + index;
    }

    public Set<String> getRepositoryIDs() throws RepositoryException {
        LinkedHashSet<String> idSet = new LinkedHashSet<String>();
        this.getAllRepositoryInfos(false).forEach(info -> idSet.add(info.getId()));
        return idSet;
    }

    public boolean hasRepositoryConfig(String repositoryID) throws RepositoryException, RepositoryConfigException {
        return this.getRepositoryInfo(repositoryID) != null;
    }

    public RepositoryConfig getRepositoryConfig(String repositoryID) throws RepositoryConfigException, RepositoryException {
        Repository systemRepository = this.getSystemRepository();
        if (systemRepository == null) {
            return null;
        }
        return RepositoryConfigUtil.getRepositoryConfig((Repository)systemRepository, (String)repositoryID);
    }

    public void addRepositoryConfig(RepositoryConfig config) throws RepositoryException, RepositoryConfigException {
        Repository systemRepository = this.getSystemRepository();
        if (systemRepository != null && !"SYSTEM".equals(config.getID())) {
            RepositoryConfigUtil.updateRepositoryConfigs((Repository)systemRepository, (RepositoryConfig[])new RepositoryConfig[]{config});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean removeRepositoryConfig(String repositoryID) throws RepositoryException, RepositoryConfigException {
        this.logger.debug("Removing repository configuration for {}.", (Object)repositoryID);
        boolean isRemoved = this.hasRepositoryConfig(repositoryID);
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            Repository systemRepository = this.getSystemRepository();
            if (systemRepository != null) {
                RepositoryConfigUtil.removeRepositoryConfigs((Repository)systemRepository, (String[])new String[]{repositoryID});
            }
            if (isRemoved) {
                this.logger.debug("Shutdown repository {} after removal of configuration.", (Object)repositoryID);
                Repository repository = this.initializedRepositories.remove(repositoryID);
                if (repository != null && repository.isInitialized()) {
                    repository.shutDown();
                }
                try {
                    this.cleanUpRepository(repositoryID);
                }
                catch (IOException e) {
                    throw new RepositoryException("Unable to clean up resources for removed repository " + repositoryID, (Throwable)e);
                }
            }
        }
        return isRemoved;
    }

    public boolean isSafeToRemove(String repositoryID) throws RepositoryException {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        for (String id : this.getRepositoryIDs()) {
            RepositoryConfig config = this.getRepositoryConfig(id);
            LinkedHashModel model = new LinkedHashModel();
            config.export((Model)model, (Resource)vf.createBNode());
            if (!model.contains(null, PROXIED_ID, (Value)vf.createLiteral(repositoryID), new Resource[0])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRepository(String repositoryID) throws RepositoryException, RepositoryConfigException {
        this.logger.debug("Removing repository {}.", (Object)repositoryID);
        boolean isRemoved = this.hasRepositoryConfig(repositoryID);
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            Repository systemRepository = this.getSystemRepository();
            if (systemRepository != null) {
                RepositoryConfigUtil.removeRepositoryConfigs((Repository)systemRepository, (String[])new String[]{repositoryID});
            }
            if (isRemoved) {
                this.logger.debug("Shutdown repository {} after removal of configuration.", (Object)repositoryID);
                Repository repository = this.initializedRepositories.remove(repositoryID);
                if (repository != null && repository.isInitialized()) {
                    repository.shutDown();
                }
                try {
                    this.cleanUpRepository(repositoryID);
                }
                catch (IOException e) {
                    throw new RepositoryException("Unable to clean up resources for removed repository " + repositoryID, (Throwable)e);
                }
            }
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(String identity) throws RepositoryConfigException, RepositoryException {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            Repository result = this.initializedRepositories.get(identity);
            if (result != null && !result.isInitialized()) {
                this.initializedRepositories.remove(identity);
                result = null;
            }
            if (result == null && "SYSTEM".equals(identity)) {
                result = this.getSystemRepository();
            }
            if (result == null && (result = this.createRepository(identity)) != null) {
                this.initializedRepositories.put(identity, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getInitializedRepositoryIDs() {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            return new HashSet<String>(this.initializedRepositories.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Repository> getInitializedRepositories() {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            return new ArrayList<Repository>(this.initializedRepositories.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Repository getInitializedRepository(String repositoryID) {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            return this.initializedRepositories.get(repositoryID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Repository removeInitializedRepository(String repositoryID) {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            return this.initializedRepositories.remove(repositoryID);
        }
    }

    protected void setInitializedRepositories(Map<String, Repository> nextInitializedRepositories) {
        this.initializedRepositories = nextInitializedRepositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateInitializedRepositories() {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            Iterator<Repository> iter = this.initializedRepositories.values().iterator();
            while (iter.hasNext()) {
                Repository next = iter.next();
                if (next.isInitialized()) continue;
                iter.remove();
                try {
                    next.shutDown();
                }
                catch (RepositoryException repositoryException) {}
            }
        }
    }

    public Collection<Repository> getAllRepositories() throws RepositoryConfigException, RepositoryException {
        Set<String> idSet = this.getRepositoryIDs();
        ArrayList<Repository> result = new ArrayList<Repository>(idSet.size());
        for (String id : idSet) {
            result.add(this.getRepository(id));
        }
        return result;
    }

    protected abstract Repository createRepository(String var1) throws RepositoryConfigException, RepositoryException;

    public RepositoryInfo getRepositoryInfo(String id) throws RepositoryException {
        for (RepositoryInfo repInfo : this.getAllRepositoryInfos()) {
            if (!repInfo.getId().equals(id)) continue;
            return repInfo;
        }
        return null;
    }

    public Collection<RepositoryInfo> getAllRepositoryInfos() throws RepositoryException {
        return this.getAllRepositoryInfos(false);
    }

    public Collection<RepositoryInfo> getAllUserRepositoryInfos() throws RepositoryException {
        return this.getAllRepositoryInfos(true);
    }

    public abstract Collection<RepositoryInfo> getAllRepositoryInfos(boolean var1) throws RepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.logger.debug("Refreshing repository information in manager...");
        try {
            Map<String, Repository> map = this.initializedRepositories;
            synchronized (map) {
                Iterator<Map.Entry<String, Repository>> iter = this.initializedRepositories.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, Repository> entry = iter.next();
                    String repositoryID = entry.getKey();
                    Repository repository = entry.getValue();
                    if ("SYSTEM".equals(repositoryID)) continue;
                    iter.remove();
                    this.refreshRepository(repositoryID, repository);
                }
            }
        }
        catch (RepositoryException re) {
            this.logger.error("Failed to refresh repositories", (Throwable)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            for (Repository repository : this.initializedRepositories.values()) {
                try {
                    if (!repository.isInitialized()) continue;
                    repository.shutDown();
                }
                catch (RepositoryException e) {
                    this.logger.error("Repository shut down failed", (Throwable)e);
                }
            }
            this.initializedRepositories.clear();
            this.initialized = false;
        }
    }

    void refreshRepository(String repositoryID, Repository repository) {
        this.logger.debug("Refreshing repository {}...", (Object)repositoryID);
        try {
            if (repository.isInitialized()) {
                repository.shutDown();
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Failed to shut down repository", (Throwable)e);
        }
        this.cleanupIfRemoved(repositoryID);
    }

    void cleanupIfRemoved(String repositoryID) {
        try {
            if (!this.hasRepositoryConfig(repositoryID)) {
                this.logger.debug("Cleaning up repository {}, its configuration has been removed", (Object)repositoryID);
                this.cleanUpRepository(repositoryID);
            } else {
                this.logger.debug("Repository {} should not be cleaned up.", (Object)repositoryID);
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Failed to process repository configuration changes", (Throwable)e);
        }
        catch (RepositoryConfigException e) {
            this.logger.warn("Unable to determine if configuration for {} is still present in the system repository", (Object)repositoryID);
        }
        catch (IOException e) {
            this.logger.warn("Unable to remove data dir for removed repository {} ", (Object)repositoryID);
        }
    }

    @Deprecated
    protected void cleanUpRepository(String repositoryID) throws IOException {
    }

    public abstract URL getLocation() throws MalformedURLException;
}

