/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools.change;

import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public final class BndProjectUpdateChange
extends Change {
    private final IProject project;

    public BndProjectUpdateChange(IProject project) {
        this.project = project;
    }

    public String getName() {
        return PDEUIMessages.ProjectUpdateChange_configure_nature_and_builder;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        String[] newNatures = Arrays.stream(description.getNatureIds()).anyMatch(str -> "org.eclipse.pde.api.tools.apiAnalysisNature".equals(str)) ? (String[])Stream.concat(Arrays.stream(description.getNatureIds()), Stream.of("org.eclipse.pde.BndNature")).toArray(String[]::new) : (String[])Arrays.stream(description.getNatureIds()).map(nature -> {
            if ("org.eclipse.pde.PluginNature".equals(nature)) {
                return "org.eclipse.pde.BndNature";
            }
            return nature;
        }).toArray(String[]::new);
        ICommand[] commands = (ICommand[])Stream.concat(Arrays.stream(description.getBuildSpec()).filter(command -> !"org.eclipse.pde.ManifestBuilder".equals(command.getBuilderName()) && !"org.eclipse.pde.SchemaBuilder".equals(command.getBuilderName())), Stream.of(this.newBndBuilder(description))).toArray(ICommand[]::new);
        description.setBuildSpec(commands);
        description.setNatureIds(newNatures);
        this.project.setDescription(description, pm);
        return null;
    }

    private ICommand newBndBuilder(IProjectDescription description) {
        ICommand bndBuilder = description.newCommand();
        bndBuilder.setBuilderName("org.eclipse.pde.BndBuilder");
        return bndBuilder;
    }

    public Object getModifiedElement() {
        return this.project;
    }
}

