/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.context;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.IModelUndoManager;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.IInputContextListener;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public abstract class InputContextManager
implements IResourceChangeListener {
    private final PDEFormEditor editor;
    private final Map<IEditorInput, InputContext> inputContexts = new HashMap<IEditorInput, InputContext>();
    private final Set<IFile> monitoredFiles = ConcurrentHashMap.newKeySet();
    private final ArrayList<IInputContextListener> listeners = new ArrayList();
    private IModelUndoManager undoManager;

    public InputContextManager(PDEFormEditor editor) {
        this.editor = editor;
        PDEPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void addInputContextListener(IInputContextListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeInputContextListener(IInputContextListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
        PDEPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        for (InputContext context : this.inputContexts.values()) {
            this.unhookUndo(context);
            context.dispose();
        }
        this.inputContexts.clear();
        this.undoManager = null;
        this.monitoredFiles.clear();
    }

    public void save(IProgressMonitor monitor) {
        Collection<InputContext> values = this.inputContexts.values();
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)values.size());
        for (InputContext context : values) {
            if (!context.mustSave()) continue;
            context.doSave((IProgressMonitor)subMon.newChild(1));
        }
    }

    public IProject getCommonProject() {
        for (InputContext context : this.inputContexts.values()) {
            IEditorInput input = context.getInput();
            if (!(input instanceof IFileEditorInput)) continue;
            return ((IFileEditorInput)input).getFile().getProject();
        }
        return null;
    }

    public boolean hasContext(String id) {
        return this.findContext(id) != null;
    }

    public InputContext findContext(String id) {
        for (InputContext context : this.inputContexts.values()) {
            if (!context.getId().equals(id)) continue;
            return context;
        }
        return null;
    }

    public InputContext findContext(IResource resource) {
        for (InputContext context : this.inputContexts.values()) {
            if (!context.matches(resource)) continue;
            return context;
        }
        return null;
    }

    public abstract IBaseModel getAggregateModel();

    public InputContext getContext(IEditorInput input) {
        return this.inputContexts.get(input);
    }

    public void putContext(IEditorInput input, InputContext context) {
        this.inputContexts.put(input, context);
        this.fireContextChange(context, true);
    }

    private void updateInputContext(IEditorInput newInput, IEditorInput oldInput) throws Exception {
        InputContext value = null;
        if (!this.inputContexts.containsKey(oldInput)) {
            throw new Exception(PDEUIMessages.InputContextManager_errorMessageInputContextNotFound);
        }
        value = this.inputContexts.remove(oldInput);
        this.inputContexts.put(newInput, value);
    }

    public void saveAs(IProgressMonitor monitor, String contextID) throws Exception {
        InputContext inputContext = this.findContext(contextID);
        if (inputContext == null) {
            throw new Exception(PDEUIMessages.InputContextManager_errorMessageInputContextNotFound);
        }
        IEditorInput oldInput = this.editor.getEditorInput();
        inputContext.doSaveAs(monitor);
        IEditorInput newInput = inputContext.getInput();
        this.updateInputContext(newInput, oldInput);
    }

    public InputContext getPrimaryContext() {
        for (InputContext context : this.inputContexts.values()) {
            if (!context.isPrimary()) continue;
            return context;
        }
        return null;
    }

    public InputContext[] getInvalidContexts() {
        ArrayList<InputContext> result = new ArrayList<InputContext>();
        for (InputContext context : this.inputContexts.values()) {
            if (context.isModelCorrect()) continue;
            result.add(context);
        }
        return result.toArray(new InputContext[result.size()]);
    }

    public boolean isDirty() {
        for (InputContext context : this.inputContexts.values()) {
            if (!context.mustSave()) continue;
            return true;
        }
        return false;
    }

    public void monitorFile(IFile file) {
        if (file == null) {
            return;
        }
        this.monitoredFiles.add(file);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.monitoredFiles.isEmpty()) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        try {
            ArrayList<IFile> added = new ArrayList<IFile>();
            ArrayList<IFile> removed = new ArrayList<IFile>();
            delta.accept(delta1 -> {
                int kind = delta1.getKind();
                if (kind != 1 && kind != 2) {
                    return true;
                }
                IResource resource = delta1.getResource();
                if (this.monitoredFiles.contains(resource)) {
                    if (kind == 1) {
                        added.add((IFile)resource);
                    } else {
                        removed.add((IFile)resource);
                    }
                    return false;
                }
                return true;
            });
            if (!added.isEmpty() || !removed.isEmpty()) {
                this.asyncStructureChanged(added, removed);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void asyncStructureChanged(List<IFile> added, List<IFile> removed) {
        try {
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            progressService.runInUI((IRunnableContext)progressService, monitor -> {
                for (IFile file : added) {
                    if (monitor.isCanceled()) continue;
                    this.structureChanged(file, true);
                }
                for (IFile file : removed) {
                    if (monitor.isCanceled()) continue;
                    this.structureChanged(file, false);
                }
            }, null);
        }
        catch (InterruptedException | InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
    }

    protected void structureChanged(IFile file, boolean added) {
        if (this.monitoredFiles.contains(file)) {
            if (added) {
                this.fireStructureChange(file, true);
            } else {
                this.fireStructureChange(file, false);
                this.removeContext(file);
            }
        }
    }

    private void removeContext(IFile file) {
        for (InputContext context : this.inputContexts.values()) {
            IFileEditorInput fileInput;
            IEditorInput input = context.getInput();
            if (!(input instanceof IFileEditorInput) || !file.equals((Object)(fileInput = (IFileEditorInput)input).getFile())) continue;
            this.inputContexts.remove(input);
            this.fireContextChange(context, false);
            return;
        }
    }

    protected void fireStructureChange(IFile file, boolean added) {
        int i = 0;
        while (i < this.listeners.size()) {
            IInputContextListener listener = this.listeners.get(i);
            if (added) {
                listener.monitoredFileAdded(file);
            } else {
                listener.monitoredFileRemoved(file);
            }
            ++i;
        }
    }

    protected void fireContextChange(InputContext context, boolean added) {
        int i = 0;
        while (i < this.listeners.size()) {
            IInputContextListener listener = this.listeners.get(i);
            if (added) {
                listener.contextAdded(context);
            } else {
                listener.contextRemoved(context);
            }
            ++i;
        }
        if (added) {
            this.hookUndo(context);
        } else {
            this.unhookUndo(context);
        }
    }

    public void undo() {
        if (this.undoManager != null && this.undoManager.isUndoable()) {
            this.undoManager.undo();
        }
    }

    public void redo() {
        if (this.undoManager != null && this.undoManager.isRedoable()) {
            this.undoManager.redo();
        }
    }

    private void hookUndo(InputContext context) {
        if (this.undoManager == null) {
            return;
        }
        IBaseModel model = context.getModel();
        if (model instanceof IModelChangeProvider) {
            this.undoManager.connect((IModelChangeProvider)model);
        }
    }

    private void unhookUndo(InputContext context) {
        if (this.undoManager == null) {
            return;
        }
        IBaseModel model = context.getModel();
        if (model instanceof IModelChangeProvider) {
            this.undoManager.disconnect((IModelChangeProvider)model);
        }
    }

    public IModelUndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(IModelUndoManager undoManager) {
        this.undoManager = undoManager;
    }
}

