/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.markers.PDEConfigureProblemSeverityAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolutionRelevance;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class ConfigureProblemSeverityForAPIToolsResolution
extends WorkbenchMarkerResolution
implements IJavaCompletionProposal,
IMarkerResolutionRelevance {
    protected IMarker fBackingMarker = null;
    protected String fCategory = null;

    public ConfigureProblemSeverityForAPIToolsResolution(IMarker marker) {
        this.fBackingMarker = marker;
    }

    protected String resolveCategoryName() {
        if (this.fCategory == null) {
            int problemid = this.fBackingMarker.getAttribute("problemid", -1);
            int category = ApiProblemFactory.getProblemCategory((int)problemid);
            switch (category) {
                case 0x10000000: {
                    this.fCategory = MarkerMessages.FilterProblemResolution_compatible;
                    break;
                }
                case 0x50000000: {
                    this.fCategory = MarkerMessages.FilterProblemResolution_default_profile;
                    break;
                }
                case 0x60000000: {
                    this.fCategory = MarkerMessages.FilterProblemResolution_api_component;
                    break;
                }
                case 0x40000000: {
                    this.fCategory = MarkerMessages.FilterProblemResolution_since_tag;
                    break;
                }
                case 0x20000000: {
                    this.fCategory = MarkerMessages.FilterProblemResolution_usage;
                    break;
                }
                case 0x30000000: {
                    this.fCategory = MarkerMessages.FilterProblemResolution_version_number;
                    break;
                }
            }
        }
        return this.fCategory;
    }

    public String getDescription() {
        try {
            String value = (String)this.fBackingMarker.getAttribute("messagearguments");
            String[] args = new String[]{};
            if (value != null) {
                args = value.split("#");
            }
            int id = this.fBackingMarker.getAttribute("problemid", 0);
            return MessageFormat.format(MarkerMessages.ConfigureProblemSeverity_desc, ApiProblemFactory.getLocalizedMessage((int)ApiProblemFactory.getProblemMessageId((int)id), (String[])args), this.resolveCategoryName());
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public Image getImage() {
        return ApiUIPlugin.getSharedImage("IMG_ELCL_CONFIG_SEV");
    }

    public String getLabel() {
        return MessageFormat.format(MarkerMessages.ConfigureProblemSeverity_label, this.resolveCategoryName());
    }

    public int getRelevance() {
        return -10;
    }

    public void run(IMarker[] markers, IProgressMonitor m) {
        UIJob job = UIJob.create((String)"", monitor -> {
            if (this.fBackingMarker.getAttribute("apiMarkerID", -1) == 1) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                int id = ApiProblemFactory.getProblemId((IMarker)this.fBackingMarker);
                String type = "MISSING_BASELINE_OPTION";
                if (id > -1 && id == ApiProblemFactory.createProblemId((int)0x50000000, (int)7, (int)3, (int)0)) {
                    type = "MISSING_PLUGIN_IN_BASELINE_OPTION";
                }
                Map<String, String> data = Map.of("select_option_key", type);
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.pde.api.tools.ui.apiprofiles.prefpage", null, data).open();
            } else {
                IJavaProject project = JavaCore.create((IProject)this.fBackingMarker.getResource().getProject());
                int id = ApiProblemFactory.getProblemId((IMarker)this.fBackingMarker);
                int tab = -1;
                String key = null;
                key = Util.getAPIToolPreferenceKey((int)id);
                tab = Util.getAPIToolPreferenceTab((int)id);
                new PDEConfigureProblemSeverityAction(project, key, tab).run();
            }
        });
        job.setSystem(true);
        job.schedule();
    }

    public void run(IMarker marker) {
        this.run(new IMarker[]{marker}, null);
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        HashSet<IMarker> mset = new HashSet<IMarker>(markers.length);
        int id = ApiProblemFactory.getProblemId((IMarker)this.fBackingMarker);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            try {
                if (Util.isApiProblemMarker((IMarker)marker) && !this.fBackingMarker.equals((Object)marker) && !marker.getType().equals("org.eclipse.pde.api.tools.unused_filters") && ApiProblemFactory.getProblemId((IMarker)marker) == id) {
                    mset.add(marker);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        int size = mset.size();
        return mset.toArray(new IMarker[size]);
    }

    public void apply(IDocument document) {
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevanceForResolution() {
        return -10;
    }
}

