/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.team.core.ICache;
import org.eclipse.team.core.ICacheListener;

public class Cache
implements ICache {
    Map<String, Object> properties;
    ListenerList<ICacheListener> listeners;

    @Override
    public synchronized void put(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    @Override
    public synchronized Object get(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    @Override
    public synchronized void remove(String name) {
        if (this.properties != null) {
            this.properties.remove(name);
        }
        if (this.properties.isEmpty()) {
            this.properties = null;
        }
    }

    @Override
    public synchronized void addCacheListener(ICacheListener listener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList(1);
        }
        this.listeners.add((Object)listener);
    }

    @Override
    public synchronized void removeDisposeListener(ICacheListener listener) {
        this.removeCacheListener(listener);
    }

    @Override
    public synchronized void removeCacheListener(ICacheListener listener) {
        if (this.listeners != null) {
            this.listeners.remove((Object)listener);
        }
    }

    public void dispose() {
        if (this.listeners != null) {
            for (final ICacheListener listener : this.listeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.cacheDisposed(Cache.this);
                    }

                    public void handleException(Throwable exception) {
                    }
                });
            }
        }
        this.properties = null;
    }
}

