/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.ext;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ext.JDTUtils;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;

public final class VmInstallMetaData {
    public final IVMInstall install;
    public final OSArchitecture arch;
    public final Set<String> compatibleEnvironments;

    private VmInstallMetaData(IVMInstall install, OSArchitecture arch, Collection<String> environments) {
        Preconditions.checkArgument((!OSArchitecture.Unknown.equals((Object)arch) ? 1 : 0) != 0);
        this.install = Objects.requireNonNull(install);
        this.arch = Objects.requireNonNull(arch);
        Preconditions.checkArgument((!environments.isEmpty() ? 1 : 0) != 0);
        this.compatibleEnvironments = Set.copyOf(environments);
    }

    public static Optional<VmInstallMetaData> adapt(IVMInstall install) {
        try {
            OSArchitecture jvmArch = JDTUtils.detect(install);
            if (OSArchitecture.Unknown.equals((Object)jvmArch)) {
                return Optional.empty();
            }
            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
            Set<String> environments = Arrays.stream(manager.getExecutionEnvironments()).filter(env -> Arrays.stream(env.getCompatibleVMs()).anyMatch(install::equals)).map(IExecutionEnvironment::getId).collect(Collectors.toSet());
            return Optional.of(new VmInstallMetaData(install, jvmArch, environments));
        }
        catch (CoreException e) {
            RcpttPlugin.log((Throwable)e);
            return Optional.empty();
        }
    }

    public String formatVmContainerPath() {
        return String.format("org.eclipse.jdt.launching.JRE_CONTAINER/%s/%s", this.install.getVMInstallType().getId(), this.install.getName());
    }

    public static Stream<VmInstallMetaData> all() {
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        HashMultimap environments = HashMultimap.create();
        Arrays.stream(manager.getExecutionEnvironments()).forEach(arg_0 -> VmInstallMetaData.lambda$3((Multimap)environments, arg_0));
        return JDTUtils.installedVms().map(arg_0 -> VmInstallMetaData.lambda$5((Multimap)environments, arg_0)).flatMap(Optional::stream);
    }

    private static Optional<VmInstallMetaData> adapt(IVMInstall install, Collection<IExecutionEnvironment> environments) {
        try {
            OSArchitecture jvmArch = JDTUtils.detect(install);
            if (OSArchitecture.Unknown.equals((Object)jvmArch)) {
                return Optional.empty();
            }
            return Optional.of(new VmInstallMetaData(install, jvmArch, environments.stream().map(IExecutionEnvironment::getId).toList()));
        }
        catch (CoreException e) {
            RcpttPlugin.log((Throwable)e);
            return Optional.empty();
        }
    }

    public static VmInstallMetaData register(Path location) throws CoreException {
        IVMInstall install = JDTUtils.registerVM(location.toFile());
        return VmInstallMetaData.adapt(install).orElseThrow();
    }

    private static /* synthetic */ void lambda$3(Multimap multimap, IExecutionEnvironment env) {
        Arrays.stream(env.getCompatibleVMs()).forEach(vm -> {
            boolean bl = multimap.put(vm, (Object)env);
        });
    }

    private static /* synthetic */ Optional lambda$5(Multimap multimap, IVMInstall vm) {
        return VmInstallMetaData.adapt(vm, multimap.get((Object)vm));
    }
}

