/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation.internal.javadoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavaDoc2HTMLTextReader;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavaDocCommentReader;
import org.eclipse.jdt.core.manipulation.internal.javadoc.JavaDocMessages;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.ui.viewsupport.CoreJavaElementLinks;

public class CoreJavadocContentAccessUtility {
    public static String createMethodInTypeLinks(IMethod overridden) {
        CharSequence methodLink = CoreJavadocContentAccessUtility.createSimpleMemberLink((IMember)overridden, "eclipse-javadoc");
        CharSequence typeLink = CoreJavadocContentAccessUtility.createSimpleMemberLink((IMember)overridden.getDeclaringType(), "eclipse-javadoc");
        String methodInType = MessageFormat.format(JavaDocMessages.JavaDoc2HTMLTextReader_method_in_type, methodLink, typeLink);
        return methodInType;
    }

    public static boolean isWhitespaceTextElement(Object fragment) {
        if (!(fragment instanceof TextElement)) {
            return false;
        }
        TextElement textElement = (TextElement)fragment;
        return textElement.getText().trim().length() == 0;
    }

    public static boolean canInheritJavadoc(IMember member) {
        if (member instanceof IMethod && member.getJavaProject().exists()) {
            try {
                return !((IMethod)member).isConstructor();
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
            }
        }
        return false;
    }

    public static String getString(Reader reader) {
        StringBuilder buf = new StringBuilder();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException e) {
            return null;
        }
        return buf.toString();
    }

    public static String getIFileContent(IFile file) throws CoreException {
        String content = null;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath fullPath = file.getFullPath();
        manager.connect(fullPath, LocationKind.IFILE, null);
        try {
            ITextFileBuffer buffer = manager.getTextFileBuffer(fullPath, LocationKind.IFILE);
            if (buffer != null) {
                content = buffer.getDocument().get();
            }
        }
        finally {
            manager.disconnect(fullPath, LocationKind.IFILE, null);
        }
        return content;
    }

    public static String getFileContentFromAttachedSource(IPackageFragmentRoot root, String filePath) throws CoreException {
        IPath sourceAttachmentPath = root.getSourceAttachmentPath();
        if (sourceAttachmentPath != null) {
            File file = null;
            String encoding = null;
            if (sourceAttachmentPath.getDevice() == null) {
                IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                IResource res = wsRoot.findMember(sourceAttachmentPath);
                if (res instanceof IFile) {
                    IPath location = res.getLocation();
                    if (location == null) {
                        return null;
                    }
                    file = location.toFile();
                    encoding = ((IFile)res).getCharset(false);
                } else if (res instanceof IContainer) {
                    if (!((res = ((IContainer)res).findMember(filePath)) instanceof IFile)) {
                        return null;
                    }
                    encoding = ((IFile)res).getCharset(false);
                    if (encoding == null) {
                        encoding = CoreJavadocContentAccessUtility.getSourceAttachmentEncoding(root);
                    }
                    return CoreJavadocContentAccessUtility.getContentsFromInputStream(((IFile)res).getContents(), encoding);
                }
            }
            if (file == null || !file.exists()) {
                file = sourceAttachmentPath.toFile();
            }
            if (file.isDirectory()) {
                IPath packagedocPath = sourceAttachmentPath.append(filePath);
                if (packagedocPath.toFile().exists()) {
                    return CoreJavadocContentAccessUtility.getFileContent(packagedocPath.toFile());
                }
            } else if (file.exists()) {
                IPath sourceAttachmentRootPath = root.getSourceAttachmentRootPath();
                String packagedocPath = sourceAttachmentRootPath != null ? sourceAttachmentRootPath.append(filePath).toString() : filePath;
                ZipFile zipFile = null;
                InputStream in = null;
                try {
                    zipFile = new ZipFile(file, 1);
                    ZipEntry packagedocFile = zipFile.getEntry(packagedocPath);
                    if (packagedocFile != null) {
                        in = zipFile.getInputStream(packagedocFile);
                        if (encoding == null) {
                            encoding = CoreJavadocContentAccessUtility.getSourceAttachmentEncoding(root);
                        }
                        String string = CoreJavadocContentAccessUtility.getContentsFromInputStream(in, encoding);
                        return string;
                    }
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, JavaManipulationPlugin.getPluginId(), e.getMessage(), (Throwable)e));
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    public static String getSourceAttachmentEncoding(IPackageFragmentRoot root) throws JavaModelException {
        int kind;
        String encoding = ResourcesPlugin.getEncoding();
        IClasspathEntry entry = root.getRawClasspathEntry();
        if (entry != null && ((kind = entry.getEntryKind()) == 1 || kind == 4)) {
            IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
            int n = iClasspathAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathAttribute attrib = iClasspathAttributeArray[n2];
                if ("source_encoding".equals(attrib.getName())) {
                    return attrib.getValue();
                }
                ++n2;
            }
        }
        return encoding;
    }

    public static String getContentsFromInputStream(InputStream in, String encoding) throws CoreException {
        int defaultFileSize = 15360;
        StringBuilder buffer = new StringBuilder(15360);
        Reader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(in, encoding), 15360);
                char[] readBuffer = new char[2048];
                int charCount = reader.read(readBuffer);
                while (charCount > 0) {
                    buffer.append(readBuffer, 0, charCount);
                    charCount = reader.read(readBuffer);
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, JavaManipulationPlugin.getPluginId(), e.getMessage(), (Throwable)e));
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return buffer.toString();
    }

    public static String getFileContent(File file) throws CoreException {
        String content = null;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        Path fullPath = new Path(file.getAbsolutePath());
        manager.connect((IPath)fullPath, LocationKind.LOCATION, null);
        try {
            ITextFileBuffer buffer = manager.getTextFileBuffer((IPath)fullPath, LocationKind.LOCATION);
            if (buffer != null) {
                content = buffer.getDocument().get();
            }
        }
        finally {
            manager.disconnect((IPath)fullPath, LocationKind.LOCATION, null);
        }
        return content;
    }

    public static Javadoc getJavadocNode(IJavaElement element, String rawJavadoc) {
        String source = rawJavadoc + "class C{}";
        CompilationUnit root = CoreJavadocContentAccessUtility.createAST(element, source);
        if (root == null) {
            return null;
        }
        List types = root.types();
        if (types.size() != 1) {
            return null;
        }
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)types.get(0);
        return type.getJavadoc();
    }

    public static Javadoc getPackageJavadocNode(IJavaElement element, String cuSource) {
        PackageDeclaration packDecl;
        CompilationUnit cu = CoreJavadocContentAccessUtility.createAST(element, cuSource);
        if (cu != null && (packDecl = cu.getPackage()) != null) {
            return packDecl.getJavadoc();
        }
        return null;
    }

    public static CompilationUnit createAST(IJavaElement element, String cuSource) {
        Assert.isNotNull((Object)element);
        ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
        IJavaProject javaProject = element.getJavaProject();
        parser.setProject(javaProject);
        Map options = javaProject.getOptions(true);
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions(options);
        parser.setSource(cuSource.toCharArray());
        return (CompilationUnit)parser.createAST(null);
    }

    public static String getHTMLContent(IJarEntryResource jarEntryResource, String encoding) throws CoreException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = jarEntryResource.getContents();){
                return CoreJavadocContentAccessUtility.getContentsFromInputStream(in, encoding);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static CharSequence createSimpleMemberLink(IMember member, String scheme) {
        StringBuffer buf = new StringBuffer();
        buf.append("<a href='");
        try {
            String uri = CoreJavaElementLinks.createURI(scheme, (IJavaElement)member);
            buf.append(uri);
        }
        catch (URISyntaxException e) {
            JavaManipulationPlugin.log(e);
        }
        buf.append("'>");
        JavaElementLabelsCore.getElementLabel((IJavaElement)member, 0L, buf);
        buf.append("</a>");
        return buf;
    }

    public static Reader getContentReader(IMember member, boolean allowInherited) throws JavaModelException {
        Reader contentReader = CoreJavadocContentAccessUtility.internalGetContentReader(member);
        if (contentReader != null || !allowInherited || member.getElementType() != 9) {
            return contentReader;
        }
        return CoreJavadocContentAccessUtility.findDocInHierarchy((IMethod)member, false, false);
    }

    private static Reader internalGetContentReader(IMember member) throws JavaModelException {
        CoreJavaDocCommentReader reader;
        IBuffer buf = member.getOpenable().getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange javadocRange = member.getJavadocRange();
        if (javadocRange != null && !CoreJavadocContentAccessUtility.containsOnlyInheritDoc((Reader)((Object)(reader = new CoreJavaDocCommentReader(buf, javadocRange.getOffset(), javadocRange.getOffset() + javadocRange.getLength() - 1))), javadocRange.getLength())) {
            reader.reset();
            return reader;
        }
        return null;
    }

    private static boolean containsOnlyInheritDoc(Reader reader, int length) {
        char[] content = new char[length];
        try {
            reader.read(content, 0, length);
        }
        catch (IOException e) {
            return false;
        }
        return "{@inheritDoc}".equals(new String(content).trim());
    }

    public static Reader getHTMLContentReader(IMember member, boolean allowInherited, boolean useAttachedJavadoc) throws JavaModelException {
        String s;
        Reader contentReader = CoreJavadocContentAccessUtility.internalGetContentReader(member);
        if (contentReader != null) {
            CoreJavaDoc2HTMLTextReader r = new CoreJavaDoc2HTMLTextReader(contentReader);
            return r;
        }
        if (useAttachedJavadoc && member.getOpenable().getBuffer() == null && (s = member.getAttachedJavadoc(null)) != null) {
            return new StringReader(s);
        }
        if (allowInherited && member.getElementType() == 9) {
            return CoreJavadocContentAccessUtility.findDocInHierarchy((IMethod)member, true, useAttachedJavadoc);
        }
        return null;
    }

    private static Reader findDocInHierarchy(IMethod method, boolean isHTML, boolean useAttachedJavadoc) throws JavaModelException {
        if (!method.getJavaProject().exists()) {
            return null;
        }
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        MethodOverrideTester tester = new MethodOverrideTester(type, hierarchy);
        IType[] iTypeArray = hierarchy.getAllSupertypes(type);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Reader reader;
            IType curr = iTypeArray[n2];
            IMethod overridden = tester.findOverriddenMethodInType(curr, method);
            if (overridden != null && (isHTML ? (reader = CoreJavadocContentAccessUtility.getHTMLContentReader((IMember)overridden, false, useAttachedJavadoc)) != null : (reader = CoreJavadocContentAccessUtility.getContentReader((IMember)overridden, false)) != null)) {
                return reader;
            }
            ++n2;
        }
        return null;
    }
}

