/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ButtonKind implements Enumerator
{
    PUSH(0, "Push", "Push"),
    RADIO(1, "Radio", "Radio"),
    TOGGLE(2, "Toggle", "Toggle"),
    TOOL(3, "Tool", "Tool"),
    ARROW(4, "Arrow", "Arrow"),
    CHECK(5, "Check", "Check");

    public static final int PUSH_VALUE = 0;
    public static final int RADIO_VALUE = 1;
    public static final int TOGGLE_VALUE = 2;
    public static final int TOOL_VALUE = 3;
    public static final int ARROW_VALUE = 4;
    public static final int CHECK_VALUE = 5;
    private static final ButtonKind[] VALUES_ARRAY;
    public static final List<ButtonKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ButtonKind[]{PUSH, RADIO, TOGGLE, TOOL, ARROW, CHECK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ButtonKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ButtonKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ButtonKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ButtonKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ButtonKind get(int value) {
        switch (value) {
            case 0: {
                return PUSH;
            }
            case 1: {
                return RADIO;
            }
            case 2: {
                return TOGGLE;
            }
            case 3: {
                return TOOL;
            }
            case 4: {
                return ARROW;
            }
            case 5: {
                return CHECK;
            }
        }
        return null;
    }

    private ButtonKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

