/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.base.diagnostic.SumOfLists;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.DiagnosticColors;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.HereTable;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.SimpleViewerColumn;
import org.eclipse.passage.lic.internal.jface.i18n.DiagnosticDialogMessages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class TroublesViewer {
    private final Diagnostic diagnostic;
    private final DiagnosticColors colors;
    private TableViewer viewer;

    public TroublesViewer(Shell shell, Diagnostic diagnostic) {
        this.diagnostic = diagnostic;
        this.colors = new DiagnosticColors((Device)(shell == null ? Display.getCurrent() : shell.getDisplay()));
    }

    public void installControl(Composite parent) {
        this.installControl(parent, List.of(new SimpleViewerColumn<Trouble>(DiagnosticDialogMessages.DiagnosticDialog_column_details, 900, Trouble::details), new SimpleViewerColumn<Trouble>(DiagnosticDialogMessages.DiagnosticDialog_column_code, 50, trouble -> Integer.toString(trouble.code().code())), new SimpleViewerColumn<Trouble>(DiagnosticDialogMessages.DiagnosticDialog_column_type, 250, trouble -> trouble.code().explanation())));
    }

    public void installControl(Composite parent, List<SimpleViewerColumn<Trouble>> columns) {
        this.viewer = new HereTable<Trouble>(parent, Trouble.class, this::backdround).withColumns(columns).viewer();
    }

    public void installInput() {
        this.viewer.setInput((Object)new SumOfLists().apply(this.diagnostic.severe(), this.diagnostic.bearable()));
    }

    public TableViewer viewer() {
        return this.viewer;
    }

    private Color backdround(Object element, int column) {
        if (column != 1) {
            return null;
        }
        boolean failure = ((Trouble)element).exception().isPresent();
        boolean severe = this.diagnostic.severe().contains(element);
        return this.colors.get(severe, failure);
    }
}

