/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.api.tests.conditions;

import java.time.ZonedDateTime;
import org.eclipse.passage.lic.api.conditions.ValidityPeriodClosed;
import org.eclipse.passage.lic.api.tests.conditions.ValidityPeriodOpenContractTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class ValidityPeriodClosedContractTest
extends ValidityPeriodOpenContractTest<ValidityPeriodClosed> {
    @Test(expected=Exception.class)
    public final void doNotReverseIncorectBounds() {
        this.forTwoDates(this.movedNow(10), this.movedNow(-10));
    }

    @Test(expected=NullPointerException.class)
    public final void doNotInventTo() {
        this.forTwoDates(ZonedDateTime.now(), null);
    }

    @Test
    public final void fromBeforeTo() {
        ValidityPeriodClosed period = this.forTwoDates(ZonedDateTime.now(), this.movedNow(1));
        Assert.assertTrue((boolean)period.from().isBefore(period.to()));
    }

    @Test
    public final void mustEndWithDefinedTo() {
        this.mustBoundWithDefinedDate(this::someTimeBefore, ValidityPeriodClosed::to);
    }

    protected abstract ValidityPeriodClosed forTwoDates(ZonedDateTime var1, ZonedDateTime var2);

    protected abstract ValidityPeriodClosed someTimeBefore(ZonedDateTime var1);
}

