// This is a generated file, modify: generate/templates/templates/class_content.cc

#include <nan.h>
#include <string.h>

extern "C" {
  #include <git2.h>
 }

#include "../include/nodegit.h"
#include "../include/lock_master.h"
#include "../include/functions/copy.h"
#include "../include/oid_shorten.h"
#include "nodegit_wrapper.cc"
#include "../include/async_libgit2_queue_worker.h"

 
#include <iostream>

using namespace std;
using namespace v8;
using namespace node;

  GitOidShorten::~GitOidShorten() {
    // this will cause an error if you have a non-self-freeing object that also needs
    // to save values. Since the object that will eventually free the object has no
    // way of knowing to free these values.
          }

  void GitOidShorten::InitializeComponent(v8::Local<v8::Object> target) {
    Nan::HandleScope scope;

    v8::Local<FunctionTemplate> tpl = Nan::New<FunctionTemplate>(JSNewFunction);

    tpl->InstanceTemplate()->SetInternalFieldCount(1);
    tpl->SetClassName(Nan::New("OidShorten").ToLocalChecked());

          Nan::SetPrototypeMethod(tpl, "add", Add);
             Nan::SetMethod(tpl, "create", Create);
    
    InitializeTemplate(tpl);

    v8::Local<Function> _constructor_template = Nan::GetFunction(tpl).ToLocalChecked();
    constructor_template.Reset(_constructor_template);
    Nan::Set(target, Nan::New("OidShorten").ToLocalChecked(), _constructor_template);
  }

  
/*
   * @param String text_id
     * @return Number  result    */
NAN_METHOD(GitOidShorten::Add) {
  Nan::EscapableHandleScope scope;

  if (info.Length() == 0 || !info[0]->IsString()) {
    return Nan::ThrowError("String text_id is required.");
  }

// start convert_from_v8 block
  const char * from_text_id = NULL;

  String::Utf8Value text_id(info[0]->ToString());
  // malloc with one extra byte so we can add the terminating null character C-strings expect:
  from_text_id = (const char *) malloc(text_id.length() + 1);
  // copy the characters from the nodejs string into our C-string (used instead of strdup or strcpy because nulls in
  // the middle of strings are valid coming from nodejs):
  memcpy((void *)from_text_id, *text_id, text_id.length());
  // ensure the final byte of our new string is null, extra casts added to ensure compatibility with various C types
  // used in the nodejs binding generation:
  memset((void *)(((char *)from_text_id) + text_id.length()), 0, 1);
// end convert_from_v8 block

  giterr_clear();

  { // lock master scope start
    LockMaster lockMaster(
      /*asyncAction: */false
            ,
              Nan::ObjectWrap::Unwrap<GitOidShorten>(info.This())->GetValue()
            ,
              from_text_id
    );

 int result =     git_oid_shorten_add(
          Nan::ObjectWrap::Unwrap<GitOidShorten>(info.This())->GetValue()
,          from_text_id
    );


      v8::Local<v8::Value> to;
// start convert_to_v8 block
     to = Nan::New<Number>( result);
  // end convert_to_v8 block
        return info.GetReturnValue().Set(scope.Escape(to));
  }
}
   
/*
 * @param Number min_length
     * @return OidShorten  result    */
NAN_METHOD(GitOidShorten::Create) {
  Nan::EscapableHandleScope scope;

  if (info.Length() == 0 || !info[0]->IsNumber()) {
    return Nan::ThrowError("Number min_length is required.");
  }

// start convert_from_v8 block
  size_t from_min_length;
      from_min_length = (size_t)   info[0].As<v8::Number>()->Value();
// end convert_from_v8 block

  giterr_clear();

  { // lock master scope start
    LockMaster lockMaster(
      /*asyncAction: */false
    );

 git_oid_shorten * result =     git_oid_shorten_new(
          from_min_length
    );

        // null checks on pointers
        if (!result) {
          return info.GetReturnValue().Set(scope.Escape(Nan::Undefined()));
        }

      v8::Local<v8::Value> to;
// start convert_to_v8 block
  
  if (result != NULL) {
     // GitOidShorten result
       to = GitOidShorten::New(
        result,
        true
       );
   }
  else {
    to = Nan::Null();
  }

 // end convert_to_v8 block
        return info.GetReturnValue().Set(scope.Escape(to));
  }
}
    // force base class template instantiation, to make sure we get all the
// methods, statics, etc.
template class NodeGitWrapper<GitOidShortenTraits>;
 