/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.orion.server.core.EndingAwareLineReader;

public class IOUtilities {
    public static void pipe(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtilities.pipe(inputStream, outputStream, false, false);
    }

    public static void pipe(InputStream inputStream, OutputStream outputStream, boolean closeIn, boolean closeOut) throws IOException {
        byte[] buffer = new byte[4096];
        int read = 0;
        try {
            while ((read = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, read);
            }
        }
        finally {
            if (closeIn) {
                IOUtilities.safeClose(inputStream);
            }
            if (closeOut) {
                IOUtilities.safeClose(outputStream);
            }
        }
    }

    public static void pipe(Reader input, Writer output) throws IOException {
        IOUtilities.pipe(input, output, false, false);
    }

    public static void pipe(Reader reader, Writer writer, boolean closeReader, boolean closeWriter) throws IOException {
        try {
            char[] buffer = new char[4096];
            int read = 0;
            while ((read = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, read);
            }
        }
        finally {
            if (closeReader) {
                IOUtilities.safeClose(reader);
            }
            if (closeWriter) {
                IOUtilities.safeClose(writer);
            }
        }
    }

    public static String getQueryParameter(HttpServletRequest request, String name) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return null;
        }
        String[] stringArray = queryString.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String paramString = stringArray[n2];
            if (paramString.equals(name) || paramString.startsWith(String.valueOf(name) + "=")) {
                String[] nameAndValue = paramString.split("=", 2);
                if (nameAndValue.length == 2) {
                    return nameAndValue[1];
                }
                return "";
            }
            ++n2;
        }
        return null;
    }

    public static void safeClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static String toString(InputStream is) throws IOException {
        if (is == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        IOUtilities.pipe(new InputStreamReader(is, "UTF-8"), writer, true, false);
        return writer.toString();
    }

    public static InputStream toInputStream(String s) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(s.getBytes("UTF-8"));
    }

    public static Map<String, String> parseMultiPart(InputStream requestStream, String boundary) throws IOException {
        String string = IOUtilities.toString(requestStream);
        EndingAwareLineReader reader = new EndingAwareLineReader(new StringReader(string));
        StringBuilder buf = new StringBuilder();
        HashMap<String, String> parts = new HashMap<String, String>();
        String name = null;
        EndingAwareLineReader.LineDelimiter prev = EndingAwareLineReader.LineDelimiter.EMPTY;
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.equals("--" + boundary)) {
                    if (buf.length() > 0) {
                        parts.put(name, buf.toString());
                        buf.setLength(0);
                    }
                    line = reader.readLine();
                    int i = line.indexOf("name=\"");
                    String s = line.substring(i + "name=\"".length());
                    name = s.substring(0, s.indexOf(34));
                    reader.readLine();
                    if (!name.equals("uploadedfile")) continue;
                    reader.readLine();
                    continue;
                }
                if (line.equals("--" + boundary + "--")) {
                    parts.put(name, buf.toString());
                    continue;
                }
                if (buf.length() > 0) {
                    buf.append((Object)prev);
                }
                buf.append(line);
                prev = reader.getLineDelimiter();
            }
        }
        finally {
            IOUtilities.safeClose(reader);
        }
        return parts;
    }
}

