/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.git.BaseToIndexConverter;
import org.eclipse.orion.server.git.objects.GitObject;

@ResourceDescription(type="Index")
public class Index
extends GitObject {
    public static final String RESOURCE = "index";
    public static final String TYPE = "Index";
    private String pattern;

    public Index(URI cloneLocation, Repository db, String pattern) {
        super(cloneLocation, db);
        this.pattern = pattern;
    }

    public ObjectStream toObjectStream() throws IOException {
        DirCache cache = this.db.readDirCache();
        DirCacheEntry entry = cache.getEntry(this.pattern);
        if (entry == null) {
            return null;
        }
        try {
            ObjectId blobId = entry.getObjectId();
            return this.db.open((AnyObjectId)blobId, 3).openStream();
        }
        catch (MissingObjectException missingObjectException) {
            return null;
        }
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        return BaseToIndexConverter.getIndexLocation(this.cloneLocation, BaseToIndexConverter.CLONE);
    }
}

