/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace.authorization;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationReaderV1;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationReaderV3;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.json.JSONArray;
import org.json.JSONException;

public abstract class AuthorizationReader {
    static AuthorizationReader readerV1 = new AuthorizationReaderV1();
    static AuthorizationReader readerV3 = new AuthorizationReaderV3();
    private static final int CURRENT_VERSION = 3;

    public static JSONArray getAuthorizationData(UserInfo user) throws CoreException {
        JSONArray authInfo;
        AuthorizationReader reader;
        String versionString = user.getProperty("UserRightsVersion");
        int version = -1;
        try {
            version = versionString == null ? 1 : Integer.valueOf(versionString);
        }
        catch (NumberFormatException numberFormatException) {}
        switch (version) {
            case 1: 
            case 2: {
                reader = readerV1;
                break;
            }
            case 3: {
                reader = readerV3;
                break;
            }
            default: {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Unsupported auth data version: " + version));
            }
        }
        try {
            authInfo = reader.readAuthorizationInfo(user);
        }
        catch (JSONException e1) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Failure reading authorization data", (Throwable)e1));
        }
        try {
            if (version != 3) {
                AuthorizationReader.saveRights(user, authInfo);
            }
        }
        catch (CoreException coreException) {}
        return authInfo;
    }

    abstract JSONArray readAuthorizationInfo(UserInfo var1) throws JSONException;

    static void saveRights(UserInfo user, JSONArray userRightArray) throws CoreException {
        user.setProperty("UserRights", userRightArray.toString());
        user.setProperty("UserRightsVersion", Integer.toString(3));
        OrionConfiguration.getMetaStore().updateUser(user);
    }
}

