/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs.jobs;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.rolling.RollingFileAppender;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.logs.ILogService;
import org.eclipse.orion.server.logs.LogUtils;
import org.eclipse.orion.server.logs.objects.RollingFileAppenderResource;
import org.json.JSONArray;
import org.json.JSONObject;

public class ListRollingFileAppendersJob
extends TaskJob {
    private final ILogService logService;
    private final URI baseLocation;

    public ListRollingFileAppendersJob(String userRunningTask, ILogService logService, URI baseLocation) {
        super(userRunningTask, false);
        this.logService = logService;
        this.baseLocation = baseLocation;
    }

    protected IStatus performJob() {
        try {
            List<RollingFileAppender<ILoggingEvent>> appenders = this.logService.getRollingFileAppenders();
            JSONObject appendersJSON = new JSONObject();
            appendersJSON.put("Children", (Object)new JSONArray());
            for (RollingFileAppender<ILoggingEvent> appender : appenders) {
                RollingFileAppenderResource rollingFileAppender = new RollingFileAppenderResource(appender, this.baseLocation);
                if (rollingFileAppender.getArchivedLogFiles() == null) {
                    LogUtils.attachArchivedLogFiles(appender, rollingFileAppender, this.logService);
                }
                appendersJSON.append("Children", (Object)rollingFileAppender.toJSON());
            }
            return new ServerStatus(Status.OK_STATUS, 200, appendersJSON);
        }
        catch (Exception e) {
            return new ServerStatus(4, 500, "An error occured when listing rolling file appenders", (Throwable)e);
        }
    }
}

