/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.cf.commands.AbstractCFApplicationCommand;
import org.eclipse.orion.server.cf.commands.AttachRouteCommand;
import org.eclipse.orion.server.cf.commands.CreateRouteCommand;
import org.eclipse.orion.server.cf.commands.FindRouteCommand;
import org.eclipse.orion.server.cf.commands.GetDomainsCommand;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Domain;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.MultiServerStatus;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindRouteCommand
extends AbstractCFApplicationCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;
    private String appDomain;
    private Domain domain;
    private JSONObject route;
    private boolean noRoute;

    public JSONObject getRoute() {
        return this.route;
    }

    public String getAppDomain() {
        return this.appDomain;
    }

    public String getDomainName() {
        return this.domain != null ? this.domain.getDomainName() : null;
    }

    public BindRouteCommand(Target target, App app) {
        super(target, app);
        Object[] bindings = new String[]{app.getName(), app.getGuid()};
        this.commandName = NLS.bind((String)"Bind a new route to application {1} (guid: {2})", (Object[])bindings);
    }

    @Override
    protected ServerStatus _doIt() {
        MultiServerStatus status = new MultiServerStatus();
        try {
            if (this.noRoute) {
                return status;
            }
            GetDomainsCommand getDomainsCommand = new GetDomainsCommand(this.target);
            ServerStatus jobStatus = (ServerStatus)getDomainsCommand.doIt();
            status.add(jobStatus);
            if (!jobStatus.isOK()) {
                return status;
            }
            List<Domain> domains = getDomainsCommand.getDomains();
            if (domains == null || domains.size() == 0) {
                status.add(new ServerStatus(4, 400, "Failed to find available domains in target", null));
                return status;
            }
            if (!this.appDomain.isEmpty()) {
                for (Domain domain : domains) {
                    if (!this.appDomain.equals(domain.getDomainName())) continue;
                    this.domain = domain;
                    break;
                }
                if (this.domain == null) {
                    String msg = NLS.bind((String)"Failed to find domain {0} in target", (Object)this.appDomain);
                    status.add(new ServerStatus(4, 400, msg, null));
                    return status;
                }
            } else {
                this.domain = domains.get(0);
            }
            String routeGUID = null;
            FindRouteCommand findRouteCommand = new FindRouteCommand(this.target, this.getApplication(), this.domain.getGuid());
            jobStatus = (ServerStatus)findRouteCommand.doIt();
            status.add(jobStatus);
            if (jobStatus.isOK()) {
                this.route = jobStatus.getJsonData();
                routeGUID = this.route.getJSONObject("metadata").getString("guid");
                AttachRouteCommand attachRoute = new AttachRouteCommand(this.target, this.getApplication(), routeGUID);
                jobStatus = (ServerStatus)attachRoute.doIt();
                status.add(jobStatus);
                if (jobStatus.isOK()) {
                    return status;
                }
                String msg = NLS.bind((String)"The host {0} is already used in another space.", (Object)findRouteCommand.getAppHost());
                status.add(new ServerStatus(4, 409, msg, null));
                return status;
            }
            CreateRouteCommand createRoute = new CreateRouteCommand(this.target, this.domain, this.getApplication());
            jobStatus = (ServerStatus)createRoute.doIt();
            status.add(jobStatus);
            if (!jobStatus.isOK()) {
                return status;
            }
            this.route = jobStatus.getJsonData();
            routeGUID = this.route.getJSONObject("metadata").getString("guid");
            AttachRouteCommand attachRoute = new AttachRouteCommand(this.target, this.getApplication(), routeGUID);
            jobStatus = (ServerStatus)attachRoute.doIt();
            status.add(jobStatus);
            if (!jobStatus.isOK()) {
                return status;
            }
            return status;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            status.add(new ServerStatus(4, 500, msg, (Throwable)e));
            return status;
        }
    }

    @Override
    protected IStatus validateParams() {
        try {
            ManifestParseTree manifest = this.getApplication().getManifest();
            ManifestParseTree app = manifest.get("applications").get(0);
            ManifestParseTree domainNode = app.getOpt("domain");
            this.appDomain = domainNode != null ? domainNode.getValue() : "";
            ManifestParseTree noRouteNode = app.getOpt("no-route");
            this.noRoute = noRouteNode != null ? Boolean.parseBoolean(noRouteNode.getValue()) : false;
            return Status.OK_STATUS;
        }
        catch (InvalidAccessException e) {
            return new MultiServerStatus(new ServerStatus(4, 400, e.getMessage(), null));
        }
    }
}

