/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.oauth;

import java.util.Iterator;
import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.token.BasicOAuthToken;
import org.apache.oltu.oauth2.common.token.OAuthToken;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class OAuthTokenResponse
extends OAuthAccessTokenResponse {
    public String getAccessToken() {
        return this.getParam("access_token");
    }

    public Long getExpiresIn() {
        String value = this.getParam("expires_in");
        return value == null ? null : Long.valueOf(value);
    }

    public String getRefreshToken() {
        return this.getParam("refresh_token");
    }

    public String getScope() {
        return this.getParam("scope");
    }

    public String getTokenType() {
        return this.getParam("token_type");
    }

    public OAuthToken getOAuthToken() {
        return new BasicOAuthToken(this.getAccessToken(), this.getExpiresIn(), this.getRefreshToken(), this.getScope());
    }

    protected void setBody(String body) {
        this.body = body;
        if (body != null) {
            JSONObject json = null;
            try {
                json = new JSONObject(body);
            }
            catch (JSONException jSONException) {
                this.parameters = OAuthUtils.decodeForm((String)body);
                return;
            }
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    String value = json.getString(key);
                    if (OAuthUtils.isEmpty((String)value)) continue;
                    this.parameters.put(key, value);
                }
                catch (JSONException jSONException) {}
            }
        }
    }

    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    protected void setResponseCode(int code) {
        this.responseCode = code;
    }

    protected void init(String body, String contentType, int responseCode) throws OAuthProblemException {
        super.init(body, contentType, responseCode);
    }
}

