/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.objects.Index;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitIndexHandlerV1
extends ServletResourceHandler<String> {
    private static final String ADD_ALL_PATTERN = ".";
    private ServletResourceHandler<IStatus> statusHandler;

    GitIndexHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        Repository db = null;
        try {
            Path filePath;
            Path p = new Path(path);
            Object object = filePath = p.hasTrailingSeparator() ? p : p.removeLastSegments(1);
            if (!AuthorizationService.checkRights((String)request.getRemoteUser(), (String)("/" + filePath.toString()), (String)request.getMethod())) {
                response.sendError(403);
                return true;
            }
            Set<Map.Entry<IPath, File>> set = GitUtils.getGitDirs((IPath)filePath, GitUtils.Traverse.GO_UP).entrySet();
            File gitDir = set.iterator().next().getValue();
            if (gitDir == null) {
                return false;
            }
            db = FileRepositoryBuilder.create((File)gitDir);
            switch (GitIndexHandlerV1.getMethod((HttpServletRequest)request)) {
                case GET: {
                    boolean bl = this.handleGet(request, response, db, GitUtils.getRelativePath((IPath)p, set.iterator().next().getKey()));
                    return bl;
                }
                case PUT: {
                    boolean bl = this.handlePut(request, response, db, GitUtils.getRelativePath((IPath)p, set.iterator().next().getKey()));
                    return bl;
                }
                case POST: {
                    boolean bl = this.handlePost(request, response, db, (IPath)p);
                    return bl;
                }
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Failed to process an operation on index for {0}", (Object)path);
            ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
            LogHelper.log((IStatus)status);
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)status);
            return bl;
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    private boolean handleGet(HttpServletRequest request, HttpServletResponse response, Repository db, String pattern) throws CoreException, IOException, ServletException {
        Index index = new Index(null, db, pattern);
        ObjectStream stream = index.toObjectStream();
        if (stream == null) {
            String msg = NLS.bind((String)"{0} not found in index", (Object)pattern);
            if ("true".equals(request.getHeader("read-if-exists"))) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(2, 204, msg, null));
            }
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(0, 404, msg, null));
        }
        response.setHeader("Cache-Control", "no-cache");
        IOUtilities.pipe((InputStream)stream, (OutputStream)response.getOutputStream(), (boolean)true, (boolean)false);
        return true;
    }

    private boolean handlePut(HttpServletRequest request, HttpServletResponse response, Repository db, String pattern) throws ServletException, JSONException, IOException {
        JSONObject toAdd = OrionServlet.readJSONRequest((HttpServletRequest)request);
        JSONArray paths = toAdd.optJSONArray("Path");
        if (paths == null) {
            paths = new JSONArray().put((Object)(pattern.isEmpty() ? ADD_ALL_PATTERN : pattern));
        }
        Git git = Git.wrap((Repository)db);
        AddCommand add = git.add();
        int i = 0;
        while (i < paths.length()) {
            add.addFilepattern(paths.getString(i));
            ++i;
        }
        try {
            add.call();
        }
        catch (GitAPIException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
        }
        add = git.add().setUpdate(true);
        i = 0;
        while (i < paths.length()) {
            add.addFilepattern(paths.getString(i));
            ++i;
        }
        try {
            add.call();
        }
        catch (GitAPIException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
        }
        return true;
    }

    /*
     * WARNING - bad return control flow
     * Enabled aggressive exception aggregation
     */
    private boolean handlePost(HttpServletRequest request, HttpServletResponse response, Repository db, IPath path) throws ServletException, NoFilepatternException, IOException, JSONException {
        JSONObject toReset = OrionServlet.readJSONRequest((HttpServletRequest)request);
        String resetType = toReset.optString("Reset", null);
        if (resetType != null) {
            JSONArray paths = toReset.optJSONArray("Path");
            if (paths != null) {
                String msg = NLS.bind((String)"Mixing {0} and {1} parameters is not allowed.", (Object[])new Object[]{"Path", "Reset"});
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
            }
            String ref = toReset.optString("Commit", "HEAD");
            try {
                ResetCommand.ResetType type = ResetCommand.ResetType.valueOf((String)resetType);
                switch (type) {
                    case SOFT: 
                    case MIXED: 
                    case HARD: {
                        Git git = Git.wrap((Repository)db);
                        try {
                            git.reset().setMode(type).setRef(ref).call();
                        }
                        catch (GitAPIException e) {
                            this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
                        }
                        return true;
                    }
                    case MERGE: 
                    case KEEP: {
                        String msg = NLS.bind((String)"The reset type is not yet supported: {0}.", (Object)resetType);
                        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 501, msg, null));
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String msg = NLS.bind((String)"Unknown or malformed reset type: {0}.", (Object)resetType);
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
            }
        }
        String commit = toReset.optString("Commit", null);
        if (commit != null) {
            String msg = NLS.bind((String)"Mixing {0} and {1} parameters is not allowed.", (Object[])new Object[]{"Path", "Commit"});
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
        }
        JSONArray paths = toReset.optJSONArray("Path");
        Git git = Git.wrap((Repository)db);
        ResetCommand reset = git.reset().setRef("HEAD");
        if (paths != null) {
            int i = 0;
            while (i < paths.length()) {
                reset.addPath(paths.getString(i));
                ++i;
            }
        } else {
            String projectRelativePath = path.removeFirstSegments(3).toString();
            if (projectRelativePath.isEmpty()) {
                String msg = "Path cannot be empty.";
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
            }
            reset.addPath(projectRelativePath);
        }
        try {
            reset.call();
        }
        catch (GitAPIException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, e.getMessage(), (Throwable)e));
        }
        return true;
        return false;
    }
}

