/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.message2;

import com.ibm.icu.text.Normalizer2;

class StringUtils {
    private static final Normalizer2 NFC_NORMALIZER = Normalizer2.getNFCInstance();

    StringUtils() {
    }

    static boolean isSimpleStartChar(int cp) {
        return cp >= 1 && cp <= 8 || cp >= 11 && cp <= 12 || cp >= 14 && cp <= 31 || cp >= 33 && cp <= 45 || cp >= 47 && cp <= 91 || cp >= 93 && cp <= 122 || cp == 124 || cp >= 126 && cp <= 12287 || cp >= 12289 && cp <= 0x10FFFF;
    }

    static boolean isTextChar(int cp) {
        return cp >= 1 && cp <= 91 || cp >= 93 && cp <= 122 || cp == 124 || cp >= 126 && cp <= 0x10FFFF;
    }

    static boolean isBackslash(int cp) {
        return cp == 92;
    }

    static boolean isWhitespace(int cp) {
        return cp == 32 || cp == 9 || cp == 13 || cp == 10 || cp == 12288;
    }

    static boolean isBidi(int cp) {
        return cp == 1564 || cp == 8206 || cp == 8207 || cp >= 8294 && cp <= 8297;
    }

    static boolean isNameStart(int cp) {
        return StringUtils.isAlpha(cp) || cp == 43 || cp == 95 || cp >= 161 && cp <= 1563 || cp >= 1565 && cp <= 5759 || cp >= 5761 && cp <= 8191 || cp >= 8203 && cp <= 8205 || cp >= 8208 && cp <= 8231 || cp >= 8240 && cp <= 8286 || cp >= 8288 && cp <= 8293 || cp >= 8298 && cp <= 12287 || cp >= 12289 && cp <= 55295 || cp >= 57344 && cp <= 64975 || cp >= 65008 && cp <= 65533 || cp >= 65536 && cp <= 131069 || cp >= 131072 && cp <= 196605 || cp >= 196608 && cp <= 262141 || cp >= 262144 && cp <= 327677 || cp >= 327680 && cp <= 393213 || cp >= 393216 && cp <= 458749 || cp >= 458752 && cp <= 524285 || cp >= 524288 && cp <= 589821 || cp >= 589824 && cp <= 655357 || cp >= 655360 && cp <= 720893 || cp >= 720896 && cp <= 786429 || cp >= 786432 && cp <= 851965 || cp >= 851968 && cp <= 917501 || cp >= 917504 && cp <= 983037 || cp >= 983040 && cp <= 1048573 || cp >= 0x100000 && cp <= 1114109;
    }

    static boolean isNameChar(int cp) {
        return StringUtils.isNameStart(cp) || StringUtils.isDigit(cp) || cp == 45 || cp == 46;
    }

    static boolean isQuotedChar(int cp) {
        return cp >= 1 && cp <= 91 || cp >= 93 && cp <= 123 || cp >= 125 && cp <= 0x10FFFF;
    }

    static boolean isAlpha(int cp) {
        return cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90;
    }

    static boolean isDigit(int cp) {
        return cp >= 48 && cp <= 57;
    }

    static boolean isFunctionSigil(int cp) {
        return cp == 58;
    }

    static String toNfc(CharSequence value) {
        return value == null ? null : NFC_NORMALIZER.normalize(value);
    }
}

