/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.revisions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.internal.text.revisions.ChangeRegion;
import org.eclipse.jface.internal.text.revisions.Hunk;
import org.eclipse.jface.text.revisions.RevisionRange;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.swt.graphics.RGB;

public abstract class Revision {
    private final List<ChangeRegion> fChangeRegions = new ArrayList<ChangeRegion>();
    private List<RevisionRange> fRanges = null;

    protected Revision() {
    }

    public final void addRange(ILineRange range) throws IndexOutOfBoundsException {
        this.fChangeRegions.add(new ChangeRegion(this, range));
    }

    public final List<RevisionRange> getRegions() {
        if (this.fRanges == null) {
            ArrayList<RevisionRange> ranges = new ArrayList<RevisionRange>(this.fChangeRegions.size());
            for (ChangeRegion region : this.fChangeRegions) {
                for (ILineRange iLineRange : region.getAdjustedRanges()) {
                    ranges.add(new RevisionRange(this, iLineRange));
                }
            }
            this.fRanges = Collections.unmodifiableList(ranges);
        }
        return this.fRanges;
    }

    final void applyDiff(Hunk[] hunks) {
        this.fRanges = null;
        for (ChangeRegion region : this.fChangeRegions) {
            region.clearDiff();
            Hunk[] hunkArray = hunks;
            int n = hunks.length;
            int n2 = 0;
            while (n2 < n) {
                Hunk hunk = hunkArray[n2];
                region.adjustTo(hunk);
                ++n2;
            }
        }
    }

    public abstract Object getHoverInfo();

    public abstract RGB getColor();

    public abstract String getId();

    public abstract Date getDate();

    public String toString() {
        return "Revision " + this.getId();
    }

    public String getAuthor() {
        return "";
    }
}

