/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.synchronizer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.oomph.internal.ui.AbstractPreferencePage;
import org.eclipse.oomph.setup.ui.SetupPropertyTester;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.synchronizer.Messages;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerManager;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SynchronizerPreferencePage
extends AbstractPreferencePage {
    public static final String ID = "org.eclipse.oomph.setup.SynchronizerPreferencePage";
    private final PageHandler pageHandler = SynchronizerManager.Availability.AVAILABLE ? new StorageHandler() : new DisabledHandler();

    protected Control doCreateContents(Composite parent) {
        return this.pageHandler.createContents(parent);
    }

    protected void performDefaults() {
        this.pageHandler.performDefaults();
        super.performDefaults();
    }

    protected void performApply() {
        this.pageHandler.performApply();
        super.performApply();
    }

    public boolean performOk() {
        this.pageHandler.performOk();
        return super.performOk();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.pageHandler.updateButtons();
    }

    private class DisabledHandler
    extends PageHandler {
        private DisabledHandler() {
        }

        @Override
        public Control createContents(Composite parent) {
            Text text = new Text(parent, 8);
            text.setText(Messages.SynchronizerPreferencePage_disabledHandler_text);
            return text;
        }

        @Override
        public void updateButtons() {
            SynchronizerPreferencePage.this.getApplyButton().setEnabled(false);
            SynchronizerPreferencePage.this.getDefaultsButton().setEnabled(false);
        }
    }

    private abstract class PageHandler {
        private PageHandler() {
        }

        public abstract Control createContents(Composite var1);

        public void updateButtons() {
        }

        public void performOk() {
        }

        public void performApply() {
        }

        public void performDefaults() {
        }
    }

    private class StorageHandler
    extends PageHandler {
        private Button enableButton;
        private Text location;
        private Button browseButton;
        private Button syncButton;
        private Button viewButton;
        private Button deleteButton;
        private boolean initialEnabled = SynchronizerManager.INSTANCE.isSyncEnabled();
        private Path initialLocation = SynchronizerManager.INSTANCE.getSyncLocation();

        @Override
        public Control createContents(Composite parent) {
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            Composite main = new Composite(parent, 0);
            main.setLayout((Layout)layout);
            this.enableButton = new Button(main, 32);
            this.enableButton.setText(Messages.SynchronizerPreferencePage_synchronizeTo_text);
            this.enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StorageHandler.this.updateEnablement();
                }
            });
            this.location = new Text(main, 2052);
            this.location.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            this.browseButton = new Button(main, 8);
            this.browseButton.setText(Messages.SynchronizerPreferencePage_Browse_label);
            this.browseButton.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
            this.syncButton = new Button(main, 8);
            this.syncButton.setText(Messages.SynchronizerPreferencePage_syncButton_text);
            this.syncButton.setLayoutData((Object)new GridData(16384, 4, false, false, layout.numColumns, 1));
            this.syncButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StorageHandler.this.performApply();
                    final Shell shell = SynchronizerPreferencePage.this.getShell();
                    UIUtil.asyncExec((Control)shell, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Object data = shell.getData();
                                if (data instanceof PreferenceDialog) {
                                    PreferenceDialog preferenceDialog = (PreferenceDialog)data;
                                    ReflectUtil.invokeMethod((String)"okPressed", (Object)preferenceDialog);
                                }
                            }
                            catch (Throwable ex) {
                                SetupUIPlugin.INSTANCE.log(ex);
                            }
                        }
                    });
                    UIUtil.asyncExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Shell shell = SetupPropertyTester.getHandlingShell();
                                if (shell != null) {
                                    shell.setVisible(true);
                                } else {
                                    SynchronizerManager.Impact impact = SynchronizerManager.INSTANCE.performFullSynchronization();
                                    if (impact != null && impact.hasLocalImpact()) {
                                        SetupWizard.Updater.perform(false);
                                    }
                                }
                            }
                            catch (Throwable ex) {
                                SetupUIPlugin.INSTANCE.log(ex);
                            }
                        }
                    });
                }
            });
            this.viewButton = new Button(main, 8);
            this.viewButton.setText(Messages.SynchronizerPreferencePage_viewButton_text);
            this.viewButton.setLayoutData((Object)new GridData(16384, 4, false, false, layout.numColumns, 1));
            this.viewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(SynchronizerPreferencePage.this.getShell());
                    try {
                        dialog.run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    File file = File.createTempFile("preference-synchornization-remote", ".xml");
                                    SynchronizerManager.INSTANCE.getRemoteDataProvider().retrieve(file);
                                    final String data = IOUtil.readUTF8((File)file);
                                    UIUtil.asyncExec((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            final Point size = SynchronizerPreferencePage.this.getShell().getSize();
                                            Dialog dialog = new Dialog(SynchronizerPreferencePage.this.getShell()){

                                                protected void configureShell(Shell newShell) {
                                                    super.configureShell(newShell);
                                                    newShell.setText(Messages.SynchronizerPreferencePage_shellText);
                                                }

                                                protected boolean isResizable() {
                                                    return true;
                                                }

                                                protected void createButtonsForButtonBar(Composite parent) {
                                                    this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
                                                }

                                                protected Control createDialogArea(Composite parent) {
                                                    Composite composite = (Composite)super.createDialogArea(parent);
                                                    StyledText text = new StyledText(composite, 2888);
                                                    text.setForeground(composite.getForeground());
                                                    text.setBackground(composite.getBackground());
                                                    GridData gridData = new GridData(4, 4, true, true);
                                                    gridData.widthHint = size.x * 3 / 4;
                                                    gridData.heightHint = size.y * 3 / 4;
                                                    text.setLayoutData((Object)gridData);
                                                    text.setText(data);
                                                    try {
                                                        Pattern xmlPattern = Pattern.compile("<\\??/?[^>]+\\??/?>", 32);
                                                        Pattern attributePattern = Pattern.compile("\\s+([^=\">]+)=\"([^\"]*)\"", 32);
                                                        int index = 0;
                                                        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
                                                        Matcher xmlMatcher = xmlPattern.matcher(data);
                                                        Matcher attributeMatcher = attributePattern.matcher(data);
                                                        while (index != -1 && xmlMatcher.find(index)) {
                                                            int xmlEnd = xmlMatcher.end();
                                                            if (data.charAt(xmlMatcher.start() + 1) != '?') {
                                                                while (attributeMatcher.find(index) && attributeMatcher.end() < xmlEnd) {
                                                                    String attributeName = attributeMatcher.group(1);
                                                                    boolean metaAttribute = attributeName.contains(":");
                                                                    if (!metaAttribute || attributeName.equals("xsi:type")) {
                                                                        StyleRange styleRange = new StyleRange();
                                                                        styleRange.start = attributeMatcher.start(2);
                                                                        styleRange.length = attributeMatcher.end(2) - styleRange.start;
                                                                        styleRange.fontStyle = metaAttribute ? 3 : 1;
                                                                        styleRanges.add(styleRange);
                                                                    }
                                                                    index = attributeMatcher.end();
                                                                }
                                                            }
                                                            index = data.indexOf(60, xmlEnd);
                                                        }
                                                        text.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
                                                    }
                                                    catch (RuntimeException runtimeException) {
                                                        // empty catch block
                                                    }
                                                    return composite;
                                                }
                                            };
                                            dialog.setBlockOnOpen(false);
                                            dialog.open();
                                        }
                                    });
                                }
                                catch (Exception ex) {
                                    SetupUIPlugin.INSTANCE.log(ex);
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        SetupUIPlugin.INSTANCE.log(ex);
                    }
                }
            });
            this.enableButton.setSelection(this.initialEnabled);
            this.location.setText(this.initialLocation.toString());
            UIUtil.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    StorageHandler.this.updateEnablement();
                }
            });
            return main;
        }

        @Override
        public void performDefaults() {
            if (this.enableButton != null) {
                this.enableButton.setSelection(this.initialEnabled);
                this.location.setText(this.initialLocation.toString());
                this.updateEnablement();
            }
        }

        @Override
        public void performApply() {
            if (this.enableButton != null) {
                this.updateEnablement();
            }
        }

        @Override
        public void performOk() {
            if (this.enableButton != null) {
                this.initialEnabled = this.enableButton.getSelection();
                SynchronizerManager.INSTANCE.setSyncEnabled(this.initialEnabled);
                this.initialLocation = Path.of(this.location.getText(), new String[0]);
                SynchronizerManager.INSTANCE.setSyncLocation(this.initialLocation);
            }
        }

        private boolean needsApply() {
            block4: {
                if (this.enableButton == null || this.enableButton.getSelection() == this.initialEnabled) break block4;
                return true;
            }
            try {
                if (this.location != null && !this.location.getText().equals(this.initialLocation.toString())) {
                    return true;
                }
            }
            catch (Exception ex) {
                SetupUIPlugin.INSTANCE.log(ex);
            }
            return false;
        }

        private void updateEnablement() {
            Button applyButton;
            boolean enabled;
            boolean bl = enabled = this.enableButton != null ? this.enableButton.getSelection() : false;
            if (this.location != null) {
                this.location.setEnabled(enabled);
                this.browseButton.setEnabled(enabled);
            }
            if (this.syncButton != null) {
                this.syncButton.setEnabled(enabled);
            }
            if (this.viewButton != null) {
                this.viewButton.setEnabled(enabled);
            }
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(enabled);
            }
            boolean needsApply = this.needsApply();
            Button defaultsButton = SynchronizerPreferencePage.this.getDefaultsButton();
            if (defaultsButton != null) {
                defaultsButton.setEnabled(needsApply);
            }
            if ((applyButton = SynchronizerPreferencePage.this.getApplyButton()) != null) {
                applyButton.setEnabled(needsApply);
            }
        }
    }
}

