/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import org.apache.felix.gogo.runtime.EOFError;
import org.apache.felix.gogo.runtime.SyntaxError;
import org.apache.felix.gogo.runtime.Token;

public class BaseTokenizer {
    protected static final char EOT = '\uffff';
    protected final Token text;
    protected short line;
    protected short column;
    protected char ch;
    protected int index;

    public BaseTokenizer(CharSequence text) {
        this.text = text instanceof Token ? (Token)text : new Token(text);
        this.getch();
    }

    public Token text() {
        return this.text;
    }

    protected void find(char target, char deeper) {
        short sLine = this.line;
        short sCol = this.column;
        int level = 1;
        while (level != 0) {
            if (this.eot()) {
                throw new EOFError(sLine, sCol, "unexpected eof found in the middle of a compound for '" + deeper + target + "'", "compound", Character.toString(target));
            }
            this.getch();
            if (this.ch == '\\') {
                this.escape();
                continue;
            }
            if (this.ch == target) {
                --level;
                continue;
            }
            if (this.ch == deeper) {
                ++level;
                continue;
            }
            if (this.ch != '\"' && this.ch != '\'' && this.ch != '`') continue;
            this.skipQuote();
        }
    }

    protected char escape() {
        assert ('\\' == this.ch);
        short sLine = this.line;
        short sCol = this.column;
        switch (this.getch()) {
            case 'u': {
                this.getch();
                int nb = 0;
                for (int i = 0; i < 4; ++i) {
                    char ch = Character.toUpperCase(this.ch);
                    if (ch >= '0' && ch <= '9') {
                        nb = nb * 16 + (ch - 48);
                        this.getch();
                        continue;
                    }
                    if (ch >= 'A' && ch <= 'F') {
                        nb = nb * 16 + (ch - 65 + 10);
                        this.getch();
                        continue;
                    }
                    if (ch == '\u0000') {
                        throw new EOFError(sLine, sCol, "unexpected EOT in \\ escape", "escape", "0");
                    }
                    throw new SyntaxError(sLine, sCol, "bad unicode", this.text);
                }
                --this.index;
                return (char)nb;
            }
            case '\uffff': {
                throw new EOFError(sLine, sCol, "unexpected EOT in \\ escape", "escape", " ");
            }
            case '\n': {
                return '\u0000';
            }
            case '\"': 
            case '$': 
            case '\'': 
            case '\\': {
                return this.ch;
            }
        }
        return this.ch;
    }

    protected void skipQuote() {
        assert ('\'' == this.ch || '\"' == this.ch);
        char quote = this.ch;
        short sLine = this.line;
        short sCol = this.column;
        while (this.getch() != '\uffff') {
            if (quote == this.ch) {
                return;
            }
            if (quote != '\"' || '\\' != this.ch) continue;
            this.escape();
        }
        throw new EOFError(sLine, sCol, "unexpected EOT looking for matching quote: " + quote, quote == '\"' ? "dquote" : "quote", Character.toString(quote));
    }

    protected void skipSpace() {
        this.skipSpace(false);
    }

    protected void skipSpace(boolean skipNewLines) {
        block0: while (true) {
            if (this.isBlank(this.ch)) {
                this.getch();
                continue;
            }
            if ('\\' == this.ch && this.peek() == '\n') {
                this.getch();
                this.getch();
                continue;
            }
            if (skipNewLines && '\n' == this.ch) {
                this.getch();
                continue;
            }
            if (skipNewLines && '\r' == this.ch && this.peek() == '\n') {
                this.getch();
                this.getch();
                continue;
            }
            if ('/' != this.ch && '#' != this.ch) break;
            if ('#' == this.ch || this.peek() == '/') {
                while (true) {
                    if (this.getch() == '\uffff' || '\n' == this.ch) continue block0;
                }
            }
            if ('*' != this.peek()) break;
            short sLine = this.line;
            short sCol = this.column;
            this.getch();
            while (this.getch() != '\uffff' && ('*' != this.ch || this.peek() != '/')) {
            }
            if ('\uffff' == this.ch) {
                throw new EOFError(sLine, sCol, "unexpected EOT looking for closing comment: */", "comment", "*/");
            }
            this.getch();
            this.getch();
        }
    }

    protected boolean isBlank(char ch) {
        return ' ' == ch || '\t' == ch;
    }

    protected boolean eot() {
        return this.index >= this.text.length();
    }

    protected char getch() {
        this.ch = this.getch(false);
        return this.ch;
    }

    protected char peek() {
        return this.getch(true);
    }

    protected char getch(boolean peek) {
        if (this.eot()) {
            if (!peek) {
                ++this.index;
                this.ch = (char)65535;
            }
            return '\uffff';
        }
        int current = this.index;
        char c = this.text.charAt(this.index++);
        if (peek) {
            this.index = current;
        } else if ('\n' == c) {
            this.line = (short)(this.line + 1);
            this.column = 0;
        } else {
            this.column = (short)(this.column + 1);
        }
        return c;
    }
}

