/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.AsyncReadyCallback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SyncDialogUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    RGB[] rgbs;

    public ColorDialog(Shell parent) {
        this(parent, 65536);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, ColorDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB[] getRGBs() {
        return this.rgbs;
    }

    public RGB open() {
        boolean success;
        int response;
        byte[] buffer = Converter.javaStringToCString(this.title);
        final long handle = GTK.GTK_VERSION >= OS.VERSION(4, 10, 0) ? GTK4.gtk_color_dialog_new() : GTK.gtk_color_chooser_dialog_new(buffer, this.parent.topHandle());
        if (handle == 0L) {
            this.error(2);
        }
        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
            GTK4.gtk_color_dialog_set_modal(handle, true);
            GTK4.gtk_color_dialog_set_title(handle, buffer);
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        GdkRGBA rgba = new GdkRGBA();
        if (this.rgb != null) {
            rgba.red = (double)this.rgb.red / 255.0;
            rgba.green = (double)this.rgb.green / 255.0;
            rgba.blue = (double)this.rgb.blue / 255.0;
            rgba.alpha = 1.0;
        }
        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
            if (GTK4.gtk_color_dialog_get_with_alpha(handle)) {
                GTK4.gtk_color_dialog_set_with_alpha(handle, false);
            }
        } else {
            GTK.gtk_color_chooser_set_rgba(handle, rgba);
            if (this.rgbs != null) {
                int colorsPerRow = 9;
                long gdkRGBAS = OS.g_malloc(GdkRGBA.sizeof * this.rgbs.length);
                rgba = new GdkRGBA();
                int i = 0;
                while (i < this.rgbs.length) {
                    RGB rgbS = this.rgbs[i];
                    if (rgbS != null) {
                        rgba.red = (double)rgbS.red / 255.0;
                        rgba.green = (double)rgbS.green / 255.0;
                        rgba.blue = (double)rgbS.blue / 255.0;
                        OS.memmove(gdkRGBAS + (long)(i * GdkRGBA.sizeof), rgba, (long)GdkRGBA.sizeof);
                    }
                    ++i;
                }
                GTK.gtk_color_chooser_add_palette(handle, 0, colorsPerRow, this.rgbs.length, gdkRGBAS);
                GTK.gtk_color_chooser_set_rgba(handle, rgba);
                if (GTK.gtk_color_chooser_get_use_alpha(handle)) {
                    GTK.gtk_color_chooser_set_use_alpha(handle, false);
                }
                OS.g_free(gdkRGBAS);
            }
        }
        display.addIdleProc();
        Dialog oldModal = null;
        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0) ? GTK4.gtk_color_dialog_get_modal(handle) : GTK.gtk_window_get_modal(handle)) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        int signalId = 0;
        long hookId = 0L;
        if ((this.style & 0x4000000) != 0) {
            signalId = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            hookId = OS.g_signal_add_emission_hook(signalId, 0, display.emissionProc, handle, 0L);
        }
        if (GTK.GTK4) {
            if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
                GdkRGBA initialColor;
                final long shellHandle = this.parent != null ? this.parent.topHandle() : 0L;
                long gdkRGBA = SyncDialogUtil.run(display, new AsyncReadyCallback(initialColor = rgba){
                    private final /* synthetic */ GdkRGBA val$initialColor;
                    {
                        this.val$initialColor = gdkRGBA;
                    }

                    @Override
                    public void async(long callback) {
                        GTK4.gtk_color_dialog_choose_rgba(handle, shellHandle, this.val$initialColor, 0L, callback, 0L);
                    }

                    @Override
                    public long await(long result) {
                        return GTK4.gtk_color_dialog_choose_rgba_finish(handle, result, null);
                    }
                });
                if (gdkRGBA != 0L) {
                    OS.memmove(rgba, gdkRGBA, (long)GdkRGBA.sizeof);
                    GDK.gdk_rgba_free(gdkRGBA);
                    response = -5;
                } else {
                    response = -6;
                }
            } else {
                response = SyncDialogUtil.run(display, handle, false);
            }
        } else {
            display.externalEventLoop = true;
            display.sendPreExternalEventDispatchEvent();
            response = GTK3.gtk_dialog_run(handle);
            display.externalEventLoop = false;
            display.sendPostExternalEventDispatchEvent();
        }
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(signalId, hookId);
        }
        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0) ? GTK4.gtk_color_dialog_get_modal(handle) : GTK.gtk_window_get_modal(handle)) {
            display.setModalDialog(oldModal);
        }
        boolean bl = success = response == -5;
        if (success) {
            int red = 0;
            int green = 0;
            int blue = 0;
            if (GTK.GTK_VERSION < OS.VERSION(4, 10, 0)) {
                rgba = new GdkRGBA();
                GTK.gtk_color_chooser_get_rgba(handle, rgba);
            }
            red = (int)(rgba.red * 255.0);
            green = (int)(rgba.green * 255.0);
            blue = (int)(rgba.blue * 255.0);
            this.rgb = new RGB(red, green, blue);
        } else {
            this.rgb = null;
        }
        display.removeIdleProc();
        if (GTK.GTK4) {
            if (GTK.GTK_VERSION < OS.VERSION(4, 10, 0)) {
                GTK4.gtk_window_destroy(handle);
            }
        } else {
            GTK3.gtk_widget_destroy(handle);
        }
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }

    public void setRGBs(RGB[] rgbs) {
        this.rgbs = rgbs;
    }

    static String[] splitString(String text, char ch) {
        String[] substrings = new String[1];
        int start = 0;
        int pos = 0;
        while (pos != -1) {
            pos = text.indexOf(ch, start);
            if (pos == -1) {
                substrings[substrings.length - 1] = text.substring(start);
                continue;
            }
            substrings[substrings.length - 1] = text.substring(start, pos);
            start = pos + 1;
            String[] newSubstrings = new String[substrings.length + 1];
            System.arraycopy(substrings, 0, newSubstrings, 0, substrings.length);
            substrings = newSubstrings;
        }
        return substrings;
    }
}

