/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess.providers;

import java.util.Objects;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class ActionElement
extends QuickAccessElement {
    private ActionContributionItem item;

    ActionElement(ActionContributionItem item) {
        this.item = item;
    }

    @Override
    public void execute() {
        this.item.getAction().run();
    }

    @Override
    public String getId() {
        return this.item.getId();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.item.getAction().getImageDescriptor();
    }

    @Override
    public String getLabel() {
        IAction action = this.item.getAction();
        if (action.getToolTipText() != null && action.getToolTipText().length() != 0) {
            return LegacyActionTools.removeMnemonics((String)(String.valueOf(action.getText()) + " - " + action.getToolTipText()));
        }
        return LegacyActionTools.removeMnemonics((String)action.getText());
    }

    public int hashCode() {
        return Objects.hashCode(this.item);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActionElement other = (ActionElement)obj;
        return Objects.equals(this.item, other.item);
    }
}

