/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.ui.internal;

import java.util.Arrays;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.userstorage.IStorageService;

public class ServicesContentProvider
implements IStructuredContentProvider,
IStorageService.Registry.Listener {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private Viewer viewer;
    private IStorageService.Registry registry;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.dispose();
        this.viewer = viewer;
        this.registry = (IStorageService.Registry)newInput;
        if (this.registry != null) {
            this.registry.addListener((IStorageService.Registry.Listener)this);
        }
    }

    public void serviceAdded(IStorageService service) {
        this.refreshViewer();
    }

    public void serviceRemoved(IStorageService service) {
        this.refreshViewer();
    }

    public Object[] getElements(Object inputElement) {
        if (this.registry != null) {
            Object[] services = this.registry.getServices();
            Arrays.sort(services);
            return services;
        }
        return NO_ELEMENTS;
    }

    public void dispose() {
        if (this.registry != null) {
            this.registry.removeListener((IStorageService.Registry.Listener)this);
        }
    }

    private void refreshViewer() {
        if (this.viewer != null) {
            final Control control = this.viewer.getControl();
            control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!control.isDisposed()) {
                        ServicesContentProvider.this.viewer.refresh();
                    }
                }
            });
        }
    }
}

