/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import java.util.Arrays;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.AnchorMapping;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutScope;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.MethodSignatureEnhancer;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class MethodSpec
extends ASTNode
implements InvocationSite {
    public char[] selector;
    public TypeReference returnType;
    public boolean hasSignature;
    public boolean covariantReturn;
    public Argument[] arguments;
    public TypeParameter[] typeParameters;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public TypeBinding[] parameters;
    public MethodBinding resolvedMethod;
    public boolean[] argNeedsTranslation;
    public boolean returnNeedsTranslation;
    public boolean isDeclaration = false;
    public int callinID = -1;
    public ImplementationStrategy implementationStrategy = ImplementationStrategy.DIRECT;

    public MethodSpec(AbstractMethodDeclaration md) {
        this.hasSignature = true;
        this.selector = md.selector;
        this.sourceStart = md.sourceStart;
        this.sourceEnd = md.sourceStart + md.selector.length - 1;
        this.declarationSourceStart = md.declarationSourceStart;
        this.declarationSourceEnd = md.sourceEnd;
        if (md instanceof MethodDeclaration) {
            this.typeParameters = ((MethodDeclaration)md).typeParameters;
            this.returnType = ((MethodDeclaration)md).returnType;
        } else {
            this.returnType = new SingleTypeReference(TypeConstants.VOID, ((long)this.sourceStart << 32) + (long)this.sourceStart);
            this.returnType.sourceStart = md.sourceStart;
            this.returnType.sourceEnd = md.sourceStart;
        }
        this.arguments = md.arguments;
        if (this.arguments != null) {
            this.argNeedsTranslation = new boolean[this.arguments.length];
            Arrays.fill(this.argNeedsTranslation, false);
        }
    }

    public MethodSpec(char[] ident, long pos) {
        this.hasSignature = false;
        this.selector = ident;
        this.sourceStart = (int)(pos >>> 32);
        this.sourceEnd = (int)(pos & 0xFFFFFFFFFFFFFFFFL);
        this.declarationSourceStart = this.sourceStart;
        this.declarationSourceEnd = this.sourceEnd;
    }

    public MethodSpec(char[] ident, int sStart, int sEnd) {
        this.hasSignature = false;
        this.selector = ident;
        this.sourceStart = sStart;
        this.sourceEnd = sEnd;
        this.declarationSourceStart = this.sourceStart;
        this.declarationSourceEnd = this.sourceEnd;
    }

    public StringBuffer printReturnType(int indent, StringBuffer output) {
        if (this.returnType != null) {
            this.returnType.print(indent, output);
            if (this.covariantReturn) {
                output.append('+');
            }
            output.append(' ');
        }
        return output;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        MethodSpec.printIndent(indent, output);
        if (this.hasSignature) {
            this.printReturnType(0, output);
            output.append(String.valueOf(new String(this.selector)) + "(");
            if (this.arguments != null) {
                int i = 0;
                while (i < this.arguments.length) {
                    this.arguments[i].print(indent, output);
                    if (i != this.arguments.length - 1) {
                        output.append(", ");
                    }
                    ++i;
                }
            }
            output.append(")");
        } else {
            output.append(new String(this.selector));
        }
        return output;
    }

    public void resolveTypes(CallinCalloutScope scope, boolean isBaseSide) {
        if (this.typeParameters != null) {
            int i = 0;
            int length = this.typeParameters.length;
            while (i < length) {
                if (isBaseSide) {
                    scope.problemReporter().illegalMappingRHSTypeParameter(this.typeParameters[i]);
                } else {
                    this.typeParameters[i].resolve(scope);
                }
                ++i;
            }
            if (!isBaseSide) {
                scope.connectTypeVariables(this.typeParameters, true);
            }
        }
        TypeBinding[] types = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            types = new TypeBinding[this.arguments.length];
            int i = 0;
            while (i < this.arguments.length) {
                TypeReference type = this.arguments[i].type;
                if (isBaseSide) {
                    type.setBaseclassDecapsulation(Expression.DecapsulationState.ALLOWED);
                }
                types[i] = type.resolveType(scope);
                if (types[i] != null) {
                    type.resolvedType = types[i] = RoleTypeCreator.maybeWrapUnqualifiedRoleType(scope, types[i], (ASTNode)this.arguments[i]);
                } else {
                    types[i] = type.resolvedType;
                    if (types[i] == null) {
                        types[i] = new ProblemReferenceBinding(type.getTypeName(), null, 1);
                    }
                }
                this.arguments[i].bind(scope, types[i], false);
                ++i;
            }
        }
        if (this.hasSignature) {
            this.argNeedsTranslation = new boolean[types.length];
        }
        if (this.returnType != null) {
            if (isBaseSide) {
                this.returnType.setBaseclassDecapsulation(Expression.DecapsulationState.ALLOWED);
            }
            this.returnType.resolve(scope);
            if (this.returnType.resolvedType != null) {
                this.returnType.resolvedType = RoleTypeCreator.maybeWrapUnqualifiedRoleType(scope, this.returnType.resolvedType, (ASTNode)this.returnType);
            }
        }
        this.parameters = types;
    }

    public void resolveFinished() {
    }

    public MethodBinding resolveFeature(ReferenceBinding receiverType, BlockScope scope, boolean callinExpected, boolean isBaseSide, boolean allowEnclosing) {
        ReferenceBinding receiverClass = receiverType.getRealClass();
        if (this.hasSignature) {
            TypeBinding[] enhancedParameters = this.parameters;
            enhancedParameters = MethodSignatureEnhancer.enhanceParameters(scope, this.parameters);
            CompilationResult compilationResult = scope.referenceContext().compilationResult();
            CompilationResult.CheckPoint cp = compilationResult.getCheckPoint(scope.referenceContext());
            this.resolvedMethod = TypeAnalyzer.findMethod(scope, receiverClass, this.selector, enhancedParameters, isBaseSide);
            if (!this.resolvedMethod.isValidBinding() && this.resolvedMethod.problemId() == 1) {
                while (receiverClass != null) {
                    compilationResult.rollBack(cp);
                    MethodBinding plainMethod = TypeAnalyzer.findMethod(scope, receiverClass, this.selector, this.parameters, isBaseSide);
                    if (!callinExpected) {
                        this.resolvedMethod = plainMethod;
                    } else {
                        if (plainMethod != null && plainMethod.isValidBinding()) {
                            scope.problemReporter().replaceMappingToNonCallin(this, plainMethod);
                        }
                        this.resolvedMethod.modifiers |= 0x80000008;
                    }
                    if (plainMethod == null || !plainMethod.isValidBinding()) {
                        receiverClass = allowEnclosing ? receiverClass.enclosingType() : null;
                        continue;
                    }
                    break;
                }
            }
        } else {
            CompilationResult compilationResult = scope.referenceContext().compilationResult();
            CompilationResult.CheckPoint cp = compilationResult.getCheckPoint(scope.referenceContext());
            while (receiverClass != null) {
                this.resolvedMethod = receiverClass.getMethod(scope, this.selector);
                if ((this.resolvedMethod == null || !this.resolvedMethod.isValidBinding()) && allowEnclosing) {
                    compilationResult.rollBack(cp);
                    receiverClass = receiverClass.enclosingType();
                    continue;
                }
                break;
            }
        }
        if (this.resolvedMethod != null) {
            if (this.resolvedMethod.isValidBinding() && !isBaseSide && scope.referenceContext() instanceof CallinMappingDeclaration && !this.resolvedMethod.canBeSeenBy(this, scope)) {
                scope.problemReporter().invisibleMethod(this, this.resolvedMethod);
                this.resolvedMethod = new ProblemMethodBinding(this.resolvedMethod, this.selector, this.parameters, 2);
            }
            if (!this.resolvedMethod.isValidBinding() && this.resolvedMethod.declaringClass == null) {
                this.resolvedMethod.declaringClass = receiverClass;
            }
        }
        return this.resolvedMethod;
    }

    public void resolveFeatureWithArgMapping(ReferenceBinding receiverType, BlockScope scope, boolean isBaseSide, boolean callinExpected, boolean allowEnclosing) {
        FieldReference receiver = null;
        if (isBaseSide) {
            ReferenceContext referenceContext = scope.referenceContext();
            CompilationResult.CheckPoint cp = referenceContext.compilationResult().getCheckPoint(referenceContext);
            receiver = new FieldReference(IOTConstants._OT_BASE, 0L);
            try {
                receiver.receiver = ThisReference.implicitThis();
                receiver.resolveType(scope);
            }
            finally {
                if (receiver.binding == null || !receiver.binding.isValidBinding()) {
                    receiver.resolvedType = receiverType;
                    referenceContext.compilationResult().rollBack(cp);
                }
            }
        }
        AnchorMapping anchorMapping = null;
        try {
            anchorMapping = AnchorMapping.setupNewMapping(receiver, this.arguments, scope);
            this.resolveFeature(receiverType, scope, callinExpected, isBaseSide, allowEnclosing);
        }
        catch (Throwable throwable) {
            AnchorMapping.removeCurrentMapping(anchorMapping);
            throw throwable;
        }
        AnchorMapping.removeCurrentMapping(anchorMapping);
    }

    public TypeBinding[] resolvedParameters() {
        if ((this.parameters == null || this.parameters == Binding.NO_PARAMETERS) && this.resolvedMethod != null) {
            this.parameters = this.resolvedMethod.getSourceParameters();
        }
        return this.parameters;
    }

    public TypeBinding resolvedType() {
        TypeBinding declaredType;
        if (this.returnType != null && (declaredType = this.returnType.resolvedType) != null && declaredType.isValidBinding()) {
            return declaredType;
        }
        return this.boundMethodReturnType();
    }

    private TypeBinding boundMethodReturnType() {
        if (this.resolvedMethod == null) {
            return new ProblemReferenceBinding("<missing>".toCharArray(), null, 1);
        }
        if (this.resolvedMethod.isCallin()) {
            return MethodModel.getReturnType(this.resolvedMethod);
        }
        return this.resolvedMethod.returnType;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.returnType != null) {
                this.returnType.traverse(visitor, scope);
            }
            if (this.arguments != null) {
                int argumentLength = this.arguments.length;
                int i = 0;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    public void initTranslationBits() {
        int numArgs = 0;
        if (this.resolvedMethod.parameters != null) {
            numArgs = this.resolvedMethod.parameters.length;
        }
        this.argNeedsTranslation = new boolean[numArgs];
        Arrays.fill(this.argNeedsTranslation, false);
    }

    public boolean argNeedsTranslation(int idx) {
        if (this.argNeedsTranslation == null) {
            return false;
        }
        if (idx < 0 || idx >= this.argNeedsTranslation.length) {
            return false;
        }
        return this.argNeedsTranslation[idx];
    }

    public void checkResolutionSuccess(ReferenceBinding type, CallinCalloutScope scope) {
        boolean isCallout = ((AbstractMethodMappingDeclaration)scope.referenceContext).isCallout();
        if (this.resolvedMethod == null) {
            scope.problemReporter().unresolvedMethodSpec(this, type, isCallout);
            this.resolvedMethod = new ProblemMethodBinding(this.selector, Binding.NO_PARAMETERS, type, 1);
            this.resolvedMethod.returnType = scope.getJavaLangObject();
            return;
        }
        if (!this.resolvedMethod.isValidBinding()) {
            switch (this.resolvedMethod.problemId()) {
                case 3: {
                    scope.problemReporter().ambiguousMethodMapping(this, type, isCallout);
                    return;
                }
                case 2: {
                    ReferenceBinding declaringClass = this.resolvedMethod.declaringClass;
                    if (!declaringClass.isRole() && ((ProblemMethodBinding)this.resolvedMethod).closestMatch.isProtected()) {
                        this.resolvedMethod = ((ProblemMethodBinding)this.resolvedMethod).closestMatch;
                        break;
                    }
                }
                default: {
                    scope.problemReporter().missingImplementation(this, "Unexpected compile error at MethodSpec " + this);
                    return;
                }
            }
        }
        this.initTranslationBits();
    }

    public void checkStaticness(CallinMappingDeclaration mappingDeclaration, boolean shouldBeStatic) {
        if (this.resolvedMethod.isStatic() != shouldBeStatic) {
            if (mappingDeclaration.isReplaceCallin() && !this.resolvedMethod.isStatic()) {
                mappingDeclaration.scope.problemReporter().replaceCallinIncompatibleStatic(mappingDeclaration, this);
            } else {
                mappingDeclaration.scope.problemReporter().callinIncompatibleStatic(mappingDeclaration, this);
            }
        }
    }

    void checkDecapsulation(ReferenceBinding baseClass, Scope scope) {
        if (!this.resolvedMethod.canBeSeenBy(baseClass, this, scope)) {
            this.implementationStrategy = CallinImplementorDyn.DYNAMIC_WEAVING ? ImplementationStrategy.DYN_ACCESS : ImplementationStrategy.DECAPS_WRAPPER;
            scope.problemReporter().decapsulation(this, baseClass, scope);
        } else {
            this.implementationStrategy = ImplementationStrategy.DIRECT;
        }
    }

    public boolean checkRoleReturnType(CallinCalloutScope scope, boolean isCallout) {
        TypeBinding methodReturn = this.boundMethodReturnType();
        TypeBinding resolvedReturnType = this.returnType.resolvedType;
        TypeBinding firstBound = null;
        if (resolvedReturnType.isTypeVariable()) {
            firstBound = ((TypeVariableBinding)resolvedReturnType).firstBound;
            if (!this.isMethodReturnTypeVariable(this.resolvedMethod)) {
                scope.problemReporter().differentReturnInMethodSpec(this, false);
                return false;
            }
        }
        if (isCallout && this.returnType.resolvedType.isCompatibleWith(methodReturn)) {
            return true;
        }
        if (!(MethodModel.hasUnboundedReturnType(this.resolvedMethod) || TypeAnalyzer.isSameType(scope.enclosingSourceType(), resolvedReturnType, methodReturn) || TypeAnalyzer.isSameType(scope.enclosingSourceType(), firstBound, methodReturn))) {
            scope.problemReporter().differentReturnInMethodSpec(this, ((AbstractMethodMappingDeclaration)scope.referenceContext).isCallout());
            return false;
        }
        return true;
    }

    private boolean isMethodReturnTypeVariable(MethodBinding method) {
        if (method instanceof ParameterizedGenericMethodBinding) {
            ParameterizedGenericMethodBinding pMethod = (ParameterizedGenericMethodBinding)method;
            return pMethod.original().returnType.isTypeVariable();
        }
        if (method instanceof ProblemMethodBinding) {
            return method.returnType.isTypeVariable();
        }
        return false;
    }

    public boolean checkBaseReturnType(CallinCalloutScope scope, int bindDir) {
        TypeBinding methodReturn = this.boundMethodReturnType();
        if (!TypeAnalyzer.isSameType(scope.enclosingSourceType(), this.returnType.resolvedType, methodReturn)) {
            if (RoleTypeCreator.isCompatibleViaBaseAnchor(scope, methodReturn, this.returnType.resolvedType, bindDir)) {
                return true;
            }
            if ((methodReturn.tagBits & 0x80L) == 0L) {
                scope.problemReporter().differentReturnInMethodSpec(this, ((AbstractMethodMappingDeclaration)scope.referenceContext).isCallout());
            }
            return false;
        }
        return true;
    }

    public boolean checkParameterTypes(CallinCalloutScope scope, boolean isBase) {
        TypeBinding[] realParameters = this.resolvedMethod.getSourceParameters();
        int i = 0;
        while (i < realParameters.length) {
            TypeReference specifiedArgType = this.arguments[i].type;
            TypeBinding realParameter = realParameters[i];
            if (realParameter.isValidBinding() && specifiedArgType.resolvedType != null) {
                ReferenceBinding baseclass = scope.enclosingReceiverType().baseclass();
                if (isBase && baseclass != null && baseclass.isTeam() && realParameter.isRole()) {
                    realParameter = TeamModel.strengthenRoleType(baseclass, realParameter);
                }
                if (!TypeAnalyzer.isSameType(scope.enclosingSourceType(), specifiedArgType.resolvedType, realParameter)) {
                    scope.problemReporter().differentParamInMethodSpec(this, specifiedArgType, realParameter, ((AbstractMethodMappingDeclaration)scope.referenceContext).isCallout());
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean isValid() {
        return this.resolvedMethod != null && this.resolvedMethod.isValidBinding();
    }

    public int problemId() {
        if (this.resolvedMethod == null) {
            return 1;
        }
        return this.resolvedMethod.problemId();
    }

    public char[] readableName() {
        if (this.resolvedMethod != null) {
            return this.resolvedMethod.readableName();
        }
        return this.selector;
    }

    public void updateTSuperMethod(ReferenceBinding type) {
        if (this.resolvedMethod == null) {
            return;
        }
        if (TSuperHelper.isTSuper(this.resolvedMethod)) {
            MethodBinding[] methods = type.methods();
            if (methods != null) {
                int i = 0;
                while (i < methods.length) {
                    if (methods[i].overridesTSuper(this.resolvedMethod)) {
                        this.resolvedMethod = methods[i];
                        return;
                    }
                    ++i;
                }
            }
            throw new InternalCompilerError("tsuper method not overridden by any method");
        }
    }

    public char[] signature() {
        return MethodSpec.signature(this.resolvedMethod);
    }

    public static char[] signature(MethodBinding method) {
        TypeBinding returnType;
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        int offset = method.isCallin() ? MethodSignatureEnhancer.ENHANCING_ARG_LEN : 0;
        int paramLen = method.parameters.length;
        int i = offset;
        while (i < paramLen) {
            TypeBinding targetParameter = method.getCodeGenType(i);
            buffer.append(targetParameter.signature());
            ++i;
        }
        buffer.append(')');
        TypeBinding sourceReturnType = method.isCallin() ? MethodModel.getReturnType(method) : method.returnType;
        MethodBinding tsuperOriginal = (method.tagBits & Long.MIN_VALUE) != 0L ? method.copyInheritanceSrc.original() : null;
        TypeBinding typeBinding = returnType = tsuperOriginal != null && tsuperOriginal.returnType.isTypeVariable() && !sourceReturnType.isTypeVariable() ? tsuperOriginal.returnType : sourceReturnType;
        if (returnType.isTypeVariable() && method instanceof ParameterizedGenericMethodBinding) {
            returnType = ((ParameterizedGenericMethodBinding)method).reverseSubstitute((TypeVariableBinding)returnType);
        }
        buffer.append(returnType.erasure().signature());
        int nameLength = buffer.length();
        char[] signature = new char[nameLength];
        buffer.getChars(0, nameLength, signature, 0);
        return signature;
    }

    public boolean isPrivate() {
        return this.resolvedMethod != null && this.resolvedMethod.isPrivate();
    }

    public ReferenceBinding getDeclaringClass() {
        if (this.resolvedMethod != null) {
            return this.resolvedMethod.declaringClass;
        }
        return null;
    }

    public boolean isCallin() {
        return this.resolvedMethod != null && this.resolvedMethod.isCallin();
    }

    public boolean isStatic() {
        return this.resolvedMethod != null && this.resolvedMethod.isStatic();
    }

    public int getTranslationFlags() {
        int translations = 0;
        if (this.argNeedsTranslation != null) {
            int i = 0;
            while (i < this.argNeedsTranslation.length) {
                if (this.argNeedsTranslation[i]) {
                    translations |= 2 << i;
                }
                ++i;
            }
        }
        if (this.returnNeedsTranslation) {
            translations |= 1;
        }
        return translations;
    }

    public int getCallinId(TeamModel theTeam) {
        if (this.callinID == -1) {
            this.callinID = theTeam.getNewCallinId(this);
        }
        return this.callinID;
    }

    public boolean canBeeSeenBy(ReferenceBinding receiverType, Scope scope) {
        if (this.resolvedMethod == null) {
            return false;
        }
        return this.resolvedMethod.canBeSeenBy(receiverType, this, scope);
    }

    public TypeBinding[] genericTypeArguments() {
        return null;
    }

    public boolean isSuperAccess() {
        return true;
    }

    public boolean isTypeAccess() {
        return this.resolvedMethod != null && this.resolvedMethod.isStatic();
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    public void setDepth(int depth) {
    }

    public void setFieldIndex(int depth) {
    }

    public TypeBinding expectedType() {
        return null;
    }

    public void createAccessAttribute(RoleModel roleModel) {
        roleModel.addInaccessibleBaseMethod(this.resolvedMethod);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImplementationStrategy {
        DIRECT,
        DECAPS_WRAPPER,
        DYN_ACCESS;

    }
}

