/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pgroup;

import org.eclipse.nebula.widgets.pgroup.AbstractToolItemRenderer;
import org.eclipse.nebula.widgets.pgroup.PGroupToolItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class SimpleToolItemRenderer
extends AbstractToolItemRenderer {
    private int padding = 2;
    private int dropDownWidth = 10;

    @Override
    public void paint(GC gc, Object value) {
        PGroupToolItem item = (PGroupToolItem)((Object)value);
        Rectangle rect = this.getBounds();
        int alpha = gc.getAlpha();
        Color bg = gc.getBackground();
        if (this.isHover() && !item.getSelection()) {
            gc.setBackground(gc.getDevice().getSystemColor(1));
            gc.setAlpha(100);
            gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 3, 3);
            gc.setBackground(bg);
            gc.setAlpha(alpha);
        }
        if (item.getSelection()) {
            gc.setBackground(gc.getDevice().getSystemColor(2));
            gc.setAlpha(100);
            gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 3, 3);
            gc.setBackground(gc.getDevice().getSystemColor(1));
            gc.fillRoundRectangle(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2, 3, 3);
            gc.setBackground(bg);
            gc.setAlpha(alpha);
        }
        if (item.getText().length() > 0 && item.getImage() != null && this.getSizeType() != 2) {
            gc.drawImage(item.getImage(), rect.x + this.padding, rect.y + (int)((double)rect.height / 2.0 - (double)item.getImage().getImageData().height / 2.0));
            Point p = gc.textExtent(item.getText());
            gc.drawString(item.getText(), rect.x + this.padding + item.getImage().getImageData().width + 2, rect.y + (int)((double)rect.height / 2.0 - (double)p.y / 2.0), true);
        } else if (item.getImage() != null) {
            gc.drawImage(item.getImage(), rect.x + this.padding, rect.y + (int)((double)rect.height / 2.0 - (double)item.getImage().getImageData().height / 2.0));
        } else if (item.getText().length() > 0) {
            Point p = gc.textExtent(item.getText());
            gc.drawString(item.getText(), rect.x + this.padding, rect.y + (int)((double)rect.height / 2.0 - (double)p.y / 2.0), true);
        }
        if ((item.getStyle() & 4) != 0) {
            gc.setBackground(gc.getDevice().getSystemColor(2));
            gc.fillPolygon(new int[]{rect.x + rect.width - 2, rect.y + rect.height / 2, rect.x + rect.width - 8, rect.y + rect.height / 2, rect.x + rect.width - 5, rect.y + rect.height / 2 + 4});
        }
        gc.setAlpha(alpha);
        gc.setBackground(bg);
    }

    @Override
    public Point computeSize(GC gc, PGroupToolItem item, int type) {
        int dropDown;
        int n = dropDown = (item.getStyle() & 4) != 0 ? this.dropDownWidth : 0;
        if (item.getText().length() > 0 && item.getImage() != null) {
            Point p = gc.textExtent(item.getText());
            int y = p.y;
            if (type == 1) {
                return new Point(p.x + item.getImage().getImageData().width + this.padding * 3 + dropDown, y);
            }
            return new Point(item.getImage().getImageData().width + this.padding * 2 + dropDown, y);
        }
        if (item.getText().length() > 0) {
            Point p = gc.textExtent(item.getText());
            int x = p.x + this.padding * 2 + dropDown;
            int y = p.y;
            return new Point(x, y);
        }
        if (item.getImage() != null) {
            int x = item.getImage().getImageData().width + this.padding * 2 + dropDown;
            int y = item.getImage().getImageData().height;
            return new Point(x, y);
        }
        return null;
    }

    @Override
    public Rectangle computeDropDownArea(Rectangle totalRect) {
        return new Rectangle(totalRect.x + totalRect.width - this.dropDownWidth, totalRect.y, totalRect.width, totalRect.height);
    }
}

