/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.breadcrumb;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.opal.breadcrumb.Breadcrumb;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class BreadcrumbItem
extends Item {
    private static final int MIN_WIDTH = 40;
    private static final int MARGIN = 4;
    private static Color SELECTED_COLOR = SWTGraphicUtil.getColorSafely((int)223, (int)220, (int)213);
    private final Breadcrumb parentBreadcrumb;
    private final List<SelectionListener> selectionListeners;
    private Rectangle bounds;
    private boolean enabled;
    private boolean selection;
    private int width;
    private int height;
    private Image disabledImage;
    private Image selectionImage;
    private int alignment;
    private Color textColorSelected;
    private Color textColor;
    private String tooltipText;
    private GC gc;
    private int toolbarHeight;
    private boolean isLastItemOfTheBreadCrumb;

    public BreadcrumbItem(Breadcrumb parent) {
        this(parent, 0);
    }

    public BreadcrumbItem(Breadcrumb parent, int style) {
        super((Widget)parent, BreadcrumbItem.checkStyle(style));
        parent.addItem(this);
        this.parentBreadcrumb = parent;
        this.textColor = parent.getDisplay().getSystemColor(2);
        this.textColorSelected = parent.getDisplay().getSystemColor(2);
        this.enabled = true;
        if ((style & 0x4000) != 0) {
            this.alignment = 16384;
        }
        if ((style & 0x1000000) != 0) {
            this.alignment = 0x1000000;
        }
        if ((style & 0x20000) != 0) {
            this.alignment = 131072;
        }
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.height = -1;
        this.width = -1;
    }

    private static int checkStyle(int style) {
        if (((style = BreadcrumbItem.checkBits(style, 0, 8, 2)) & 0xA) != 0) {
            return BreadcrumbItem.checkBits(style, 0x1000000, 16384, 131072);
        }
        return style;
    }

    private static int checkBits(int style, int int0, int int1, int int2) {
        int mask = int0 | int1 | int2;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        return style;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.add(listener);
    }

    public void dispose() {
        this.getParent().removeItem(this);
        this.bounds = null;
        this.disabledImage = null;
        this.selectionImage = null;
        this.textColor = null;
        this.textColorSelected = null;
        super.dispose();
    }

    public int getAlignment() {
        this.checkWidget();
        return this.alignment;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.bounds;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.enabled;
    }

    public int getHeight() {
        this.checkWidget();
        if (this.height == -1) {
            return this.computeDefaultSize().y;
        }
        return this.height;
    }

    private Point computeDefaultSize() {
        Point sizeOfTextAndImages = this.computeSizeOfTextAndImages();
        return new Point(8 + sizeOfTextAndImages.x, 8 + sizeOfTextAndImages.y);
    }

    public Breadcrumb getParent() {
        this.checkWidget();
        return this.parentBreadcrumb;
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public Image getSelectionImage() {
        this.checkWidget();
        return this.selectionImage;
    }

    public Color getTextColor() {
        this.checkWidget();
        return this.textColor;
    }

    public Color getTextColorSelected() {
        this.checkWidget();
        return this.textColorSelected;
    }

    public String getTooltipText() {
        this.checkWidget();
        return this.tooltipText;
    }

    public int getWidth() {
        this.checkWidget();
        if (this.width == -1) {
            return Math.max(this.computeDefaultSize().x, 40);
        }
        return Math.max(this.width, 40);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.enabled;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.remove(listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        this.alignment = alignment;
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (this.bounds == null) {
            SWT.error((int)4);
        }
        this.bounds = new Rectangle(Math.max(0, rectangle.x), Math.max(0, rectangle.y), Math.max(0, rectangle.width), Math.max(0, rectangle.height));
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        this.disabledImage = image;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.enabled = enabled;
    }

    public void setHeight(int height) {
        this.checkWidget();
        this.height = Math.max(height, 0);
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        this.selection = selected;
    }

    public void setSelectionImage(Image image) {
        this.checkWidget();
        this.selectionImage = image;
    }

    public void setTextColor(Color textColor) {
        this.checkWidget();
        this.textColor = textColor;
    }

    public void setTextColorSelected(Color textColor) {
        this.checkWidget();
        this.textColorSelected = textColor;
    }

    public void setTooltipText(String string) {
        this.checkWidget();
        this.tooltipText = string == null ? "" : string;
    }

    public void setWidth(int width) {
        this.checkWidget();
        this.width = Math.max(0, width);
    }

    void fireSelectionEvent() {
        Event event = new Event();
        event.widget = this.parentBreadcrumb;
        event.display = this.getDisplay();
        event.item = this;
        event.type = 13;
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(new SelectionEvent(event));
        }
    }

    void drawButtonAtPosition(int x) {
        int xPosition;
        Image drawnedImage;
        if (this.selection) {
            this.drawBackgroundAtPosition(x);
        }
        if (!this.isLastItemOfTheBreadCrumb) {
            this.drawTrianglesAtPosition(x);
        }
        if ((drawnedImage = this.drawImageAtPosition(x + (xPosition = this.computeGap()))) != null) {
            xPosition += drawnedImage.getBounds().width + 8;
        }
        this.drawTextAtPosition(x + xPosition);
        this.bounds = new Rectangle(x, 0, this.getWidth(), this.toolbarHeight);
    }

    private void drawBackgroundAtPosition(int x) {
        int borderWidth;
        this.gc.setAdvanced(true);
        this.gc.setAntialias(1);
        this.gc.setForeground(SELECTED_COLOR);
        this.gc.setBackground(SELECTED_COLOR);
        boolean hasBorder = this.parentBreadcrumb.hasBorder;
        boolean isFirst = this.parentBreadcrumb.indexOf(this) == 0;
        int n = borderWidth = hasBorder ? 1 : 0;
        int leftSide = isFirst ? 0 : 5 + (hasBorder ? 0 : 1);
        int xUpperLeft = x + borderWidth + leftSide;
        int yUpperLeft = borderWidth;
        int rectWidth = this.getWidth() - borderWidth - leftSide - (this.isLastItemOfTheBreadCrumb && hasBorder ? 1 : 0);
        int rectHeight = this.getHeight() - 2 * borderWidth;
        this.gc.fillRectangle(xUpperLeft, yUpperLeft, rectWidth, rectHeight);
        if (!isFirst) {
            this.gc.fillPolygon(new int[]{xUpperLeft - 5, yUpperLeft, xUpperLeft, yUpperLeft, xUpperLeft, yUpperLeft + this.toolbarHeight / 2});
            this.gc.fillPolygon(new int[]{xUpperLeft - 5, yUpperLeft + rectHeight, xUpperLeft, yUpperLeft + rectHeight, xUpperLeft, yUpperLeft + this.toolbarHeight / 2});
        }
        if (!this.isLastItemOfTheBreadCrumb) {
            this.gc.fillPolygon(new int[]{xUpperLeft + rectWidth, yUpperLeft + 1, xUpperLeft + rectWidth, yUpperLeft + this.getHeight(), xUpperLeft + rectWidth + 5, yUpperLeft + this.toolbarHeight / 2});
        }
        this.gc.setClipping(null);
    }

    private void drawTrianglesAtPosition(int x) {
        this.gc.setForeground(Breadcrumb.BORDER_COLOR);
        this.drawTriangleAtPosition(x + this.getWidth());
        this.gc.setAlpha(127);
        this.gc.setForeground(Breadcrumb.BORDER_COLOR_1);
        this.drawTriangleAtPosition(x + this.getWidth() + 1);
        this.gc.setForeground(Breadcrumb.BORDER_COLOR_2);
        this.drawTriangleAtPosition(x + this.getWidth() + 2);
        this.gc.setForeground(Breadcrumb.BORDER_COLOR_3);
        this.drawTriangleAtPosition(x + this.getWidth() + 3);
        this.gc.setAlpha(255);
        if (this.parentBreadcrumb.hasBorder) {
            this.gc.setForeground(Breadcrumb.BORDER_COLOR);
            this.gc.drawLine(x + this.getWidth(), 0, x + this.getWidth() + 3, 0);
            this.gc.drawLine(x + this.getWidth(), this.toolbarHeight - 1, x + this.getWidth() + 3, this.toolbarHeight - 1);
        }
    }

    private void drawTriangleAtPosition(int x) {
        this.gc.drawLine(x, 0, x + 5, this.toolbarHeight / 2);
        this.gc.drawLine(x + 5, this.toolbarHeight / 2, x, this.toolbarHeight);
    }

    private int computeGap() {
        int widthOfTextAndImage = this.computeSizeOfTextAndImages().x;
        switch (this.alignment) {
            case 0x1000000: {
                return (this.getWidth() - widthOfTextAndImage) / 2;
            }
            case 131072: {
                return this.getWidth() - widthOfTextAndImage - 4;
            }
        }
        return 4;
    }

    private Point computeSizeOfTextAndImages() {
        boolean textISNotEmpty;
        int width = 0;
        int height = 0;
        boolean bl = textISNotEmpty = this.getText() != null && !this.getText().equals("");
        if (textISNotEmpty) {
            GC gc = new GC((Drawable)this.parentBreadcrumb);
            gc.setFont(this.parentBreadcrumb.getFont());
            Point extent = gc.stringExtent(this.getText());
            gc.dispose();
            width += extent.x;
            height = extent.y;
        }
        Point imageSize = this.computeMaxWidthAndHeightForImages(this.getImage(), this.selectionImage, this.disabledImage);
        if (imageSize.x != -1) {
            width += imageSize.x;
            height = Math.max(imageSize.y, height);
            if (textISNotEmpty) {
                width += 8;
            }
        }
        return new Point(width += 4, height);
    }

    private Point computeMaxWidthAndHeightForImages(Image ... images) {
        Point imageSize = new Point(-1, -1);
        Image[] imageArray = images;
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            Image image = imageArray[n2];
            if (image != null) {
                Rectangle imageBounds = image.getBounds();
                imageSize.x = Math.max(imageBounds.width, imageSize.x);
                imageSize.y = Math.max(imageBounds.height, imageSize.y);
            }
            ++n2;
        }
        return imageSize;
    }

    private Image drawImageAtPosition(int xPosition) {
        Image image = !this.isEnabled() ? this.disabledImage : (this.selection ? this.selectionImage : this.getImage());
        if (image == null) {
            return null;
        }
        int yPosition = (this.toolbarHeight - image.getBounds().height) / 2;
        this.gc.drawImage(image, (int)((double)xPosition + 6.0), yPosition);
        return image;
    }

    private void drawTextAtPosition(int xPosition) {
        this.gc.setFont(this.parentBreadcrumb.getFont());
        if (this.selection) {
            this.gc.setForeground(this.textColorSelected);
        } else {
            this.gc.setForeground(this.textColor);
        }
        Point textSize = this.gc.stringExtent(this.getText());
        int yPosition = (this.toolbarHeight - textSize.y) / 2;
        int padding = this.parentBreadcrumb.indexOf(this) == 0 || this.isLastItemOfTheBreadCrumb ? 0 : 5;
        this.gc.drawText(this.getText(), xPosition + padding, yPosition, true);
    }

    BreadcrumbItem setGc(GC gc) {
        this.gc = gc;
        return this;
    }

    BreadcrumbItem setToolbarHeight(int toolbarHeight) {
        this.toolbarHeight = toolbarHeight;
        return this;
    }

    BreadcrumbItem setIsLastItemOfTheBreadCrumb(boolean isLastItemOfTheBreadCrumb) {
        this.isLastItemOfTheBreadCrumb = isLastItemOfTheBreadCrumb;
        return this;
    }
}

