/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figures;

import org.eclipse.nebula.visualization.widgets.figures.AbstractMarkedWidgetFigure;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScaledMarker;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;

public class AbstractLinearMarkedFigure
extends AbstractMarkedWidgetFigure {
    private static final String HIHI = "HIHI";
    private static final String HI = "HI";
    private static final String LO = "LO";
    private static final String LOLO = "LOLO";
    protected LinearScaledMarker marker;

    public AbstractLinearMarkedFigure() {
        this.scale = new LinearScale();
        this.marker = new LinearScaledMarker((LinearScale)this.scale);
        this.marker.addMarkerElement(LOLO, this.loloLevel, XYGraphMediaFactory.COLOR_RED);
        this.marker.addMarkerElement(LO, this.loLevel, XYGraphMediaFactory.COLOR_ORANGE);
        this.marker.addMarkerElement(HI, this.hiLevel, XYGraphMediaFactory.COLOR_ORANGE);
        this.marker.addMarkerElement(HIHI, this.hihiLevel, XYGraphMediaFactory.COLOR_RED);
    }

    @Override
    public void setShowMarkers(boolean showMarkers) {
        super.setShowMarkers(showMarkers);
        this.marker.setVisible(showMarkers);
    }

    @Override
    public void setLoloLevel(double loloLevel) {
        super.setLoloLevel(loloLevel);
        this.marker.setMarkerElementValue(LOLO, loloLevel);
    }

    @Override
    public void setLoLevel(double loLevel) {
        super.setLoLevel(loLevel);
        this.marker.setMarkerElementValue(LO, loLevel);
    }

    @Override
    public void setHiLevel(double hiLevel) {
        super.setHiLevel(hiLevel);
        this.marker.setMarkerElementValue(HI, hiLevel);
    }

    @Override
    public void setHihiLevel(double hihiLevel) {
        super.setHihiLevel(hihiLevel);
        this.marker.setMarkerElementValue(HIHI, hihiLevel);
    }

    @Override
    public void setShowLolo(boolean showLolo) {
        super.setShowLolo(showLolo);
        if (showLolo) {
            if (this.loloColor != null) {
                this.marker.addMarkerElement(LOLO, this.loloLevel, this.loloColor.getRGB());
            } else {
                this.marker.addMarkerElement(LOLO, this.loloLevel);
            }
        } else {
            this.marker.removeMarkerElement(LOLO);
        }
        this.revalidate();
    }

    @Override
    public void setShowLo(boolean showLo) {
        super.setShowLo(showLo);
        if (showLo) {
            if (this.loColor != null) {
                this.marker.addMarkerElement(LO, this.loLevel, this.loColor.getRGB());
            } else {
                this.marker.addMarkerElement(LO, this.loLevel);
            }
        } else {
            this.marker.removeMarkerElement(LO);
        }
        this.revalidate();
    }

    @Override
    public void setShowHi(boolean showHi) {
        super.setShowHi(showHi);
        if (showHi) {
            if (this.hiColor != null) {
                this.marker.addMarkerElement(HI, this.hiLevel, this.hiColor.getRGB());
            } else {
                this.marker.addMarkerElement(HI, this.hiLevel);
            }
        } else {
            this.marker.removeMarkerElement(HI);
        }
        this.revalidate();
    }

    @Override
    public void setShowHihi(boolean showHihi) {
        super.setShowHihi(showHihi);
        if (showHihi) {
            if (this.hihiColor != null) {
                this.marker.addMarkerElement(HIHI, this.hihiLevel, this.hihiColor.getRGB());
            } else {
                this.marker.addMarkerElement(HIHI, this.hihiLevel);
            }
        } else {
            this.marker.removeMarkerElement(HIHI);
        }
        this.revalidate();
    }

    @Override
    public void setLoloColor(Color color) {
        super.setLoloColor(color);
        this.marker.setMarkerElementColor(LOLO, color.getRGB());
    }

    @Override
    public void setLoColor(Color color) {
        super.setLoColor(color);
        this.marker.setMarkerElementColor(LO, color.getRGB());
    }

    @Override
    public void setHiColor(Color color) {
        super.setHiColor(color);
        this.marker.setMarkerElementColor(HI, color.getRGB());
    }

    @Override
    public void setHihiColor(Color color) {
        super.setHihiColor(color);
        this.marker.setMarkerElementColor(HIHI, color.getRGB());
    }

    @Override
    public void setRange(double min, double max) {
        super.setRange(min, max);
        this.marker.setDirty(true);
    }

    @Override
    public void setLogScale(boolean logScale) {
        super.setLogScale(logScale);
        this.marker.setDirty(true);
    }
}

