/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.figures.detail.track.lane;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.nebula.widgets.timeline.ITimelineEvent;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.lane.EventTooltip;
import org.eclipse.nebula.widgets.timeline.layouts.CenterLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class EventFigure
extends RoundedRectangle
implements Comparable<EventFigure> {
    private Color fEventColor;
    private final Label fLabel;

    public EventFigure(ITimelineEvent event) {
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setMinorAlignment(0);
        layout.setStretchMinorAxis(true);
        this.setLayoutManager((LayoutManager)layout);
        this.setLayoutManager(new CenterLayout());
        this.setLineWidth(2);
        this.fLabel = new Label(event.getTitle());
        this.fLabel.setForegroundColor(ColorConstants.black);
        this.add((IFigure)this.fLabel);
        if (event.getMessage() != null) {
            this.setToolTip((IFigure)new EventTooltip(event.getMessage()));
        }
    }

    public void setEventColor(Color color) {
        this.fEventColor = color;
        this.setBackgroundColor(color);
        float[] hsb = color.getRGB().getHSB();
        this.setForegroundColor(RootFigure.getRootFigure((IFigure)this).getStyleProvider().getColor(new RGB(hsb[0], Math.min(1.0f, hsb[1] * 2.0f), hsb[2] * 0.8f)));
        this.setAlpha(150);
    }

    public void revalidate() {
        ITimelineEvent event = this.getEvent();
        if (event != null) {
            this.fLabel.setText(event.getTitle());
            this.setToolTip((IFigure)(event.getMessage() == null ? null : new EventTooltip(event.getMessage())));
            Color eventColor = this.getParent().getForegroundColor();
            if (event.getColorCode() != null) {
                eventColor = RootFigure.getRootFigure((IFigure)this).getStyleProvider().getColor(event.getRgb());
            }
            this.setEventColor(eventColor);
        }
        super.revalidate();
    }

    public Color getEventColor() {
        return this.fEventColor;
    }

    public ITimelineEvent getEvent() {
        if (this.getParent() != null) {
            return (ITimelineEvent)this.getParent().getLayoutManager().getConstraint((IFigure)this);
        }
        return null;
    }

    @Override
    public int compareTo(EventFigure eventFigure) {
        long difference = this.getEvent().getStartTimestamp() - eventFigure.getEvent().getStartTimestamp();
        if (difference < 0L) {
            return -1;
        }
        if (difference > 0L) {
            return 1;
        }
        return 0;
    }

    protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
        return null;
    }
}

