/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.tiles;

import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import org.eclipse.nebula.widgets.tiles.DecoratorColor;
import org.eclipse.nebula.widgets.tiles.DecoratorInteger;
import org.eclipse.nebula.widgets.tiles.DecoratorString;
import org.eclipse.nebula.widgets.tiles.DecoratorStringToString;
import org.eclipse.nebula.widgets.tiles.Filter;
import org.eclipse.nebula.widgets.tiles.Frame;
import org.eclipse.nebula.widgets.tiles.FrameDynamic;
import org.eclipse.nebula.widgets.tiles.FrameStatic;
import org.eclipse.nebula.widgets.tiles.ResizeListener;
import org.eclipse.nebula.widgets.tiles.Tile;
import org.eclipse.nebula.widgets.tiles.TileAnimationSettings;
import org.eclipse.nebula.widgets.tiles.TileLayout;
import org.eclipse.nebula.widgets.tiles.TileLayoutDynamic;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class Tiles<T>
extends Canvas {
    private Frame<T> current = null;
    private FrameStatic<T> next = new FrameStatic(this);
    private TileLayout layout = new TileLayoutDynamic(10, 10, 5, 5);
    private DecoratorString<T> tooltipDecorator = new DecoratorStringToString();
    private final PaintListener paintListener = this.getPaintListener();
    private final ResizeListener resizeListener = this.getResizeListener();
    private final MouseListener mouseListener = this.getMouseListener();
    private final MouseMoveListener mouseMoveListener = this.getMouseMoveListener();
    private final DisposeListener disposeListener = this.getDisposeListener();
    private final Runnable animation = this.getAnimation();
    private TileAnimationSettings settings = new TileAnimationSettings(30, 3000);
    private T selectedItem = null;
    private T activeItem = null;
    private final Color black;

    public Tiles(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addPaintListener(this.paintListener);
        this.addControlListener((ControlListener)this.resizeListener);
        this.addDisposeListener(this.disposeListener);
        this.addMouseListener(this.mouseListener);
        this.addMouseMoveListener(this.mouseMoveListener);
        this.addControlListener((ControlListener)this.resizeListener);
        this.black = new Color((Device)this.getDisplay(), 0, 0, 0);
        this.getDisplay().timerExec(this.settings.getDelta(), this.animation);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener((EventListener)listener, new int[]{13});
    }

    public TileAnimationSettings getAnimationSettings() {
        super.checkWidget();
        return this.settings;
    }

    public Comparator<T> getComparator() {
        super.checkWidget();
        if (this.current == null) {
            return null;
        }
        return this.current.getComparator();
    }

    public DecoratorColor<T> getDecoratorBackgroundColor() {
        super.checkWidget();
        if (this.current == null) {
            return null;
        }
        return this.current.getDecoratorBackgroundColor();
    }

    public DecoratorColor<T> getDecoratorForegroundColor() {
        super.checkWidget();
        if (this.current == null) {
            return null;
        }
        return this.current.getDecoratorForegroundColor();
    }

    public DecoratorString<T> getDecoratorLabel() {
        super.checkWidget();
        if (this.current == null) {
            return null;
        }
        return this.current.getDecoratorLabel();
    }

    public DecoratorColor<T> getDecoratorLineColor() {
        super.checkWidget();
        if (this.current == null) {
            return null;
        }
        return this.current.getDecoratorLineColor();
    }

    public DecoratorInteger<T> getDecoratorLineStyle() {
        super.checkWidget();
        if (this.current == null) {
            return null;
        }
        return this.current.getDecoratorLineStyle();
    }

    public DecoratorInteger<T> getDecoratorLineWidth() {
        super.checkWidget();
        if (this.current == null) {
            return null;
        }
        return this.current.getDecoratorLineWidth();
    }

    public Filter<T> getFilter() {
        super.checkWidget();
        if (this.current == null) {
            return null;
        }
        return this.current.getFilter();
    }

    public List<T> getItems() {
        super.checkWidget();
        if (this.current == null) {
            return null;
        }
        return this.current.getItems();
    }

    public T getSelectedItem() {
        super.checkWidget();
        return this.selectedItem;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.removeTypedListener(13, (EventListener)listener);
    }

    public void setAnimationSettings(TileAnimationSettings settings) {
        super.checkWidget();
        this.settings = settings;
    }

    public void setBackground(Color arg0) {
        super.checkWidget();
        super.setBackground(arg0);
        this.addFrame();
        this.next.setBackground(arg0);
    }

    public void setComparator(Comparator<T> Comparator2) {
        super.checkWidget();
        this.addFrame();
        this.next.setComparator(Comparator2);
    }

    public void setDecoratorBackgroundColor(DecoratorColor<T> decorator) {
        super.checkWidget();
        this.addFrame();
        this.next.setDecoratorBackgroundColor(decorator);
    }

    public void setDecoratorForegroundColor(DecoratorColor<T> decorator) {
        super.checkWidget();
        this.addFrame();
        this.next.setDecoratorForegroundColor(decorator);
    }

    public void setDecoratorLabel(DecoratorString<T> decorator) {
        super.checkWidget();
        this.addFrame();
        this.next.setDecoratorLabel(decorator);
    }

    public void setDecoratorLineColor(DecoratorColor<T> decorator) {
        super.checkWidget();
        this.addFrame();
        this.next.setDecoratorLineColor(decorator);
    }

    public void setDecoratorLineStyle(DecoratorInteger<T> decorator) {
        super.checkWidget();
        this.addFrame();
        this.next.setDecoratorLineStyle(decorator);
    }

    public void setDecoratorLineWidth(DecoratorInteger<T> decorator) {
        super.checkWidget();
        this.addFrame();
        this.next.setDecoratorLineWidth(decorator);
    }

    public void setDecoratorTooltip(DecoratorString<T> decorator) {
        super.checkWidget();
        this.tooltipDecorator = decorator;
    }

    public void setFilter(Filter<T> filter) {
        super.checkWidget();
        this.addFrame();
        this.next.setFilter(filter);
    }

    public void setSelectedItem(T item) {
        super.checkWidget();
        this.selectedItem = item;
        this.redraw();
    }

    public void setItems(List<T> items) {
        super.checkWidget();
        this.addFrame();
        this.next.setItems(items);
    }

    public void setTileLayout(TileLayout layout) {
        super.checkWidget();
        this.layout = layout;
        this.addFrame();
        this.next.setTileHeight(this.layout.getHeight(this));
        this.next.setTileWidth(this.layout.getWidth(this));
    }

    public void update() {
        super.checkWidget();
        super.update();
        if (this.current == null) {
            this.current = this.next.clone();
            this.current.update();
        } else if (this.current instanceof FrameStatic) {
            Object target = this.next.clone();
            ((FrameStatic)target).update();
            this.current.update();
            this.current = new FrameDynamic(this, (FrameStatic)this.current, target);
            this.current.update();
        }
    }

    private void addFrame() {
        FrameStatic<T> current = this.next;
        this.next = this.next.clone();
        current.dispose();
    }

    private void fireSelectionEvent(Tile<T> tile) {
        Event event = new Event();
        event.data = tile.item;
        event.display = this.getDisplay();
        event.widget = this;
        event.x = tile.x;
        event.y = tile.y;
        event.width = tile.width;
        event.height = tile.height;
        this.notifyListeners(13, event);
    }

    private Runnable getAnimation() {
        return new Runnable(){

            @Override
            public void run() {
                Frame frame = Tiles.this.current;
                if (frame != null && frame instanceof FrameDynamic) {
                    ((FrameDynamic)frame).tick();
                    frame.update();
                    Tiles.this.redraw();
                }
                Tiles.this.getDisplay().timerExec(Tiles.this.settings.getDelta(), (Runnable)this);
            }
        };
    }

    private DisposeListener getDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                Tiles.this.getDisplay().timerExec(-1, Tiles.this.animation);
                if (Tiles.this.current != null) {
                    Tiles.this.current.dispose();
                }
                if (Tiles.this.next != null) {
                    Tiles.this.next.dispose();
                }
                Tiles.this.black.dispose();
                Tiles.this.removePaintListener(Tiles.this.paintListener);
                Tiles.this.removeControlListener((ControlListener)Tiles.this.resizeListener);
                Tiles.this.removeMouseListener(Tiles.this.mouseListener);
                Tiles.this.removeMouseMoveListener(Tiles.this.mouseMoveListener);
                Tiles.this.removeDisposeListener(this);
            }
        };
    }

    private MouseListener getMouseListener() {
        return new MouseAdapter(){

            public void mouseDown(MouseEvent arg0) {
                Tile tile = Tiles.this.getTileAt(arg0.x, arg0.y);
                if (tile != null && tile.item != Tiles.this.selectedItem) {
                    Tiles.this.selectedItem = tile.item;
                    Tiles.this.redraw();
                    Tiles.this.fireSelectionEvent(tile);
                }
            }
        };
    }

    private MouseMoveListener getMouseMoveListener() {
        return arg0 -> {
            Object item;
            Tile<T> tile = this.getTileAt(arg0.x, arg0.y);
            Object v0 = item = tile == null ? null : tile.item;
            if (item == this.activeItem) {
                return;
            }
            this.activeItem = item;
            this.redraw();
            String tooltip = this.activeItem != null ? (String)this.tooltipDecorator.decorate(this.activeItem) : null;
            this.setToolTipText(tooltip);
        };
    }

    private PaintListener getPaintListener() {
        return e -> {
            Point size = this.getSize();
            this.paintFrame(e.gc, this.current, size.x, size.y);
        };
    }

    private ResizeListener getResizeListener() {
        return new ResizeListener(this){

            @Override
            protected void controlResized() {
                Tiles.this.addFrame();
                Point p = Tiles.this.getSize();
                Tiles.this.next.setWidth(p.x);
                Tiles.this.next.setHeight(p.y);
                Tiles.this.next.setTileHeight(Tiles.this.layout.getHeight(Tiles.this));
                Tiles.this.next.setTileWidth(Tiles.this.layout.getWidth(Tiles.this));
                Tiles.this.next.setTileMarginX(Tiles.this.layout.getMarginX());
                Tiles.this.next.setTileMarginY(Tiles.this.layout.getMarginY());
                Tiles.this.update();
            }
        };
    }

    private Tile<T> getTileAt(int x, int y) {
        if (this.current == null) {
            return null;
        }
        for (Tile<T> tile : this.current.getTiles()) {
            if (x < tile.x || y < tile.y || x > tile.x + tile.width || y > tile.y + tile.height) continue;
            return tile;
        }
        return null;
    }

    private void paintFrame(GC gc, Frame<T> frame, int width, int height) {
        if (frame == null) {
            return;
        }
        gc.setBackground(frame.getBackground());
        gc.fillRectangle(0, 0, width, height);
        for (Tile<T> tile : frame.getTiles()) {
            gc.setClipping(0, 0, width, height);
            Color backgroundColor = tile.backgroundColor;
            if (tile.item == this.activeItem) {
                backgroundColor = this.lightDarker(tile.backgroundColor);
            } else if (tile.item == this.selectedItem) {
                backgroundColor = this.strongDarker(tile.backgroundColor);
            }
            gc.setBackground(backgroundColor);
            gc.fillRectangle(tile.x, tile.y, tile.width, tile.height);
            gc.setForeground(tile.lineColor);
            gc.setLineStyle(tile.lineStyle);
            gc.setLineWidth(tile.lineWidth);
            gc.drawRectangle(tile.x, tile.y, tile.width, tile.height);
            gc.setForeground(tile.foregroundColor);
            gc.setClipping(tile.x, tile.y, tile.width, tile.height);
            this.paintString(gc, tile.label, tile.x, tile.y, tile.width, tile.height);
            if (backgroundColor == tile.backgroundColor) continue;
            gc.setBackground(tile.backgroundColor);
            backgroundColor.dispose();
        }
        if ((this.getStyle() & 0x800) != 0) {
            gc.setForeground(gc.getDevice().getSystemColor(18));
            gc.drawRectangle(0, 0, this.getSize().x - 1, this.getSize().y - 1);
        }
    }

    private Color strongDarker(Color color) {
        int r = color.getRed() - 125;
        int g = color.getGreen() - 125;
        int b = color.getBlue() - 125;
        r = r >= 0 ? r : 0;
        g = g >= 0 ? g : 0;
        b = b >= 0 ? b : 0;
        return new Color(color.getDevice(), r, g, b);
    }

    private Color lightDarker(Color color) {
        int r = color.getRed() - 75;
        int g = color.getGreen() - 75;
        int b = color.getBlue() - 75;
        r = r >= 0 ? r : 0;
        g = g >= 0 ? g : 0;
        b = b >= 0 ? b : 0;
        return new Color(color.getDevice(), r, g, b);
    }

    private void paintString(GC gc, String string, int x, int y, int width, int height) {
        Point extent = gc.textExtent(string);
        int xx = x + (width - extent.x) / 2;
        int yy = y + (height - extent.y) / 2;
        if ((float)extent.x <= (float)width * 0.9f) {
            gc.drawText(string, xx, yy, true);
        } else {
            gc.setTextAntialias(1);
            gc.setAntialias(1);
            float factor1 = (float)width * 0.9f / (float)extent.x;
            float factor2 = (float)height * 0.9f / (float)extent.y;
            float factor = Math.min(factor1, factor2);
            int positionX = x + (int)(((float)width - (float)extent.x * factor) / 2.0f);
            int positionY = y + (int)(((float)height - (float)extent.y * factor) / 2.0f);
            Transform transform = new Transform(gc.getDevice());
            transform.identity();
            transform.translate((float)positionX, (float)positionY);
            transform.scale(factor, factor);
            gc.setTransform(transform);
            Path path = new Path((Device)this.getDisplay());
            path.addString(string, 0.0f, 0.0f, gc.getFont());
            Color back = gc.getBackground();
            gc.setBackground(gc.getForeground());
            gc.fillPath(path);
            gc.setTransform(null);
            gc.setTextAntialias(0);
            gc.setAntialias(0);
            gc.setBackground(back);
            path.dispose();
            transform.dispose();
        }
    }

    protected void removeFrame() {
        if (this.current instanceof FrameStatic) {
            if (!this.next.equals(this.current)) {
                this.update();
            } else {
                this.current.update();
                this.redraw();
            }
        } else {
            Frame<T> old = this.current;
            FrameStatic source = ((FrameDynamic)this.current).getTarget();
            this.current = source.clone();
            old.dispose();
            if (!this.next.equals(this.current)) {
                this.update();
            } else {
                this.current.update();
                this.redraw();
            }
        }
    }
}

