/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.oscilloscope.multichannel;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class Plotter
extends Canvas {
    private int height = 100;
    private int width = 180;
    private boolean paintBlock = true;
    private final Data[] chan;
    private int myRangeHighValue = 100;
    private int myRangeLowValue = -100;
    public static final int BASE_CENTER = 50;
    public static final int CURSOR_START_DEFAULT = 50;
    public static final int DEFAULT_HEIGHT = 100;
    public static final int DEFAULT_WIDTH = 180;
    public static final int LINE_WIDTH_DEFAULT = 1;
    public static final int PROGRESSION_DEFAULT = 1;
    public static final int STEADYPOSITION_75PERCENT = -1;
    public static final int TAILFADE_DEFAULT = 25;
    public static final int TAILFADE_NONE = 0;
    public static final int TAILFADE_PERCENTAGE = 25;
    public static final int TAILSIZE_DEFAULT = -3;
    public static final int TAILSIZE_FILL = -2;
    public static final int TAILSIZE_MAX = -1;

    public Plotter(int channels, Composite parent, int style) {
        this(channels, parent, style, null, null);
    }

    public Plotter(int channels, Composite parent, int style, Color backgroundColor, Color foregroundColor) {
        super(parent, 0x20000000 | style);
        Color bg = backgroundColor;
        if (backgroundColor == null) {
            bg = Display.getDefault().getSystemColor(2);
        }
        Color fg = foregroundColor == null ? Display.getDefault().getSystemColor(1) : foregroundColor;
        this.setBackground(bg);
        this.chan = new Data[channels];
        int i = 0;
        while (i < this.chan.length) {
            this.chan[i] = new Data();
            this.chan[i].fg = fg;
            this.setTailSize(i, -3);
            ++i;
        }
        this.addListener(12, e -> this.widgetDisposed(e));
        this.addListener(9, e -> {
            if (!this.paintBlock) {
                this.paintControl(e);
            }
            this.paintBlock = false;
        });
        this.addListener(10, e -> this.controlMoved(e));
        this.addListener(11, e -> {
            this.paintBlock = true;
            this.controlResized(e);
        });
    }

    private Object[] calculate(int channel) {
        int c = channel;
        int[] line1 = null;
        int[] line2 = null;
        int splitPos = 0;
        splitPos = this.chan[c].tailSize * 4;
        if (!this.isSteady(c)) {
            ++this.chan[c].cursor;
        }
        if (this.chan[c].cursor >= this.width) {
            this.chan[c].cursor = 0;
        }
        line1 = new int[this.chan[c].tailSize * 4];
        line2 = new int[this.chan[c].tailSize * 4];
        int i = 0;
        while (i < this.chan[c].tailSize) {
            int posx = this.chan[c].cursor - this.chan[c].tailSize + i;
            int pos = i * 4;
            if (posx < 0) {
                line1[pos] = (posx += this.width) - 1;
                line1[pos + 1] = this.getBase(c) + (this.isSteady(c) ? 0 : this.chan[c].tail[i]);
                line1[pos + 2] = posx;
                line1[pos + 3] = this.getBase(c) + (this.isSteady(c) ? 0 : this.chan[c].tail[i + 1]);
            } else {
                if (splitPos == this.chan[c].tailSize * 4) {
                    splitPos = pos;
                }
                line2[pos] = posx - 1;
                line2[pos + 1] = this.getBase(c) + this.chan[c].tail[i];
                line2[pos + 2] = posx;
                line2[pos + 3] = this.getBase(c) + this.chan[c].tail[i + 1];
            }
            ++i;
        }
        int[] l1 = new int[splitPos];
        System.arraycopy(line1, 0, l1, 0, l1.length);
        int[] l2 = new int[this.chan[c].tailSize * 4 - splitPos];
        System.arraycopy(line2, splitPos, l2, 0, l2.length);
        return new Object[]{l1, l2};
    }

    private void calculateBase(int channel) {
        if (this.myRangeLowValue != 0 || this.myRangeHighValue != 0) {
            this.chan[channel].base = 0;
        } else if (this.height > 2) {
            this.chan[channel].base = this.height * (100 - this.getBaseOffset(channel)) / 100;
        }
    }

    protected void paintControl(Event e) {
        int c = 0;
        while (c < this.chan.length) {
            Object[] result = this.calculate(c);
            int[] l1 = (int[])result[0];
            int[] l2 = (int[])result[1];
            this.PositionPolyLine(l1);
            this.PositionPolyLine(l2);
            GC gc = e.gc;
            gc.setForeground(this.getForeground(c));
            gc.setAdvanced(true);
            gc.setAntialias(this.chan[c].antiAlias ? 1 : 0);
            gc.setLineWidth(this.getLineWidth(c));
            if (this.isFade(c)) {
                gc.setAlpha(0);
                double fade = 0.0;
                double fadeOutStep = 125.0 / (double)(this.getTailSize(c) * this.getTailFade(c) / 100);
                int i = 0;
                while (i < l1.length - 4) {
                    Plotter.setAlpha(gc, fade += fadeOutStep / 2.0);
                    gc.drawLine(l1[i], l1[i + 1], l1[i + 2], l1[i + 3]);
                    i += 2;
                }
                i = 0;
                while (i < l2.length - 4) {
                    Plotter.setAlpha(gc, fade += fadeOutStep / 2.0);
                    gc.drawLine(l2[i], l2[i + 1], l2[i + 2], l2[i + 3]);
                    i += 2;
                }
            } else {
                gc.drawPolyline(l1);
                gc.drawPolyline(l2);
            }
            if (this.isConnect(c) && !this.isFade(c) && this.chan[c].originalTailSize == -1 && l1.length > 0 && l2.length > 0) {
                gc.drawLine(l2[l2.length - 2], l2[l2.length - 1], l1[0], l1[1]);
            }
            ++c;
        }
    }

    public void setValue(int channel, int value) {
        int copysize = this.chan[channel].tail.length;
        System.arraycopy(this.chan[channel].tail, 1, this.chan[channel].tail, 0, copysize - 1);
        this.chan[channel].tail[this.chan[channel].tailSize] = value;
    }

    public int getRangeLowValue() {
        return this.myRangeLowValue;
    }

    public int getRangeHighValue() {
        return this.myRangeHighValue;
    }

    private static void setAlpha(GC gc, double fade) {
        if ((double)gc.getAlpha() == fade) {
            return;
        }
        if (fade >= 255.0) {
            gc.setAlpha(255);
        } else {
            gc.setAlpha((int)fade);
        }
    }

    protected void PositionPolyLine(int[] l1) {
        int i = 0;
        while (i < l1.length - 4) {
            l1[i + 1] = this.ConvertValueToScreenPosition(l1[i + 1], this.getSize().y);
            l1[i + 3] = this.ConvertValueToScreenPosition(l1[i + 3], this.getSize().y);
            i += 4;
        }
    }

    protected int ConvertValueToScreenPosition(int Value, int ScreenHeight) {
        if (this.myRangeLowValue == 0 && this.myRangeHighValue == 0) {
            return ScreenHeight - Value;
        }
        float ret = (float)(Value - this.myRangeLowValue) / (float)(this.myRangeHighValue - this.myRangeLowValue) * (float)ScreenHeight;
        return ScreenHeight - (int)ret;
    }

    private void setTailSizeInternal(int channel) {
        if (this.chan[channel].originalTailSize == -3) {
            this.chan[channel].tailSize = this.width / 4 * 3;
            --this.chan[channel].tailSize;
        } else if (this.chan[channel].originalTailSize == -2) {
            this.chan[channel].tailSize = this.isSteady(channel) ? this.chan[channel].originalSteadyPosition - 1 : this.width - 2;
        } else if (this.chan[channel].originalTailSize == -1 || this.chan[channel].originalTailSize > this.width) {
            this.chan[channel].tailSize = this.width - 2;
        } else if (this.chan[channel].tailSize != this.chan[channel].originalTailSize) {
            this.chan[channel].tailSize = this.chan[channel].originalTailSize;
        }
        int[] oldTail = this.chan[channel].tail;
        if (oldTail == null) {
            this.chan[channel].tail = new int[this.chan[channel].tailSize + 1];
        } else {
            this.chan[channel].tail = new int[this.chan[channel].tailSize + 1];
            if (this.chan[channel].tail.length >= oldTail.length) {
                int i = 0;
                while (i < oldTail.length) {
                    this.chan[channel].tail[this.chan[channel].tail.length - 1 - i] = oldTail[oldTail.length - 1 - i];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.chan[channel].tail.length) {
                    this.chan[channel].tail[this.chan[channel].tail.length - 1 - i] = oldTail[oldTail.length - 1 - i];
                    ++i;
                }
            }
        }
    }

    public void setRange(int lowValue, int highValue) {
        this.myRangeLowValue = lowValue;
        this.myRangeHighValue = highValue;
    }

    public String getData(boolean addHeader) {
        return this.getData(addHeader, ";");
    }

    public String getData(boolean addHeader, String separator) {
        int n;
        Object ret = new String();
        String nl = System.lineSeparator();
        if (addHeader) {
            Data[] dataArray = this.chan;
            n = this.chan.length;
            int n2 = 0;
            while (n2 < n) {
                Data element = dataArray[n2];
                ret = (String)ret + element.name + separator;
                ++n2;
            }
            ret = (String)ret + nl;
        }
        int curvalue = 0;
        while (curvalue < this.chan[0].tail.length) {
            Data[] dataArray = this.chan;
            int n3 = this.chan.length;
            n = 0;
            while (n < n3) {
                Data element = dataArray[n];
                ret = (String)ret + element.tail[curvalue] + separator;
                ++n;
            }
            ret = (String)ret + nl;
            ++curvalue;
        }
        return ret;
    }

    public void SetChannelName(int channel, String name) {
        this.chan[channel].name = name;
    }

    public String getChannelName(int channel) {
        return this.chan[channel].name;
    }

    public void setSteady(int channel, boolean steady, int steadyPosition) {
        this.chan[channel].steady = steady;
        this.chan[channel].originalSteadyPosition = steadyPosition;
        if (steady) {
            if (steadyPosition == -1) {
                this.chan[channel].cursor = (int)((double)this.width * 0.75);
            } else if (steadyPosition > 0 && steadyPosition < this.width) {
                this.chan[channel].cursor = steadyPosition;
            }
        }
    }

    public boolean isSteady(int channel) {
        return this.chan[channel].steady;
    }

    public int getBase(int channel) {
        return this.chan[channel].base;
    }

    public int getBaseOffset(int channel) {
        return this.chan[channel].baseOffset;
    }

    public int getChannels() {
        return this.chan.length;
    }

    public Color getForeground(int channel) {
        return this.chan[channel].fg;
    }

    public int getLineWidth(int channel) {
        return this.chan[channel].lineWidth;
    }

    public int getTailFade(int channel) {
        return this.chan[channel].tailFade;
    }

    public int getTailSize(int channel) {
        return this.chan[channel].tailSize;
    }

    public boolean isConnect(int channel) {
        return this.chan[channel].connect;
    }

    public boolean isFade(int channel) {
        return this.chan[channel].fade;
    }

    public boolean isPercentage(int channel) {
        return this.chan[channel].percentage;
    }

    public boolean isAntiAlias(int channel) {
        return this.chan[channel].antiAlias;
    }

    public void setTailSize(int channel, int newSize) {
        int size = newSize;
        this.checkWidget();
        if (size == -2 && !this.isSteady(channel)) {
            size = -1;
        }
        if (this.chan[channel].originalTailSize != size) {
            Plotter.tailSizeCheck(size);
            this.chan[channel].originalTailSize = size;
            this.setTailSizeInternal(channel);
        }
    }

    private static void tailSizeCheck(int size) {
        if (size < -3 || size == 0) {
            throw new RuntimeException("Invalid tail size " + size);
        }
    }

    protected void widgetDisposed(Event e) {
    }

    protected void controlMoved(Event e) {
    }

    protected void controlResized(Event e) {
        this.width = this.getSize().x;
        this.height = this.getSize().y;
        int c = 0;
        while (c < this.chan.length) {
            this.calculateBase(c);
            ++c;
        }
        if (this.getBounds().width > 0) {
            int channel = 0;
            while (channel < this.chan.length) {
                this.setSteady(channel, this.chan[channel].steady, this.chan[channel].originalSteadyPosition);
                this.setTailSizeInternal(channel);
                ++channel;
            }
        }
    }

    public void setTailFade(int channel, int newTailFade) {
        int tailFade = newTailFade;
        this.checkWidget();
        if (tailFade > 100) {
            tailFade = 100;
        }
        if (tailFade < 1) {
            tailFade = 1;
        }
        this.chan[channel].tailFade = tailFade;
    }

    public void setFade(int channel, boolean fade) {
        this.chan[channel].fade = fade;
    }

    public void setForeground(int channel, Color color) {
        this.chan[channel].fg = color;
    }

    public void setLineWidth(int channel, int lineWidth) {
        if (lineWidth > 0) {
            this.chan[channel].lineWidth = lineWidth;
        }
    }

    public void setPercentage(int channel, boolean percentage) {
        this.chan[channel].percentage = percentage;
    }

    public void setBaseOffset(int channel, int newBaseOffset) {
        int baseOffset = newBaseOffset;
        if (baseOffset > 100) {
            baseOffset = 100;
        }
        if (baseOffset < -100) {
            baseOffset = -100;
        }
        this.chan[channel].baseOffset = baseOffset;
        this.calculateBase(channel);
    }

    public void setConnect(int channel, boolean connectHeadAndTail) {
        this.chan[channel].connect = connectHeadAndTail;
    }

    public void setAntialias(int channel, boolean antialias) {
        this.chan[channel].antiAlias = antialias;
    }

    private class Data {
        private int base;
        private int baseOffset = 50;
        private boolean connect;
        private int cursor = 50;
        private boolean fade;
        private Color fg;
        private int lineWidth = 1;
        private int originalSteadyPosition = -1;
        private int originalTailSize;
        private boolean percentage = false;
        private boolean steady;
        private int[] tail;
        private int tailFade = 25;
        private int tailSize = -3;
        private boolean antiAlias = false;
        private String name = new String();

        private Data() {
        }
    }
}

