/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.fontawesome;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.eclipse.nebula.widgets.fontawesome.FontAwesome;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;

public class FontAwesomeSnippet3 {
    private static Slider fSlider;
    private static int fFontSize;
    private static ScrolledComposite fScrolledComposite;
    private static Label fFontLabel;

    static {
        fFontSize = 22;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("FontAwesome Snippet");
        shell.setSize(1000, 600);
        shell.setLayout((Layout)new GridLayout(2, false));
        fScrolledComposite = new ScrolledComposite((Composite)shell, 2816);
        fScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        fScrolledComposite.setAlwaysShowScrollBars(false);
        fScrolledComposite.setExpandHorizontal(true);
        fScrolledComposite.setExpandVertical(true);
        Composite composite = new Composite((Composite)fScrolledComposite, 0);
        fScrolledComposite.setContent((Control)composite);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.marginTop = 5;
        rowLayout.marginRight = 5;
        rowLayout.marginLeft = 5;
        rowLayout.marginBottom = 5;
        rowLayout.pack = false;
        composite.setLayout((Layout)rowLayout);
        FontAwesomeSnippet3.buildComposite(composite);
        FontAwesomeSnippet3.calcMinsize(composite);
        shell.layout(true, true);
        fFontLabel = new Label((Composite)shell, 0);
        fFontLabel.setText("Font size (22)");
        fSlider = new Slider((Composite)shell, 0);
        fSlider.addListener(4, e -> {
            shell.setRedraw(false);
            Arrays.asList(composite.getChildren()).forEach(c -> c.dispose());
            fFontSize = fSlider.getSelection();
            FontAwesomeSnippet3.buildComposite(composite);
            fFontLabel.setText("Font size (" + fFontSize + ")");
            shell.setRedraw(true);
            shell.layout(true, true);
            FontAwesomeSnippet3.calcMinsize(composite);
        });
        fSlider.setPageIncrement(1);
        fSlider.setMaximum(150);
        fSlider.setMinimum(4);
        fSlider.setSelection(22);
        fSlider.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void calcMinsize(Composite composite) {
        Point computeSize = fScrolledComposite.getChildren()[0].computeSize(FontAwesomeSnippet3.fScrolledComposite.getShell().getClientArea().width - 50, -1);
        fScrolledComposite.setMinSize(computeSize);
    }

    private static void buildComposite(Composite composite) {
        try {
            Field[] fields;
            Field[] fieldArray = fields = FontAwesome.class.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String value;
                Field field = fieldArray[n2];
                field.setAccessible(true);
                if (field.getType().equals(String.class) && (value = (String)field.get(null)).length() == 1) {
                    Label text = new Label(composite, 0);
                    text.setFont(FontAwesome.getFont((int)fFontSize));
                    text.setText(value);
                    text.setToolTipText(field.getName());
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

