/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.IXViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.util.Pair;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;

public class XViewerSorter
extends ViewerSorter {
    private final XViewer treeViewer;
    public static final SimpleDateFormat format10 = new SimpleDateFormat("MM/dd/yyyy");

    public XViewerSorter(XViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public int compare(Viewer viewer, Object o1, Object o2, int sortXColIndex) {
        if (this.treeViewer.getCustomizeMgr().isLoading()) {
            return 0;
        }
        List<XViewerColumn> sortXCols = this.treeViewer.getCustomizeMgr().getSortXCols();
        if (sortXCols == null || sortXCols.isEmpty()) {
            return 0;
        }
        XViewerColumn sortXCol = sortXCols.get(sortXColIndex);
        try {
            int columnNum = this.treeViewer.getCustomizeMgr().getColumnNumFromXViewerColumn(sortXCol);
            String o1Str = this.treeViewer.getColumnText(o1, columnNum);
            Object obj1 = null;
            String o2Str = this.treeViewer.getColumnText(o2, columnNum);
            Object obj2 = null;
            IBaseLabelProvider labelProvider = this.treeViewer.getLabelProvider();
            if (labelProvider instanceof IXViewerLabelProvider) {
                obj1 = ((IXViewerLabelProvider)labelProvider).getBackingData(o1, sortXCol, columnNum);
                obj2 = ((IXViewerLabelProvider)labelProvider).getBackingData(o2, sortXCol, columnNum);
            }
            int compareInt = 0;
            compareInt = o1Str == null ? -1 : (o2Str == null ? 1 : (sortXCol.getSortDataType() == SortDataType.Date ? this.getCompareForDate(o1Str, obj1, o2Str, obj2) : (sortXCol.getSortDataType() == SortDataType.Percent ? this.getCompareForPercent(o1Str, o2Str) : (sortXCol.getSortDataType() == SortDataType.Float ? this.getCompareForFloat(o1Str, o2Str) : (sortXCol.getSortDataType() == SortDataType.Integer ? this.getCompareForInteger(o1Str, o2Str) : (sortXCol.getSortDataType() == SortDataType.Long ? this.getCompareForLong(o1Str, o2Str) : (sortXCol.getSortDataType() == SortDataType.Paragraph_Number ? this.paragraphNumberCompare(o1Str, o2Str) : this.getComparator().compare(o1Str, o2Str))))))));
            return this.getCompareBasedOnDirection(sortXCol, compareInt, viewer, o1, o2, sortXColIndex);
        }
        catch (Exception ex) {
            XViewerLog.log(Activator.class, Level.SEVERE, ex);
            return 0;
        }
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        return this.compare(viewer, o1, o2, 0);
    }

    public int paragraphNumberCompare(String s1, String s2) {
        StringTokenizer st1 = new StringTokenizer(s1, ".");
        StringTokenizer st2 = new StringTokenizer(s2, ".");
        while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
            int result;
            String t1 = st1.nextToken();
            String t2 = st2.nextToken();
            try {
                Integer i1 = Integer.valueOf(t1);
                Integer i2 = Integer.valueOf(t2);
                result = i1.compareTo(i2);
            }
            catch (NumberFormatException e) {
                result = t1.compareTo(t2);
            }
            if (result == 0) continue;
            return result;
        }
        return s1.compareTo(s2);
    }

    public int getCompareBasedOnDirection(XViewerColumn sortXCol, int compareInt, Viewer viewer, Object o1, Object o2, int sortXColIndex) {
        List<XViewerColumn> sortXCols = this.treeViewer.getCustomizeMgr().getSortXCols();
        int returnInt = (sortXCol.isSortForward() ? 1 : -1) * compareInt;
        if (returnInt == 0 && sortXCols.size() > sortXColIndex + 1) {
            returnInt = this.compare(viewer, o1, o2, sortXColIndex + 1);
        }
        return returnInt;
    }

    public int getCompareForFloat(String float1, String float2) {
        double float1Float = 0.0;
        boolean float1Exception = false;
        try {
            float1Float = new Double(float1);
        }
        catch (NumberFormatException ex) {
            float1Exception = true;
        }
        double float2Float = 0.0;
        boolean float2Exception = false;
        try {
            float2Float = new Double(float2);
        }
        catch (NumberFormatException ex) {
            float2Exception = true;
        }
        int toReturn = 0;
        toReturn = float1Exception && float2Exception ? this.getComparator().compare(float1, float2) : (float1Exception && !float2Exception ? -1 : (!float1Exception && float2Exception ? 1 : XViewerSorter.getCompareForFloat(float1Float, float2Float)));
        return toReturn;
    }

    public int getCompareForInteger(String int1, String int2) {
        int int1Integer = 0;
        boolean int1Exception = false;
        try {
            int1Integer = Integer.valueOf(int1);
        }
        catch (NumberFormatException ex) {
            int1Exception = true;
        }
        int int2Integer = 0;
        boolean int2Exception = false;
        try {
            int2Integer = Integer.valueOf(int2);
        }
        catch (NumberFormatException ex) {
            int2Exception = true;
        }
        int toReturn = 0;
        toReturn = int1Exception && int2Exception ? this.getComparator().compare(int1, int2) : (int1Exception && !int2Exception ? -1 : (!int1Exception && int2Exception ? 1 : XViewerSorter.getCompareForInteger(int1Integer, int2Integer)));
        return toReturn;
    }

    public int getCompareForLong(String long1, String long2) {
        long long1Long = 0L;
        boolean long1Exception = false;
        try {
            long1Long = Long.valueOf(long1);
        }
        catch (NumberFormatException ex) {
            long1Exception = true;
        }
        long long2Integer = 0L;
        boolean long2Exception = false;
        try {
            long2Integer = Long.valueOf(long2);
        }
        catch (NumberFormatException ex) {
            long2Exception = true;
        }
        int toReturn = 0;
        toReturn = long1Exception && long2Exception ? this.getComparator().compare(long1, long2) : (long1Exception && !long2Exception ? -1 : (!long1Exception && long2Exception ? 1 : XViewerSorter.getCompareForLong(long1Long, long2Integer)));
        return toReturn;
    }

    public static int getCompareForFloat(double float1, double float2) {
        if (float1 == float2) {
            return 0;
        }
        if (float1 < float2) {
            return -1;
        }
        if (float2 < float1) {
            return 1;
        }
        return 0;
    }

    public static int getCompareForInteger(int int1, int int2) {
        if (int1 == int2) {
            return 0;
        }
        if (int1 < int2) {
            return -1;
        }
        if (int2 < int1) {
            return 1;
        }
        return 0;
    }

    public static int getCompareForLong(long long1, long long2) {
        if (long1 == long2) {
            return 0;
        }
        if (long1 < long2) {
            return -1;
        }
        if (long2 < long1) {
            return 1;
        }
        return 0;
    }

    public int getCompareForDate(String date1, Object obj1, String date2, Object obj2) {
        Date date1Date = null;
        if (obj1 != null && obj1 instanceof Date) {
            date1Date = (Date)obj1;
        }
        Date date2Date = null;
        if (obj2 != null && obj2 instanceof Date) {
            date2Date = (Date)obj2;
        }
        if (date1Date != null && date2Date != null) {
            return this.getCompareForDate(date1Date, date2Date);
        }
        if (obj1 == null && obj2 == null) {
            return 0;
        }
        if (obj1 == null) {
            return -1;
        }
        return 1;
    }

    public static Pair<Date, Date> parseDatePair(String date1, String date2) {
        Date date4;
        Date date3;
        Pair<Object, Object> datePair = new Pair<Object, Object>(null, null);
        SimpleDateFormat format = date1.length() == 10 ? format10 : new SimpleDateFormat();
        try {
            date3 = format.parse(date1);
            datePair.setFirst(date3);
        }
        catch (ParseException ex) {
            try {
                date4 = new SimpleDateFormat().parse(date1);
                datePair.setFirst(date4);
            }
            catch (ParseException date4) {
                // empty catch block
            }
        }
        try {
            date3 = format.parse(date2);
            datePair.setSecond(date3);
        }
        catch (ParseException ex) {
            try {
                date4 = DateFormat.getInstance().parse(date2);
                datePair.setSecond(date4);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return datePair;
    }

    public int getCompareForDate(Date date1, Date date2) {
        return date1.compareTo(date2);
    }

    public int getCompareForPercent(String percent1, String percent2) {
        int percent1Int = 0;
        boolean percent1Exception = false;
        try {
            percent1Int = Integer.valueOf(percent1);
        }
        catch (NumberFormatException ex) {
            percent1Exception = true;
        }
        int percent2Int = 0;
        boolean percent2Exception = false;
        try {
            percent2Int = Integer.valueOf(percent2);
        }
        catch (NumberFormatException ex) {
            percent2Exception = true;
        }
        int toReturn = 0;
        toReturn = percent1Exception && percent2Exception ? this.getComparator().compare(percent1, percent2) : (percent1Exception && !percent2Exception ? -1 : (!percent1Exception && percent2Exception ? 1 : this.getCompareForPercent(percent1Int, percent2Int)));
        return toReturn;
    }

    public int getCompareForPercent(int percent1, int percent2) {
        int compareInt = 0;
        compareInt = percent1 == percent2 ? 0 : (percent1 == 0 ? -1 : (percent2 == 0 ? 1 : (percent1 == 100 ? 1 : (percent2 == 100 ? -1 : XViewerSorter.getCompareForInteger(percent1, percent2)))));
        return compareInt;
    }
}

