/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.notifier;

import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.notifier.NotifierColors;
import org.eclipse.nebula.widgets.opal.notifier.NotifierColorsFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Notifier {
    private static final int FONT_SIZE = 10;
    private static final int MAX_DURATION_FOR_OPENING = 500;
    private static final int DISPLAY_TIME = 4500;
    private static final int FADE_TIMER = 50;
    private static final int FADE_OUT_STEP = 8;
    private static final int STEP = 5;

    public static void notify(String title, String text) {
        Notifier.notify(null, title, text, NotifierColorsFactory.NotifierTheme.YELLOW_THEME);
    }

    public static void notify(Image image, String title, String text) {
        Notifier.notify(image, title, text, NotifierColorsFactory.NotifierTheme.YELLOW_THEME);
    }

    public static void notify(String title, String text, NotifierColorsFactory.NotifierTheme theme) {
        Notifier.notify(null, title, text, theme);
    }

    public static void notify(Image image, String title, String text, NotifierColorsFactory.NotifierTheme theme) {
        Shell shell = Notifier.createNotificationWindow(image, title, text, NotifierColorsFactory.getColorsForTheme(theme));
        Notifier.makeShellAppears(shell);
    }

    protected static Shell createNotificationWindow(Image image, String title, String text, NotifierColors colors) {
        Shell shell = new Shell(Display.getDefault().getActiveShell(), 540680);
        shell.setLayout((Layout)new GridLayout(2, false));
        shell.setBackgroundMode(2);
        Notifier.createTitle(shell, title, colors);
        Notifier.createImage(shell, image);
        Notifier.createText(shell, text, colors);
        Notifier.createBackground(shell, colors);
        Notifier.createCloseAction(shell);
        shell.addListener(12, event -> colors.dispose());
        shell.pack();
        shell.setMinimumSize(320, 100);
        return shell;
    }

    private static void createTitle(Shell shell, String title, NotifierColors colors) {
        Label titleLabel = new Label((Composite)shell, 0);
        GridData gdLabel = new GridData(1, 1, true, false, 2, 1);
        gdLabel.horizontalIndent = 40;
        titleLabel.setLayoutData((Object)gdLabel);
        Color titleColor = colors.titleColor;
        titleLabel.setForeground(titleColor);
        Font titleFont = SWTGraphicUtil.buildFontFrom((Control)titleLabel, (int)1, (int)10);
        titleLabel.setFont(titleFont);
        titleLabel.setText(title);
        SWTGraphicUtil.addDisposer((Widget)shell, (Resource[])new Resource[]{titleFont});
    }

    private static void createImage(Shell shell, Image image) {
        Label labelImage = new Label((Composite)shell, 0);
        GridData gdImage = new GridData(2, 1, false, true);
        gdImage.horizontalIndent = 10;
        labelImage.setLayoutData((Object)gdImage);
        if (image == null) {
            Image temp = SWTGraphicUtil.createImageFromFile((String)"images/information.png");
            labelImage.setImage(temp);
            SWTGraphicUtil.addDisposer((Widget)shell, (Resource[])new Resource[]{temp});
        } else {
            labelImage.setImage(image);
        }
    }

    private static void createText(Shell shell, String text, NotifierColors colors) {
        StyledText textLabel = new StyledText((Composite)shell, 72);
        GridData gdText = new GridData(4, 4, true, true);
        gdText.horizontalIndent = 15;
        textLabel.setLayoutData((Object)gdText);
        textLabel.setEnabled(false);
        Font textFont = SWTGraphicUtil.buildFontFrom((Control)textLabel, (int)0, (int)10);
        textLabel.setFont(textFont);
        Color textColor = colors.textColor;
        textLabel.setForeground(textColor);
        Color fillColor = colors.rightColor;
        textLabel.setBackground(fillColor);
        textLabel.setText(text);
        SWTGraphicUtil.applyHTMLFormating((StyledText)textLabel);
        SWTGraphicUtil.addDisposer((Widget)shell, (Resource[])new Resource[]{textFont});
    }

    private static void createBackground(Shell shell, NotifierColors colors) {
        shell.addListener(11, event -> {
            Rectangle rect = shell.getClientArea();
            Image newImage = new Image((Device)Display.getDefault(), Math.max(1, rect.width), rect.height);
            GC gc = new GC((Drawable)newImage);
            gc.setAntialias(1);
            Color borderColor = notifierColors.borderColor;
            Color fillColor1 = notifierColors.leftColor;
            Color fillColor2 = notifierColors.rightColor;
            gc.setBackground(borderColor);
            gc.fillRoundRectangle(0, 0, rect.width, rect.height, 8, 8);
            gc.setBackground(fillColor1);
            gc.fillRoundRectangle(1, 1, rect.width - 2, rect.height - 2, 8, 8);
            gc.setBackground(fillColor2);
            gc.fillRoundRectangle(30, 1, rect.width - 32, rect.height - 2, 8, 8);
            gc.fillRectangle(30, 1, 10, rect.height - 2);
            Image closeImage = SWTGraphicUtil.createImageFromFile((String)"images/close.png");
            gc.drawImage(closeImage, rect.width - 21, 13);
            gc.dispose();
            closeImage.dispose();
            SWTGraphicUtil.addDisposer((Widget)shell, (Resource[])new Resource[]{newImage});
            shell.setBackgroundImage(newImage);
        });
    }

    protected static void makeShellAppears(final Shell shell) {
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Rectangle clientArea = Display.getDefault().getPrimaryMonitor().getClientArea();
        final int startX = clientArea.x + clientArea.width - shell.getSize().x;
        final int stepForPosition = 500 / shell.getSize().y * 5;
        final int stepForAlpha = 1275 / shell.getSize().y;
        final int lastPosition = clientArea.y + clientArea.height - shell.getSize().y;
        shell.setAlpha(0);
        shell.setLocation(startX, clientArea.y + clientArea.height);
        shell.open();
        shell.getDisplay().timerExec(stepForPosition, new Runnable(){

            @Override
            public void run() {
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                shell.setLocation(startX, shell.getLocation().y - 5);
                shell.setAlpha(shell.getAlpha() + stepForAlpha);
                if (shell.getLocation().y >= lastPosition) {
                    shell.getDisplay().timerExec(stepForPosition, (Runnable)this);
                } else {
                    shell.setAlpha(255);
                    Display.getDefault().timerExec(4500, Notifier.fadeOut(shell, false));
                }
            }
        });
    }

    private static Runnable fadeOut(final Shell shell, final boolean fast) {
        return new Runnable(){

            @Override
            public void run() {
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                int currentAlpha = shell.getAlpha();
                if ((currentAlpha -= 8 * (fast ? 8 : 1)) <= 0) {
                    shell.setAlpha(0);
                    shell.dispose();
                    return;
                }
                shell.setAlpha(currentAlpha);
                Display.getDefault().timerExec(50, (Runnable)this);
            }
        };
    }

    private static void createCloseAction(Shell shell) {
        shell.addListener(4, event -> {
            Rectangle rect = shell.getClientArea();
            int xUpperLeftCorner = rect.width - 21;
            int yUpperLeftCorner = 13;
            if (event.x >= xUpperLeftCorner && event.x <= xUpperLeftCorner + 8 && event.y >= 13 && event.y <= 21) {
                Display.getDefault().timerExec(0, Notifier.fadeOut(shell, true));
            }
        });
    }
}

