/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.examples;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.Sample;
import org.eclipse.nebula.visualization.xygraph.figures.Legend;
import org.eclipse.nebula.visualization.xygraph.figures.ToolbarArmedXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class StaircaseExample {
    private static int next_x = 1;

    public static void main(String[] args) {
        Shell shell = new Shell();
        shell.setSize(800, 500);
        shell.open();
        LightweightSystem lws = new LightweightSystem((Canvas)shell);
        ToolbarArmedXYGraph plot = new ToolbarArmedXYGraph(new XYGraph(), 6);
        XYGraph xygraph = (XYGraph)plot.getXYGraph();
        xygraph.setTransparent(false);
        xygraph.setTitle("You should see a line. Zoom out to see more data");
        lws.setContents((IFigure)plot);
        CircularBufferDataProvider data = new CircularBufferDataProvider(true);
        data.addSample(new Sample(next_x++, 1.0, 1.0, 1.0, 0.0, 0.0));
        data.addSample(new Sample(next_x++, 2.0, 1.0, 1.0, 0.0, 0.0));
        data.addSample(new Sample(next_x++, 3.0, 1.0, 1.0, 0.0, 0.0));
        data.addSample(new Sample(next_x++, 1.0, 1.0, 1.0, 0.0, 0.0));
        data.addSample(new Sample(next_x++, 1.0, 1.0, 1.0, 0.0, 0.0));
        data.addSample(new Sample(next_x++, 1.0, 1.0, 1.0, 0.0, 0.0));
        data.addSample(new Sample(next_x++, Double.NaN, 0.0, 0.0, 0.0, 0.0, "Disconnected"));
        data.addSample(new Sample(next_x++, 1.0, 0.0, 0.0, 0.0, 0.0));
        data.addSample(new Sample(next_x++, Double.NaN, 0.0, 0.0, 0.0, 0.0, "Disconnected"));
        data.addSample(new Sample(next_x++, 2.0, 0.0, 0.0, 0.0, 0.0));
        data.addSample(new Sample(Double.MAX_VALUE, 2.0, 0.0, 0.0, 0.0, 0.0));
        xygraph.getPrimaryXAxis().setRange(data.getXDataMinMax());
        xygraph.getPrimaryYAxis().setRange(data.getYDataMinMax());
        xygraph.getPrimaryXAxis().setRange(4.1, 4.9);
        xygraph.getPrimaryXAxis().setRange(7.5, 9.5);
        Trace trace = new Trace("Demo", xygraph.getPrimaryXAxis(), xygraph.getPrimaryYAxis(), data);
        trace.setTraceType(Trace.TraceType.STEP_HORIZONTALLY);
        trace.setErrorBarEnabled(true);
        trace.setDrawYErrorInArea(true);
        xygraph.addTrace(trace);
        Font LEGEND_FONT = XYGraphMediaFactory.getInstance().getFont(new FontData("Lucida Sans", 11, 1));
        Legend legend = xygraph.getLegend(trace);
        legend.setDrawBorder(true);
        legend.setPreferredHeight(100);
        legend.setTextFont(LEGEND_FONT);
        Display display = Display.getDefault();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

