/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.launcher.snippets;

import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.dialog.Dialog;
import org.eclipse.nebula.widgets.opal.launcher.Launcher;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LauncherSnippet {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout(1, false));
        Label title = new Label((Composite)shell, 0);
        title.setText("Launcher");
        title.setLayoutData((Object)new GridData(4, 4, true, false));
        final Launcher l = new Launcher((Composite)shell, 0);
        l.setLayoutData((Object)new GridData(4, 4, true, true));
        l.addItem("Address Book", LauncherSnippet.createImage(shell, "x-office-address-book.png"));
        l.addItem("Calendar", LauncherSnippet.createImage(shell, "x-office-calendar.png"));
        l.addItem("Presentation", LauncherSnippet.createImage(shell, "x-office-presentation.png"));
        l.addItem("Spreadsheet", LauncherSnippet.createImage(shell, "x-office-spreadsheet.png"));
        l.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Dialog.inform((String)"Selection", (String)("You have selected item #" + l.getSelection()));
            }
        });
        Label under = new Label((Composite)shell, 0);
        under.setText("Double-click an icon to launch the program");
        under.setLayoutData((Object)new GridData(4, 4, true, false));
        shell.setSize(new Point(436, 546));
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static Image createImage(Shell shell, String input) {
        Image img = new Image((Device)shell.getDisplay(), LauncherSnippet.class.getResourceAsStream("icons/" + input));
        shell.addListener(12, e -> SWTGraphicUtil.safeDispose((Resource)img));
        return img;
    }
}

