/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pagination;

import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.nebula.widgets.pagination.PageableController;
import org.eclipse.nebula.widgets.pagination.Resources;
import org.eclipse.swt.widgets.Widget;

public class PaginationHelper {
    private static final String PAGINATION_CONTROLLER_KEY = "___PaginationController";
    public static final int SEPARATOR = -1;

    public static int[] getPageIndexes(int currentPageIndex, int totalPages, int nbMax) {
        nbMax = nbMax > totalPages ? totalPages : nbMax;
        int[] indexes = new int[nbMax];
        if (totalPages <= nbMax) {
            int i = 0;
            while (i < indexes.length) {
                indexes[i] = i;
                ++i;
            }
        } else if (currentPageIndex > totalPages - nbMax + 3) {
            int index = totalPages - 1;
            int i = indexes.length - 1;
            while (i >= 0) {
                indexes[i] = i == 0 ? i : (i == 1 ? -1 : index--);
                --i;
            }
        } else if (nbMax - currentPageIndex > 2) {
            int i = 0;
            while (i < indexes.length) {
                indexes[i] = i == nbMax - 1 ? totalPages - 1 : (i == nbMax - 2 ? -1 : i);
                ++i;
            }
        } else {
            int middle = nbMax / 2;
            int index = currentPageIndex;
            int nbItems = 0;
            int i = middle;
            while (i > 0 && index > 0) {
                if (i == 1) {
                    indexes[i] = index == 2 ? index : -1;
                } else if (i == 0) {
                    indexes[i] = 0;
                } else if (index > 0) {
                    indexes[i] = index--;
                }
                ++nbItems;
                --i;
            }
            index = currentPageIndex;
            i = nbItems;
            while (i < nbMax) {
                indexes[i] = i == nbMax - 2 ? (index == totalPages ? index : -1) : (i == nbMax - 1 ? totalPages - 1 : index++);
                ++i;
            }
        }
        return indexes;
    }

    public static PageableController getController(Widget widget) {
        return (PageableController)widget.getData(PAGINATION_CONTROLLER_KEY);
    }

    public static void setController(Widget widget, PageableController controller) {
        widget.setData(PAGINATION_CONTROLLER_KEY, (Object)controller);
    }

    public static String getResultsText(PageableController controller, Locale locale) {
        String resultsMessage = Resources.getText("PaginationRenderer.results", locale);
        return PaginationHelper.getResultsText(controller, resultsMessage);
    }

    public static String getResultsText(PageableController controller, String resultsMessage) {
        long total;
        int start = controller.getPageOffset() + 1;
        int end = start + controller.getPageSize() - 1;
        if ((long)end > (total = controller.getTotalElements())) {
            end = (int)total;
        }
        return PaginationHelper.getResultsText(start, end, total, controller, resultsMessage);
    }

    public static String getResultsText(int start, int end, long total, PageableController controller, String resultsMessage) {
        return MessageFormat.format(resultsMessage, start, end, total);
    }

    public static String getPageText(int pageIndex, int totalPage, Locale locale) {
        String message = Resources.getText("PaginationRenderer.page", locale);
        return MessageFormat.format(message, pageIndex, totalPage);
    }
}

