/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.jface;

import java.util.concurrent.TimeUnit;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.nebula.widgets.timeline.borders.LeftRightBorder;
import org.eclipse.nebula.widgets.timeline.borders.RoundedRectangleBorder;
import org.eclipse.nebula.widgets.timeline.borders.TrackBorder;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.lane.EventFigure;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineStyleProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;

public class DefaultTimelineStyleProvider
implements ITimelineStyleProvider {
    private static final Color[] LANE_COLORS = new Color[]{ColorConstants.lightBlue, ColorConstants.yellow, ColorConstants.red, ColorConstants.lightGreen, ColorConstants.lightGray, ColorConstants.orange};
    private static int fNextLaneColor = 0;
    private Font fDefaultFont = null;
    private Font fSelectedFont = null;
    private final ResourceManager fResourceManager;

    public DefaultTimelineStyleProvider(ResourceManager resourceManager) {
        this.fResourceManager = resourceManager;
    }

    @Override
    public Color getBackgroundColor() {
        return ColorConstants.black;
    }

    @Override
    public Border getDetailAreaBorder() {
        RoundedRectangleBorder border = new RoundedRectangleBorder(10);
        border.setWidth(2);
        border.setColor(this.getGridColor());
        return border;
    }

    @Override
    public Border getOverviewAreaBorder() {
        return this.getDetailAreaBorder();
    }

    @Override
    public Color getGridColor() {
        return ColorConstants.darkGray;
    }

    @Override
    public int getGridLineStyle() {
        return 3;
    }

    @Override
    public Border getOverviewSelectionBorder() {
        return new LeftRightBorder(ColorConstants.red);
    }

    @Override
    public Color getOverviewSelectionBackgroundColor() {
        return ColorConstants.white;
    }

    @Override
    public int getOverviewSelectionBackgroundAlpha() {
        return 40;
    }

    @Override
    public Border getTrackBorder(String title) {
        return new TrackBorder(title);
    }

    @Override
    public Color getCursorColor() {
        return ColorConstants.yellow;
    }

    @Override
    public Color getSelectedCursorColor() {
        return ColorConstants.red;
    }

    @Override
    public boolean showGrid() {
        return true;
    }

    @Override
    public boolean showTimeAxis() {
        return true;
    }

    @Override
    public Color getLaneColor() {
        Color color = LANE_COLORS[fNextLaneColor];
        fNextLaneColor = (fNextLaneColor + 1) % LANE_COLORS.length;
        return color;
    }

    @Override
    public int getLaneHeight() {
        return 40;
    }

    @Override
    public void selectEvent(EventFigure eventFigure) {
        eventFigure.setFont(this.getSelectedFont((IFigure)eventFigure));
        ((IFigure)eventFigure.getChildren().get(0)).revalidate();
        eventFigure.setForegroundColor(ColorConstants.red);
        eventFigure.setLineWidth(3);
        eventFigure.setAlpha(255);
    }

    @Override
    public void unselectEvent(EventFigure eventFigure) {
        eventFigure.setEventColor(eventFigure.getEventColor());
        eventFigure.setLineWidth(2);
        if (this.getDefaultFont() != null) {
            eventFigure.setFont(this.getDefaultFont());
            ((IFigure)eventFigure.getChildren().get(0)).revalidate();
        }
    }

    private Font getDefaultFont() {
        return this.fDefaultFont;
    }

    private Font getSelectedFont(IFigure figure) {
        if (this.fDefaultFont == null) {
            this.fDefaultFont = figure.getFont();
        }
        if (this.fSelectedFont == null) {
            FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)this.fDefaultFont).setStyle(1);
            fontDescriptor = fontDescriptor.setHeight((int)((double)this.fDefaultFont.getFontData()[0].getHeight() * 1.4));
            this.fSelectedFont = this.fResourceManager.createFont(fontDescriptor);
        }
        return this.fSelectedFont;
    }

    @Override
    public double getZoomFactor() {
        return 1.2;
    }

    @Override
    public Color getColor(RGB rgb) {
        return this.fResourceManager.createColor(rgb);
    }

    @Override
    public boolean showOverview() {
        return true;
    }

    @Override
    public int getOverviewLaneHeight() {
        return 4;
    }

    @Override
    public Insets getOverviewInsets() {
        return new Insets(0, 5, 0, 5);
    }

    @Override
    public String getTimeLabel(double timestamp, TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                if (timestamp >= 1000.0) {
                    return this.getTimeLabel(timestamp / 1000.0, TimeUnit.MICROSECONDS);
                }
                return Double.toString((double)Math.round(timestamp * 100.0) / 100.0) + " ns";
            }
            case MICROSECONDS: {
                if (timestamp >= 1000.0) {
                    return this.getTimeLabel(timestamp / 1000.0, TimeUnit.MILLISECONDS);
                }
                return Double.toString((double)Math.round(timestamp * 100.0) / 100.0) + " \u00b5s";
            }
            case MILLISECONDS: {
                if (timestamp >= 1000.0) {
                    return this.getTimeLabel(timestamp / 1000.0, TimeUnit.SECONDS);
                }
                return Double.toString((double)Math.round(timestamp * 100.0) / 100.0) + " ms";
            }
            case SECONDS: {
                if (timestamp >= 60.0) {
                    return this.getTimeLabel(timestamp / 60.0, TimeUnit.MINUTES);
                }
                return Double.toString((double)Math.round(timestamp * 100.0) / 100.0) + " s";
            }
            case MINUTES: {
                if (timestamp >= 60.0) {
                    return this.getTimeLabel(timestamp / 60.0, TimeUnit.HOURS);
                }
                return Double.toString((double)Math.round(timestamp * 100.0) / 100.0) + " min";
            }
            case HOURS: {
                if (timestamp >= 24.0) {
                    return this.getTimeLabel(timestamp / 24.0, TimeUnit.DAYS);
                }
                return Double.toString((double)Math.round(timestamp * 100.0) / 100.0) + " h";
            }
            case DAYS: {
                return Double.toString((double)Math.round(timestamp * 100.0) / 100.0) + " days";
            }
        }
        return Double.toString((double)Math.round(timestamp * 100.0) / 100.0);
    }
}

