/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.dialog;

import org.eclipse.nebula.widgets.opal.commons.ReadOnlyStyledText;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.commons.StringUtil;
import org.eclipse.nebula.widgets.opal.dialog.ChoiceItem;
import org.eclipse.nebula.widgets.opal.dialog.ChoiceWidget;
import org.eclipse.nebula.widgets.opal.dialog.Dialog;
import org.eclipse.nebula.widgets.opal.dialog.DialogArea;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class MessageArea
extends DialogArea {
    private static final int INDENT_NO_ICON = 8;
    private static final int DEFAULT_MARGIN = 10;
    private Composite composite;
    private String title;
    private Image icon;
    private String text;
    private int radioChoice = -1;
    private int radioDefaultSelection;
    private String[] radioValues;
    private Throwable exception;
    private Text textException;
    private String textBoxValue;
    private int choice = -1;
    private int choiceDefaultSelection;
    private ChoiceItem[] choiceValues;
    private ProgressBar progressBar;
    private int progressBarMinimumValue;
    private int progressBarMaximumValue;
    private int progressBarValue = -1;
    private boolean verticalScrollbar = false;
    private int height = -1;
    private StyledText label;
    private String checkBoxLabel;
    private boolean checkBoxValue;
    private Composite bottomComponent;

    public MessageArea(Dialog parent) {
        super(parent);
    }

    public MessageArea addChoice(int defaultSelection, ChoiceItem ... items) {
        this.setInitialised(true);
        this.choiceDefaultSelection = defaultSelection;
        this.choiceValues = items;
        return this;
    }

    public MessageArea addRadioButtons(int defaultSelection, String ... values) {
        this.setInitialised(true);
        this.radioDefaultSelection = defaultSelection;
        this.radioValues = values;
        return this;
    }

    public MessageArea addTextBox(String value) {
        this.setInitialised(true);
        this.textBoxValue = value;
        return this;
    }

    public MessageArea addProgressBar(int mininum, int maximum, int value) {
        this.setInitialised(true);
        this.progressBarMinimumValue = mininum;
        this.progressBarMaximumValue = maximum;
        this.progressBarValue = value;
        return this;
    }

    public MessageArea addCheckBox(String label, boolean selection) {
        this.checkBoxLabel = label;
        this.checkBoxValue = selection;
        this.setInitialised(true);
        return this;
    }

    @Override
    public void render() {
        int numberOfRows;
        if (!this.isInitialised()) {
            return;
        }
        this.composite = new Composite((Composite)this.parent.shell, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite.setBackground(this.composite.getDisplay().getSystemColor(1));
        this.composite.setBackgroundMode(1);
        boolean hasIcon = this.icon != null;
        boolean hasTitle = !StringUtil.isEmpty((String)this.title);
        boolean hasText = !StringUtil.isEmpty((String)this.text);
        boolean hasRadio = this.radioValues != null;
        boolean hasException = this.exception != null;
        boolean hasTextbox = this.textBoxValue != null;
        boolean hasChoice = this.choiceValues != null;
        boolean hasProgressBar = this.progressBarValue != -1;
        boolean hasCheckbox = !StringUtil.isEmpty((String)this.checkBoxLabel);
        int numberOfColumns = hasIcon ? 2 : 1;
        int n = numberOfRows = hasTitle && hasText ? 2 : 1;
        if (hasRadio) {
            numberOfRows += this.radioValues.length;
        }
        if (hasChoice) {
            numberOfRows += this.choiceValues.length;
        }
        if (hasException || hasTextbox) {
            ++numberOfRows;
        }
        if (hasProgressBar) {
            ++numberOfRows;
        }
        GridLayout gridLayout = new GridLayout(numberOfColumns, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginRight = 10;
        gridLayout.marginLeft = 10;
        gridLayout.marginTop = 10;
        gridLayout.marginBottom = 10;
        this.composite.setLayout((Layout)gridLayout);
        if (hasIcon) {
            this.createIcon(numberOfRows);
        }
        if (hasTitle) {
            this.createTitle(hasIcon);
        }
        if (hasText) {
            this.createText(hasIcon, hasTitle);
        }
        if (hasRadio) {
            this.createRadioButtons();
        }
        if (hasException) {
            this.createTextException();
        }
        if (hasTextbox) {
            this.createTextBox();
        }
        if (hasChoice) {
            this.createChoice();
        }
        if (hasProgressBar) {
            this.createProgressBar();
        }
        this.bottomComponent = new Composite((Composite)this.parent.shell, 0);
        this.bottomComponent.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.bottomComponent.setBackground(this.composite.getDisplay().getSystemColor(1));
        this.bottomComponent.setBackgroundMode(1);
        GridLayout bottomGridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        bottomGridLayout.marginHeight = 0;
        bottomGridLayout.marginRight = 10;
        bottomGridLayout.marginLeft = 10;
        bottomGridLayout.marginTop = 10;
        bottomGridLayout.marginBottom = 10;
        this.bottomComponent.setLayout((Layout)gridLayout);
        if (hasCheckbox) {
            this.createCheckBox();
        }
    }

    private void createIcon(int numberOfRows) {
        Label label = new Label(this.composite, 0);
        label.setImage(this.icon);
        label.setLayoutData((Object)new GridData(2, 1, false, false, 1, numberOfRows));
    }

    private void createTitle(boolean hasIcon) {
        Label label = new Label(this.composite, 0);
        label.setText(this.title);
        label.setFont(this.getBiggerFont());
        label.setForeground(this.getTitleColor());
        GridData gd = new GridData(1, 1, false, false, 1, 1);
        if (hasIcon) {
            gd.horizontalIndent = 8;
        } else {
            gd.horizontalIndent = 10;
            gd.verticalIndent = 10;
        }
        label.setLayoutData((Object)gd);
    }

    private void createText(boolean hasIcon, boolean hasTitle) {
        this.label = new ReadOnlyStyledText(this.composite, this.verticalScrollbar ? 512 : 0);
        this.label.setText(this.text);
        SWTGraphicUtil.applyHTMLFormating((StyledText)this.label);
        this.label.setEditable(false);
        GridData gd = new GridData(4, 4, true, false, 1, 1);
        if (this.height != -1) {
            gd.heightHint = this.height;
        }
        if (hasIcon) {
            gd.horizontalIndent = 8;
        } else {
            gd.horizontalIndent = 20;
            gd.verticalIndent = hasTitle ? 8 : 20;
        }
        this.label.setLayoutData((Object)gd);
    }

    private void createRadioButtons() {
        int i = 0;
        while (i < this.radioValues.length) {
            Button button = new Button(this.composite, 16);
            button.setText(this.radioValues[i]);
            Integer index = i;
            button.addListener(13, e -> {
                if (button.getSelection()) {
                    this.radioChoice = index;
                }
            });
            button.setSelection(i == this.radioDefaultSelection);
            GridData gd = new GridData(1, 1, false, false, 1, 1);
            gd.horizontalIndent = 10;
            button.setLayoutData((Object)gd);
            ++i;
        }
    }

    private void createTextException() {
        this.textException = new Text(this.composite, 2826);
        this.textException.setText(StringUtil.stackStraceAsString((Throwable)this.exception));
        this.textException.setBackground(this.composite.getBackground());
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        this.textException.setLayoutData((Object)gd);
    }

    private void createTextBox() {
        final Text textbox = new Text(this.composite, 2112);
        textbox.setText(this.textBoxValue);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        textbox.setLayoutData((Object)gd);
        textbox.addListener(24, e -> {
            this.textBoxValue = textbox.getText();
        });
        textbox.addListener(2, e -> {
            if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                this.parent.shell.dispose();
                this.parent.getFooterArea().selectedButtonIndex = 0;
            }
        });
        textbox.getShell().addListener(26, new Listener(){

            public void handleEvent(Event arg0) {
                textbox.forceFocus();
                textbox.setSelection(textbox.getText().length());
                textbox.getShell().removeListener(26, (Listener)this);
            }
        });
    }

    private void createChoice() {
        int i = 0;
        while (i < this.choiceValues.length) {
            ChoiceWidget choice = new ChoiceWidget(this.composite, 16);
            choice.setChoiceItem(this.choiceValues[i]);
            final Integer index = i;
            choice.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MessageArea.this.choice = index;
                    MessageArea.this.parent.shell.dispose();
                }
            });
            choice.setSelection(i == this.choiceDefaultSelection);
            GridData gd = new GridData(4, 4, false, false, 1, 1);
            choice.setLayoutData(gd);
            ++i;
        }
    }

    private void createProgressBar() {
        this.progressBar = new ProgressBar(this.composite, 65792);
        this.progressBar.setMinimum(this.progressBarMinimumValue);
        this.progressBar.setMaximum(this.progressBarMaximumValue);
        this.progressBar.setSelection(this.progressBarValue);
        GridData gd = new GridData(4, 4, true, false, 1, 1);
        this.progressBar.setLayoutData((Object)gd);
    }

    private void createCheckBox() {
        Button button = new Button(this.bottomComponent, 32);
        button.setText(this.checkBoxLabel);
        button.setSelection(this.checkBoxValue);
        button.setLayoutData((Object)new GridData(1, 1024, true, true, 1, 1));
        button.addListener(13, e -> {
            this.checkBoxValue = button.getSelection();
        });
    }

    void hideException() {
        Point size = this.parent.shell.getSize();
        this.textException.setVisible(false);
        ((GridData)this.textException.getLayoutData()).exclude = true;
        this.parent.shell.setMinimumSize(new Point(0, 0));
        this.parent.shell.layout();
        this.parent.pack();
        this.parent.shell.setMinimumSize(this.parent.shell.getSize());
        this.parent.setLastSize(size);
    }

    void showException() {
        if (this.textException == null) {
            this.createTextException();
        } else {
            this.textException.setVisible(true);
            ((GridData)this.textException.getLayoutData()).exclude = false;
            this.parent.shell.layout();
        }
        this.parent.pack();
    }

    public String getTitle() {
        return this.title;
    }

    public MessageArea setTitle(String title) {
        this.title = title;
        this.setInitialised(true);
        return this;
    }

    public Image getIcon() {
        return this.icon;
    }

    public MessageArea setIcon(Image icon) {
        this.icon = icon;
        this.setInitialised(true);
        return this;
    }

    public String getText() {
        return this.text;
    }

    public MessageArea setText(String text) {
        this.text = text;
        this.setInitialised(true);
        if (this.progressBar != null && this.label != null && !this.label.isDisposed()) {
            this.label.setText(text);
            SWTGraphicUtil.applyHTMLFormating((StyledText)this.label);
        }
        return this;
    }

    public int getRadioChoice() {
        return this.radioChoice;
    }

    public Throwable getException() {
        return this.exception;
    }

    public MessageArea setException(Throwable exception) {
        this.exception = exception;
        this.setInitialised(true);
        return this;
    }

    public int getChoice() {
        return this.choice;
    }

    public String getTextBoxValue() {
        return this.textBoxValue;
    }

    public int getProgressBarMinimumValue() {
        return this.progressBarMinimumValue;
    }

    public void setProgressBarMinimumValue(int progressBarMinimumValue) {
        this.progressBarMinimumValue = progressBarMinimumValue;
        if (this.progressBar != null && !this.progressBar.isDisposed()) {
            this.progressBar.setMinimum(progressBarMinimumValue);
        }
    }

    public int getProgressBarMaximumValue() {
        return this.progressBarMaximumValue;
    }

    public void setProgressBarMaximumValue(int progressBarMaximumValue) {
        this.progressBarMaximumValue = progressBarMaximumValue;
        if (this.progressBar != null && !this.progressBar.isDisposed()) {
            this.progressBar.setMaximum(progressBarMaximumValue);
        }
    }

    public int getProgressBarValue() {
        return this.progressBarValue;
    }

    public void setProgressBarValue(int progressBarValue) {
        this.progressBarValue = progressBarValue;
        if (this.progressBar != null && !this.progressBar.isDisposed()) {
            this.progressBar.setSelection(progressBarValue);
        }
    }

    public boolean isVerticalScrollbar() {
        return this.verticalScrollbar;
    }

    public void setVerticalScrollbar(boolean verticalScrollbar) {
        this.verticalScrollbar = verticalScrollbar;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean getCheckBoxValue() {
        return this.checkBoxValue;
    }
}

