/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.examples;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.figures.Annotation;
import org.eclipse.nebula.visualization.xygraph.figures.Legend;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SimpleExample {
    public static void main(String[] args) {
        Shell shell = new Shell();
        shell.setSize(300, 250);
        shell.open();
        LightweightSystem lws = new LightweightSystem((Canvas)shell);
        XYGraph xyGraph = new XYGraph();
        xyGraph.setTitle("Simple Example");
        lws.setContents((IFigure)xyGraph);
        CircularBufferDataProvider traceDataProvider = new CircularBufferDataProvider(false);
        traceDataProvider.setBufferSize(100);
        traceDataProvider.setCurrentXDataArray(new double[]{10.0, 23.0, 34.0, 45.0, 56.0, 78.0, 88.0, 99.0});
        traceDataProvider.setCurrentYDataArray(new double[]{11.0, 44.0, 55.0, 45.0, 88.0, 98.0, 52.0, 23.0});
        Trace trace = new Trace("Trace1-XY Plot", xyGraph.getPrimaryXAxis(), xyGraph.getPrimaryYAxis(), traceDataProvider);
        trace.setPointStyle(Trace.PointStyle.XCROSS);
        Annotation lAnnotation = new Annotation("Point1", xyGraph.getPrimaryXAxis(), xyGraph.getPrimaryYAxis());
        lAnnotation.setValues(10.0, 11.0);
        lAnnotation.setEnabled(true);
        lAnnotation.setShowPosition(true);
        lAnnotation.setShowName(true);
        lAnnotation.setShowSampleInfo(false);
        lAnnotation.setCursorLineStyle(Annotation.CursorLineStyle.NONE);
        lAnnotation.setAnnotationColor(ColorConstants.darkGray);
        xyGraph.addAnnotation(lAnnotation);
        xyGraph.addTrace(trace);
        Font LEGEND_FONT = XYGraphMediaFactory.getInstance().getFont(new FontData("Lucida Sans", 11, 1));
        Legend legend = xyGraph.getLegend(trace);
        legend.setDrawBorder(true);
        legend.setPreferredHeight(100);
        legend.setTextFont(LEGEND_FONT);
        Display display = Display.getDefault();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

