/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.examples;

import java.util.ArrayList;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.nebula.examples.ButtonFactory;
import org.eclipse.nebula.examples.ExamplesView;
import org.eclipse.nebula.examples.ListenersDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractExampleTab {
    public static int[] eventIds = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37};
    public static String[] eventNames = new String[]{"KeyDown", "KeyUp", "MouseDown", "MouseUp", "MouseMove", "MouseEnter", "MouseExit", "MouseDoubleClick", "Paint", "Move", "Resize", "Dispose", "Selection", "DefaultSelection", "FocusIn", "FocusOut", "Expand", "Collapse", "Iconify", "Deiconify", "Close", "Show", "Hide", "Modify", "Verify", "Activate", "Deactivate", "Help", "DragDetect", "Arm", "Traverse", "MouseHover", "HardKeyDown", "HardKeyUp", "MenuDetect", "SetData", "MouseWheel"};
    private ArrayList selectedEvents = new ArrayList();
    private ArrayList additionalEventParticipants = new ArrayList();
    private Listener listenerThatPrints;
    private GridData controlGridData = new GridData();
    private Composite controlArea;
    private Control controlExample;
    private boolean vFill = false;
    private boolean hFill = false;
    private Button listen;
    private Color modifiedBack;
    private Color modifiedFore;

    public abstract void createParameters(Composite var1);

    public abstract Control createControl(Composite var1);

    public abstract String[] createLinks();

    protected void recreateExample() {
        if (this.controlExample != null && !this.controlExample.isDisposed()) {
            this.controlExample.dispose();
        }
        this.controlExample = this.createControl(this.controlArea);
        if (this.modifiedBack != null) {
            this.controlExample.setBackground(this.modifiedBack);
        }
        if (this.modifiedFore != null) {
            this.controlExample.setForeground(this.modifiedFore);
        }
        this.updateListeners();
        this.controlExample.setLayoutData((Object)this.controlGridData);
        this.controlArea.layout(true);
    }

    protected void relayoutExample() {
        this.controlGridData.verticalAlignment = this.vFill ? 4 : 1;
        this.controlGridData.grabExcessVerticalSpace = this.vFill;
        this.controlGridData.horizontalAlignment = this.hFill ? 4 : 1;
        this.controlGridData.grabExcessHorizontalSpace = this.hFill;
        this.controlExample.setLayoutData((Object)this.controlGridData);
        this.controlArea.layout(true, true);
    }

    public final void create(Composite parent) {
        GridLayout gl = new GridLayout(2, false);
        parent.setLayout((Layout)gl);
        this.controlArea = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.minimumHeight = 100;
        this.controlArea.setLayoutData((Object)gd);
        this.controlArea.setLayout((Layout)new GridLayout());
        Group paramsGroup = new Group(parent, 16);
        paramsGroup.setText("Parameters");
        paramsGroup.setLayoutData((Object)new GridData(1040));
        paramsGroup.setLayout((Layout)new FillLayout());
        ScrolledComposite sc = new ScrolledComposite((Composite)paramsGroup, 512);
        sc.getVerticalBar().setIncrement(10);
        sc.getVerticalBar().setPageIncrement(100);
        Composite content = new Composite((Composite)sc, 0);
        content.setLayout((Layout)new GridLayout());
        Composite paramsArea = new Composite(content, 0);
        this.createParameters(paramsArea);
        Composite lowerParamsArea = new Composite(content, 0);
        lowerParamsArea.setLayoutData((Object)new GridData(768));
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo(lowerParamsArea);
        Group sizeGroup = new Group(lowerParamsArea, 16);
        sizeGroup.setText("Size");
        sizeGroup.setLayoutData((Object)new GridData(1808));
        this.createSize((Composite)sizeGroup);
        Group linksGroup = new Group(lowerParamsArea, 16);
        linksGroup.setText("Links");
        linksGroup.setLayoutData((Object)new GridData(1808));
        this.createLinks((Composite)linksGroup);
        Composite thirdParmsArea = new Composite(content, 0);
        thirdParmsArea.setLayoutData((Object)new GridData(768));
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo(thirdParmsArea);
        Group colorsGroup = new Group(thirdParmsArea, 16);
        colorsGroup.setText("Colors");
        colorsGroup.setLayoutData((Object)new GridData(1808));
        this.createColors((Composite)colorsGroup);
        Group backModeGroup = new Group(thirdParmsArea, 16);
        backModeGroup.setText("Background Mode on Parent");
        backModeGroup.setLayoutData((Object)new GridData(1808));
        this.createBackMode((Composite)backModeGroup);
        sc.setContent((Control)content);
        sc.setMinSize(content.computeSize(-1, -1));
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Group listenersGroup = new Group(parent, 16);
        listenersGroup.setText("Listeners");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        listenersGroup.setLayoutData((Object)gd);
        this.createListeners((Composite)listenersGroup);
        this.recreateExample();
        this.relayoutExample();
    }

    private void createColors(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Button back = new Button(parent, 8);
        back.setText("Background...");
        back.addListener(13, event -> {
            ColorDialog cd = new ColorDialog(Display.getCurrent().getActiveShell());
            RGB newRGB = cd.open();
            if (newRGB != null) {
                Color newColor = new Color((Device)Display.getCurrent(), newRGB);
                this.controlExample.setBackground(newColor);
                if (this.modifiedBack != null) {
                    this.modifiedBack.dispose();
                }
                this.modifiedBack = newColor;
            }
        });
        Button fore = new Button(parent, 8);
        fore.setText("Foreground...");
        fore.addListener(13, event -> {
            ColorDialog cd = new ColorDialog(Display.getCurrent().getActiveShell());
            RGB newRGB = cd.open();
            if (newRGB != null) {
                Color newColor = new Color((Device)Display.getCurrent(), newRGB);
                this.controlExample.setForeground(newColor);
                if (this.modifiedFore != null) {
                    this.modifiedFore.dispose();
                }
                this.modifiedFore = newColor;
            }
        });
    }

    private void createBackMode(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Combo backMode = new Combo(parent, 8);
        backMode.setItems(new String[]{"SWT.INHERIT_NONE", "SWT.INHERIT_DEFAULT", "SWT.INHERIT_FORCE"});
        backMode.select(0);
        backMode.addListener(13, event -> {
            int mode = 0;
            if (backMode.getText().indexOf("DEFAULT") != -1) {
                mode = 1;
            }
            if (backMode.getText().indexOf("FORCE") != -1) {
                mode = 2;
            }
            this.controlArea.setBackgroundMode(mode);
        });
        Button backImage = new Button(parent, 32);
        backImage.setText("Background Image");
        backImage.addListener(13, event -> {
            if (backImage.getSelection()) {
                this.controlArea.setBackgroundImage(ExamplesView.getImage("icons/background.PNG"));
            } else {
                this.controlArea.setBackgroundImage(null);
            }
        });
        Button backColor = new Button(parent, 32);
        backColor.setText("Background Color");
        backColor.addListener(13, event -> {
            if (backColor.getSelection()) {
                this.controlArea.setBackground(this.controlArea.getDisplay().getSystemColor(13));
            } else {
                this.controlArea.setBackground(null);
            }
        });
    }

    private void createLinks(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        String[] links = this.createLinks();
        if (links == null) {
            return;
        }
        String[] stringArray = links;
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            String link2 = stringArray[n2];
            Link link = new Link(parent, 0);
            link.setText(link2);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Program.launch((String)e.text);
                }
            });
            ++n2;
        }
    }

    private void createSize(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Button prefSize = new Button(parent, 16);
        prefSize.setText("Preferred");
        prefSize.setSelection(true);
        prefSize.addListener(13, event -> {
            this.controlGridData = new GridData();
            this.relayoutExample();
        });
        Button tenSize = new Button(parent, 16);
        tenSize.setText("10 X 10");
        tenSize.addListener(13, event -> {
            this.controlGridData = new GridData(10, 10);
            this.relayoutExample();
        });
        Button fiftySize = new Button(parent, 16);
        fiftySize.setText("50 X 50");
        fiftySize.addListener(13, event -> {
            this.controlGridData = new GridData(50, 50);
            this.relayoutExample();
        });
        Button hundredSize = new Button(parent, 16);
        hundredSize.setText("100 X 100");
        hundredSize.addListener(13, event -> {
            this.controlGridData = new GridData(100, 100);
            this.relayoutExample();
        });
        Button hFillB = new Button(parent, 32);
        hFillB.setText("Horizontal Fill");
        this.hFill = this.getInitialHorizontalFill();
        hFillB.setSelection(this.hFill);
        hFillB.addListener(13, event -> {
            this.hFill = hFillB.getSelection();
            this.relayoutExample();
        });
        Button vFillB = new Button(parent, 32);
        vFillB.setText("Vertical Fill");
        this.vFill = this.getInitialVerticalFill();
        vFillB.setSelection(this.vFill);
        vFillB.addListener(13, event -> {
            this.vFill = vFillB.getSelection();
            this.relayoutExample();
        });
    }

    public boolean getInitialHorizontalFill() {
        return false;
    }

    public boolean getInitialVerticalFill() {
        return false;
    }

    private void createListeners(Composite parent) {
        parent.setLayout((Layout)new GridLayout(4, false));
        ButtonFactory.create(parent, 8, "Select Listeners", event -> {
            ListenersDialog dialog = new ListenersDialog(Display.getCurrent().getActiveShell());
            if (dialog.open(this.selectedEvents) == 0) {
                this.updateListeners();
            }
        });
        this.listen = ButtonFactory.create(parent, 32, "Listen", event -> this.updateListeners());
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(768));
        Button clear = new Button(parent, 8);
        clear.setText("Clear");
        Text eventText = new Text(parent, 2818);
        GridData gd = new GridData(768);
        gd.heightHint = 120;
        gd.horizontalSpan = 4;
        eventText.setLayoutData((Object)gd);
        clear.addListener(13, event -> eventText.setText(""));
        this.listenerThatPrints = event -> {
            TypedEvent typedEvent = this.getTypedEvent(event);
            eventText.append("\n" + typedEvent.toString());
        };
    }

    private void updateListeners() {
        int[] nArray = eventIds;
        int n = eventIds.length;
        int n2 = 0;
        while (n2 < n) {
            int eventId = nArray[n2];
            boolean selected = this.selectedEvents.contains(new Integer(eventId));
            this.controlExample.removeListener(eventId, this.listenerThatPrints);
            if (selected && this.listen.getSelection()) {
                this.controlExample.addListener(eventId, this.listenerThatPrints);
            }
            for (Widget participant : this.additionalEventParticipants) {
                participant.removeListener(eventId, this.listenerThatPrints);
                if (!selected || !this.listen.getSelection()) continue;
                participant.addListener(eventId, this.listenerThatPrints);
            }
            ++n2;
        }
    }

    protected void addEventParticipant(Widget widget) {
        this.additionalEventParticipants.add(widget);
        widget.addDisposeListener(e -> {
            boolean bl = this.additionalEventParticipants.remove(widget);
        });
    }

    private TypedEvent getTypedEvent(Event e) {
        KeyEvent typedEvent = null;
        switch (e.type) {
            case 1: 
            case 2: {
                typedEvent = new KeyEvent(e);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 32: 
            case 37: {
                typedEvent = new MouseEvent(e);
                break;
            }
            case 9: {
                typedEvent = new PaintEvent(e);
                break;
            }
            case 10: 
            case 11: {
                typedEvent = new ControlEvent(e);
                break;
            }
            case 12: {
                typedEvent = new DisposeEvent(e);
                break;
            }
            case 13: 
            case 14: {
                typedEvent = new SelectionEvent(e);
                break;
            }
            case 15: 
            case 16: {
                typedEvent = new FocusEvent(e);
                break;
            }
            case 17: 
            case 18: {
                typedEvent = new TreeEvent(e);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                typedEvent = new ShellEvent(e);
                break;
            }
            case 24: {
                typedEvent = new ModifyEvent(e);
                break;
            }
            case 25: {
                typedEvent = new VerifyEvent(e);
                break;
            }
            case 28: {
                typedEvent = new HelpEvent(e);
                break;
            }
            case 30: {
                typedEvent = new ArmEvent(e);
                break;
            }
            case 31: {
                typedEvent = new TraverseEvent(e);
                break;
            }
            default: {
                typedEvent = new TypedEvent(e);
            }
        }
        return typedEvent;
    }

    public void reveal() {
    }
}

