/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.duallist;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.commons.SelectionListenerUtil;
import org.eclipse.nebula.widgets.opal.duallist.DLConfiguration;
import org.eclipse.nebula.widgets.opal.duallist.DLItem;
import org.eclipse.nebula.widgets.opal.duallist.SelectionChangeEvent;
import org.eclipse.nebula.widgets.opal.duallist.SelectionChangeListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class DualList
extends Composite {
    private static final String DOUBLE_DOWN_IMAGE = "double_down.png";
    private static final String DOUBLE_UP_IMAGE = "double_up.png";
    private static final String DOUBLE_LEFT_IMAGE = "double_left.png";
    private static final String DOUBLE_RIGHT_IMAGE = "double_right.png";
    private static final String ARROW_DOWN_IMAGE = "arrow_down.png";
    private static final String ARROW_LEFT_IMAGE = "arrow_left.png";
    private static final String ARROW_UP_IMAGE = "arrow_up.png";
    private static final String ARROW_RIGHT_IMAGE = "arrow_right.png";
    private final List<DLItem> items = new ArrayList<DLItem>();
    private final List<DLItem> selection = new ArrayList<DLItem>();
    private Table itemsTable;
    private Table selectionTable;
    private List<SelectionChangeListener> selectionChangeListeners;
    private DLConfiguration configuration;
    private Button buttonSelectAll;
    private Button buttonMoveFirst;
    private Button buttonSelect;
    private Button buttonMoveUp;
    private Button buttonDeselect;
    private Button buttonMoveDown;
    private Button buttonDeselectAll;
    private Button buttonMoveLast;

    public DualList(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(4, false));
        this.createItemsTable();
        this.createButtonSelectAll();
        this.createSelectionTable();
        this.createButtonMoveFirst();
        this.createButtonSelect();
        this.createButtonMoveUp();
        this.createButtonDeselect();
        this.createButtonMoveDown();
        this.createButtonDeselectAll();
        this.createButtonMoveLast();
    }

    private void createItemsTable() {
        this.itemsTable = this.createTable();
        this.itemsTable.addListener(8, event -> this.selectItem());
    }

    private Table createTable() {
        Table table = new Table((Composite)this, 66306);
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        GridData gd = new GridData(4, 4, true, true, 1, 4);
        gd.widthHint = 200;
        table.setLayoutData((Object)gd);
        new TableColumn(table, 0x1000000);
        new TableColumn(table, 16384);
        table.setData((Object)-1);
        return table;
    }

    private void createButtonSelectAll() {
        this.buttonSelectAll = this.createButton(DOUBLE_RIGHT_IMAGE, true, 3);
        this.buttonSelectAll.addListener(13, e -> this.selectAll());
    }

    private void createSelectionTable() {
        this.selectionTable = this.createTable();
        this.selectionTable.addListener(8, event -> this.deselectItem());
    }

    private void createButtonMoveFirst() {
        this.buttonMoveFirst = this.createButton(DOUBLE_UP_IMAGE, true, 3);
        this.buttonMoveFirst.addListener(13, e -> this.moveSelectionToFirstPosition());
    }

    private void createButtonSelect() {
        this.buttonSelect = this.createButton(ARROW_RIGHT_IMAGE, false, 2);
        this.buttonSelect.addListener(13, e -> this.selectItem());
    }

    private void createButtonMoveUp() {
        this.buttonMoveUp = this.createButton(ARROW_UP_IMAGE, false, 2);
        this.buttonMoveUp.addListener(13, e -> this.moveUpItem());
    }

    private void createButtonDeselect() {
        this.buttonDeselect = this.createButton(ARROW_LEFT_IMAGE, false, 2);
        this.buttonDeselect.addListener(13, e -> this.deselectItem());
    }

    private void createButtonMoveDown() {
        this.buttonMoveDown = this.createButton(ARROW_DOWN_IMAGE, false, 2);
        this.buttonMoveDown.addListener(13, e -> this.moveDownItem());
    }

    private void createButtonDeselectAll() {
        this.buttonDeselectAll = this.createButton(DOUBLE_LEFT_IMAGE, false, 1);
        this.buttonDeselectAll.addListener(13, e -> this.deselectAll());
    }

    private void createButtonMoveLast() {
        this.buttonMoveLast = this.createButton(DOUBLE_DOWN_IMAGE, true, 1);
        this.buttonMoveLast.addListener(13, e -> this.moveSelectionToLastPosition());
    }

    private Button createButton(String fileName, boolean verticalExpand, int alignment) {
        Button button = new Button((Composite)this, 8);
        Image image = SWTGraphicUtil.createImageFromFile((String)("images/" + fileName));
        button.setImage(image);
        button.setLayoutData((Object)new GridData(2, alignment, false, verticalExpand));
        SWTGraphicUtil.addDisposer((Widget)button, (Resource[])new Resource[]{image});
        return button;
    }

    public void add(DLItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        this.items.add(item);
        this.redrawTables();
    }

    public void add(DLItem item, int index) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (index < 0 || index >= this.items.size()) {
            SWT.error((int)5);
        }
        this.items.add(index, item);
        this.redrawTables();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener((EventListener)listener, new int[]{13});
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.removeTypedListener(13, (EventListener)listener);
    }

    public void addSelectionChangeListener(SelectionChangeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        if (this.selectionChangeListeners == null) {
            this.selectionChangeListeners = new ArrayList<SelectionChangeListener>();
        }
        this.selectionChangeListeners.add(listener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        if (this.selectionChangeListeners == null) {
            return;
        }
        this.selectionChangeListeners.remove(listener);
    }

    public void deselect(int index) {
        this.deselect(index, true);
    }

    public void deselectDoNotFireEvent(int index) {
        this.deselect(index, false);
    }

    private void deselect(int index, boolean shouldFireEvents) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        DLItem item = this.selection.remove(index);
        if (shouldFireEvents) {
            this.fireSelectionEvent(item);
        }
        ArrayList<DLItem> deselectedItems = new ArrayList<DLItem>();
        item.setLastAction(DLItem.LAST_ACTION.DESELECTION);
        deselectedItems.add(item);
        if (shouldFireEvents) {
            this.fireSelectionChangeEvent(deselectedItems);
        }
        this.redrawTables();
    }

    public void deselect(int[] indices) {
        this.deselect(indices, true);
    }

    public void deselectDoNotFireEvent(int[] indices) {
        this.deselect(indices, false);
    }

    private void deselect(int[] indices, boolean shouldFireEvents) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        ArrayList<DLItem> toBeRemoved = new ArrayList<DLItem>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index >= 0 && index < this.items.size()) {
                toBeRemoved.add(this.selection.get(index));
            }
            ++n2;
        }
        for (DLItem item : toBeRemoved) {
            this.selection.remove((Object)item);
            if (!shouldFireEvents) continue;
            this.fireSelectionEvent(item);
        }
        if (shouldFireEvents) {
            this.fireSelectionChangeEvent(toBeRemoved);
        }
        toBeRemoved.clear();
        this.redrawTables();
    }

    public void deselect(int start, int end) {
        this.deselect(start, end, true);
    }

    public void deselectDoNotFireEvent(int start, int end) {
        this.deselect(start, end, false);
    }

    private void deselect(int start, int end, boolean shouldFireEvents) {
        this.checkWidget();
        if (start > end) {
            SWT.error((int)6);
        }
        ArrayList<DLItem> toBeRemoved = new ArrayList<DLItem>();
        int index = start;
        while (index <= end) {
            if (index >= 0 && index < this.items.size()) {
                toBeRemoved.add(this.selection.get(index));
            }
            ++index;
        }
        for (DLItem item : toBeRemoved) {
            this.selection.remove((Object)item);
            if (!shouldFireEvents) continue;
            this.fireSelectionEvent(item);
        }
        if (shouldFireEvents) {
            this.fireSelectionChangeEvent(toBeRemoved);
        }
        toBeRemoved.clear();
        this.redrawTables();
    }

    public void deselectAll() {
        this.deselectAll(true);
    }

    public void deselectAllDoNotFireEvent() {
        this.deselectAll(false);
    }

    public void deselectAll(boolean shouldFireEvents) {
        this.checkWidget();
        this.items.addAll(this.selection);
        ArrayList<DLItem> deselectedItems = new ArrayList<DLItem>();
        for (DLItem item : this.selection) {
            item.setLastAction(DLItem.LAST_ACTION.DESELECTION);
            deselectedItems.add(item);
            if (!shouldFireEvents) continue;
            this.fireSelectionEvent(item);
        }
        this.fireSelectionChangeEvent(deselectedItems);
        this.selection.clear();
        this.redrawTables();
    }

    public DLItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            SWT.error((int)5);
        }
        return this.items.get(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public DLItem[] getItems() {
        this.checkWidget();
        return this.items.toArray(new DLItem[this.items.size()]);
    }

    public List<DLItem> getItemsAsList() {
        this.checkWidget();
        return new ArrayList<DLItem>(this.items);
    }

    public DLItem[] getSelection() {
        this.checkWidget();
        return this.selection.toArray(new DLItem[this.selection.size()]);
    }

    public List<DLItem> getSelectionAsList() {
        this.checkWidget();
        return new ArrayList<DLItem>(this.selection);
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selection.size();
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            SWT.error((int)5);
        }
        this.items.remove(index);
        this.redrawTables();
    }

    public void remove(int[] indices) {
        this.checkWidget();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index < 0 || index >= this.items.size()) {
                SWT.error((int)5);
            }
            this.items.remove(index);
            ++n2;
        }
        this.redrawTables();
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            SWT.error((int)5);
        }
        int index = start;
        while (index < end) {
            if (index < 0 || index >= this.items.size()) {
                SWT.error((int)5);
            }
            this.items.remove(index);
            ++index;
        }
        this.redrawTables();
    }

    public void remove(DLItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (!this.items.contains((Object)item)) {
            SWT.error((int)5);
        }
        this.items.remove((Object)item);
        this.redrawTables();
    }

    public void removeAll() {
        this.checkWidget();
        this.items.clear();
        this.redrawTables();
    }

    public void select(int index) {
        this.select(index, true);
    }

    public void selectDoNotFireEvent(int index) {
        this.select(index, false);
    }

    private void select(int index, boolean shouldFireEvents) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        ArrayList<DLItem> selectedItems = new ArrayList<DLItem>();
        DLItem item = this.items.remove(index);
        item.setLastAction(DLItem.LAST_ACTION.SELECTION);
        selectedItems.add(item);
        this.selection.add(item);
        if (shouldFireEvents) {
            this.fireSelectionEvent(item);
            this.fireSelectionChangeEvent(selectedItems);
        }
        this.redrawTables();
    }

    public void select(int[] indices) {
        this.select(indices, true);
    }

    public void selectDoNotFireEvent(int[] indices) {
        this.select(indices, false);
    }

    private void select(int[] indices, boolean shouldFireEvents) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        ArrayList<DLItem> selectedItems = new ArrayList<DLItem>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index >= 0 && index < this.items.size()) {
                DLItem item = this.items.get(index);
                item.setLastAction(DLItem.LAST_ACTION.SELECTION);
                selectedItems.add(item);
                this.selection.add(item);
                if (shouldFireEvents) {
                    this.fireSelectionEvent(item);
                }
            }
            ++n2;
        }
        this.items.removeAll(selectedItems);
        if (shouldFireEvents) {
            this.fireSelectionChangeEvent(selectedItems);
        }
        this.redrawTables();
    }

    public void select(int start, int end) {
        this.select(start, end, true);
    }

    public void selectDoNotFireEvent(int start, int end) {
        this.select(start, end, false);
    }

    private void select(int start, int end, boolean shouldFireEvents) {
        this.checkWidget();
        if (start > end) {
            SWT.error((int)6);
        }
        ArrayList<DLItem> selectedItems = new ArrayList<DLItem>();
        int index = start;
        while (index <= end) {
            if (index >= 0 && index < this.items.size()) {
                DLItem item = this.items.get(index);
                item.setLastAction(DLItem.LAST_ACTION.SELECTION);
                selectedItems.add(item);
                this.selection.add(item);
                if (shouldFireEvents) {
                    this.fireSelectionEvent(item);
                }
            }
            ++index;
        }
        if (shouldFireEvents) {
            this.fireSelectionChangeEvent(selectedItems);
        }
        this.redrawTables();
    }

    public void selectAll() {
        this.selectAll(true);
    }

    public void selectAllDoNotFireEvent() {
        this.selectAll(false);
    }

    private void selectAll(boolean shouldFireEvents) {
        this.checkWidget();
        this.selection.addAll(this.items);
        if (shouldFireEvents) {
            for (DLItem item : this.items) {
                this.fireSelectionEvent(item);
            }
        }
        if (shouldFireEvents) {
            ArrayList<DLItem> selectedItems = new ArrayList<DLItem>();
            for (DLItem item : this.items) {
                item.setLastAction(DLItem.LAST_ACTION.SELECTION);
                selectedItems.add(item);
            }
            this.fireSelectionChangeEvent(selectedItems);
        }
        this.items.clear();
        this.redrawTables();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.layout(true);
        boolean itemsContainImage = this.itemsContainImage();
        Point itemsTableDefaultSize = this.itemsTable.computeSize(-1, -1);
        Point selectionTableDefaultSize = this.selectionTable.computeSize(-1, -1);
        int itemsTableSize = this.itemsTable.getSize().x;
        if (itemsTableDefaultSize.y > this.itemsTable.getSize().y) {
            itemsTableSize -= this.itemsTable.getVerticalBar().getSize().x + 1;
        }
        int selectionTableSize = this.selectionTable.getSize().x;
        if (selectionTableDefaultSize.y > this.selectionTable.getSize().y) {
            selectionTableSize -= this.selectionTable.getVerticalBar().getSize().x;
        }
        if (itemsContainImage) {
            this.itemsTable.getColumn(0).pack();
            this.itemsTable.getColumn(1).setWidth(itemsTableSize - this.itemsTable.getColumn(0).getWidth());
            this.selectionTable.getColumn(0).pack();
            this.selectionTable.getColumn(1).setWidth(selectionTableSize - this.selectionTable.getColumn(0).getWidth());
        } else {
            this.itemsTable.getColumn(0).setWidth(0);
            this.itemsTable.getColumn(1).setWidth(itemsTableSize);
            this.selectionTable.getColumn(0).setWidth(0);
            this.selectionTable.getColumn(1).setWidth(selectionTableSize);
        }
    }

    private boolean itemsContainImage() {
        for (DLItem item : this.items) {
            if (item.getImage() == null) continue;
            return true;
        }
        for (DLItem item : this.selection) {
            if (item.getImage() == null) continue;
            return true;
        }
        return false;
    }

    public void setItem(int index, DLItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (index < 0 || index >= this.items.size()) {
            SWT.error((int)6);
        }
        this.items.set(index, item);
        this.redrawTables();
    }

    public void setItems(DLItem[] items) {
        this.checkWidget();
        if (items == null) {
            SWT.error((int)4);
        }
        ArrayList<DLItem> temp = new ArrayList<DLItem>();
        DLItem[] dLItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            DLItem item = dLItemArray[n2];
            if (item == null) {
                SWT.error((int)5);
            }
            temp.add(item);
            ++n2;
        }
        this.items.clear();
        this.items.addAll(temp);
        this.redrawTables();
    }

    public void setItems(List<DLItem> items) {
        this.checkWidget();
        if (items == null) {
            SWT.error((int)4);
        }
        ArrayList<DLItem> unselectedItems = new ArrayList<DLItem>();
        ArrayList<DLItem> selectedItems = new ArrayList<DLItem>();
        for (DLItem item : items) {
            if (item == null) {
                SWT.error((int)5);
            }
            if (item.getLastAction() == DLItem.LAST_ACTION.SELECTION) {
                selectedItems.add(item);
                continue;
            }
            unselectedItems.add(item);
        }
        this.items.clear();
        this.items.addAll(unselectedItems);
        this.selection.clear();
        this.selection.addAll(selectedItems);
        this.redrawTables();
    }

    private void redrawTables() {
        this.setRedraw(false);
        this.redrawTable(this.itemsTable, false);
        this.redrawTable(this.selectionTable, true);
        Rectangle bounds = this.getBounds();
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
        this.setRedraw(true);
    }

    private void redrawTable(Table table, boolean isSelected) {
        this.clean(table);
        this.fillData(table, isSelected);
    }

    private void clean(Table table) {
        if (table == null) {
            return;
        }
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.dispose();
            ++n2;
        }
    }

    private void fillData(Table table, boolean isSelected) {
        List<DLItem> listOfData = isSelected ? this.selection : this.items;
        int counter = 0;
        for (DLItem item : listOfData) {
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setData((Object)item);
            if (item.getBackground() != null) {
                tableItem.setBackground(item.getBackground());
            }
            if (item.getForeground() != null) {
                tableItem.setForeground(item.getForeground());
            }
            if (item.getImage() != null) {
                tableItem.setImage(0, item.getImage());
            }
            if (item.getFont() != null) {
                tableItem.setFont(item.getFont());
            }
            tableItem.setText(1, item.getText());
            if (this.configuration != null && item.getBackground() == null && counter % 2 == 0) {
                if (isSelected) {
                    tableItem.setBackground(this.configuration.getSelectionOddLinesColor());
                } else {
                    tableItem.setBackground(this.configuration.getItemsOddLinesColor());
                }
            }
            ++counter;
        }
    }

    protected void moveSelectionToFirstPosition() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        int index = 0;
        TableItem[] tableItemArray = this.selectionTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            DLItem item = (DLItem)((Object)tableItem.getData());
            this.selection.remove((Object)item);
            this.selection.add(index++, item);
            ++n2;
        }
        this.redrawTables();
        this.selectionTable.select(0, index - 1);
        this.selectionTable.forceFocus();
    }

    protected void selectItem() {
        if (this.itemsTable.getSelectionCount() == 0) {
            return;
        }
        ArrayList<DLItem> selectedItems = new ArrayList<DLItem>();
        TableItem[] tableItemArray = this.itemsTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            DLItem item = (DLItem)((Object)tableItem.getData());
            item.setLastAction(DLItem.LAST_ACTION.SELECTION);
            selectedItems.add(item);
            this.selection.add(item);
            this.items.remove((Object)item);
            this.fireSelectionEvent(item);
            ++n2;
        }
        this.fireSelectionChangeEvent(selectedItems);
        this.redrawTables();
    }

    protected void moveUpItem() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        int[] nArray = this.selectionTable.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index == 0) {
                this.selectionTable.forceFocus();
                return;
            }
            ++n2;
        }
        int[] newSelection = new int[this.selectionTable.getSelectionCount()];
        int newSelectionIndex = 0;
        TableItem[] tableItemArray = this.selectionTable.getSelection();
        int n3 = tableItemArray.length;
        int n4 = 0;
        while (n4 < n3) {
            TableItem tableItem = tableItemArray[n4];
            int position = this.selection.indexOf(tableItem.getData());
            this.swap(position, position - 1);
            newSelection[newSelectionIndex++] = position - 1;
            ++n4;
        }
        this.redrawTables();
        this.selectionTable.select(newSelection);
        this.selectionTable.forceFocus();
    }

    protected void deselectItem() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        ArrayList<DLItem> deselectedItems = new ArrayList<DLItem>();
        TableItem[] tableItemArray = this.selectionTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            DLItem item = (DLItem)((Object)tableItem.getData());
            item.setLastAction(DLItem.LAST_ACTION.DESELECTION);
            deselectedItems.add(item);
            this.items.add(item);
            this.selection.remove((Object)item);
            this.fireSelectionEvent(item);
            ++n2;
        }
        this.fireSelectionChangeEvent(deselectedItems);
        this.redrawTables();
    }

    protected void moveDownItem() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        int[] nArray = this.selectionTable.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index == this.selectionTable.getItemCount() - 1) {
                this.selectionTable.forceFocus();
                return;
            }
            ++n2;
        }
        int[] newSelection = new int[this.selectionTable.getSelectionCount()];
        int newSelectionIndex = 0;
        TableItem[] tableItemArray = this.selectionTable.getSelection();
        int n3 = tableItemArray.length;
        int n4 = 0;
        while (n4 < n3) {
            TableItem tableItem = tableItemArray[n4];
            int position = this.selection.indexOf(tableItem.getData());
            this.swap(position, position + 1);
            newSelection[newSelectionIndex++] = position + 1;
            ++n4;
        }
        this.redrawTables();
        this.selectionTable.select(newSelection);
        this.selectionTable.forceFocus();
    }

    private void swap(int first, int second) {
        DLItem temp = this.selection.get(first);
        this.selection.set(first, this.selection.get(second));
        this.selection.set(second, temp);
    }

    protected void moveSelectionToLastPosition() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        int numberOfSelectedElements = this.selectionTable.getSelectionCount();
        TableItem[] tableItemArray = this.selectionTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            DLItem item = (DLItem)((Object)tableItem.getData());
            this.selection.remove((Object)item);
            this.selection.add(item);
            ++n2;
        }
        this.redrawTables();
        int numberOfElements = this.selectionTable.getItemCount();
        this.selectionTable.select(numberOfElements - numberOfSelectedElements, numberOfElements - 1);
        this.selectionTable.forceFocus();
    }

    private void fireSelectionEvent(DLItem item) {
        Event event = new Event();
        event.button = 1;
        event.display = this.getDisplay();
        event.item = null;
        event.widget = this;
        event.data = item;
        SelectionListenerUtil.fireSelectionListeners((Control)this, (Event)event);
    }

    private void fireSelectionChangeEvent(List<DLItem> items) {
        if (this.selectionChangeListeners == null) {
            return;
        }
        Event event = new Event();
        event.button = 1;
        event.display = this.getDisplay();
        event.item = null;
        event.widget = this;
        SelectionChangeEvent selectionChangeEvent = new SelectionChangeEvent(event);
        selectionChangeEvent.setItems(items);
        for (SelectionChangeListener listener : this.selectionChangeListeners) {
            listener.widgetSelected(selectionChangeEvent);
        }
    }

    public DLConfiguration getConfiguration() {
        this.checkWidget();
        return this.configuration;
    }

    public void setConfiguration(DLConfiguration configuration) {
        this.checkWidget();
        this.configuration = configuration;
        this.applyNewConfiguration();
    }

    private void applyNewConfiguration() {
        try {
            this.setRedraw(true);
            if (this.configuration == null) {
                this.resetConfigurationToDefault();
            } else {
                this.modifyPanelsColors();
                this.modifyTextAlignment();
                this.modifyButtonImages();
                this.modifyButtonVisibility();
            }
            this.redrawTables();
        }
        finally {
            this.setRedraw(true);
        }
    }

    private void resetConfigurationToDefault() {
        this.itemsTable.setBackground(null);
        this.itemsTable.setForeground(null);
        this.selectionTable.setBackground(null);
        this.selectionTable.setForeground(null);
        this.recreateTableColumns(this.itemsTable, 16384);
        this.recreateTableColumns(this.selectionTable, 16384);
        this.resetButton(this.buttonMoveLast, DOUBLE_DOWN_IMAGE);
        this.resetButton(this.buttonMoveFirst, DOUBLE_UP_IMAGE);
        this.resetButton(this.buttonDeselectAll, DOUBLE_LEFT_IMAGE);
        this.resetButton(this.buttonSelectAll, DOUBLE_RIGHT_IMAGE);
        this.resetButton(this.buttonMoveDown, ARROW_DOWN_IMAGE);
        this.resetButton(this.buttonMoveUp, ARROW_UP_IMAGE);
        this.resetButton(this.buttonDeselect, ARROW_LEFT_IMAGE);
        this.resetButton(this.buttonSelect, ARROW_RIGHT_IMAGE);
    }

    private void resetButton(Button button, String fileName) {
        Image image = SWTGraphicUtil.createImageFromFile((String)("images/" + fileName));
        button.setImage(image);
        SWTGraphicUtil.addDisposer((Widget)button, (Resource[])new Resource[]{image});
        button.setVisible(true);
    }

    private void modifyPanelsColors() {
        if (this.configuration.getItemsBackgroundColor() != null) {
            this.itemsTable.setBackground(this.configuration.getItemsBackgroundColor());
        }
        if (this.configuration.getItemsForegroundColor() != null) {
            this.itemsTable.setForeground(this.configuration.getItemsForegroundColor());
        }
        if (this.configuration.getSelectionBackgroundColor() != null) {
            this.selectionTable.setBackground(this.configuration.getSelectionBackgroundColor());
        }
        if (this.configuration.getSelectionForegroundColor() != null) {
            this.selectionTable.setForeground(this.configuration.getSelectionForegroundColor());
        }
    }

    private void modifyTextAlignment() {
        this.recreateTableColumns(this.itemsTable, this.configuration.getItemsTextAlignment());
        this.recreateTableColumns(this.selectionTable, this.configuration.getSelectionTextAlignment());
    }

    private void recreateTableColumns(Table table, int textAlignment) {
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = tableColumnArray[n2];
            tc.dispose();
            ++n2;
        }
        new TableColumn(table, 0x1000000);
        new TableColumn(table, textAlignment);
    }

    private void modifyButtonImages() {
        if (this.configuration.getDoubleDownImage() != null) {
            this.buttonMoveLast.setImage(this.configuration.getDoubleDownImage());
        }
        if (this.configuration.getDoubleUpImage() != null) {
            this.buttonMoveFirst.setImage(this.configuration.getDoubleUpImage());
        }
        if (this.configuration.getDoubleLeftImage() != null) {
            this.buttonDeselectAll.setImage(this.configuration.getDoubleLeftImage());
        }
        if (this.configuration.getDoubleRightImage() != null) {
            this.buttonSelectAll.setImage(this.configuration.getDoubleRightImage());
        }
        if (this.configuration.getDownImage() != null) {
            this.buttonMoveDown.setImage(this.configuration.getDownImage());
        }
        if (this.configuration.getUpImage() != null) {
            this.buttonMoveUp.setImage(this.configuration.getUpImage());
        }
        if (this.configuration.getLeftImage() != null) {
            this.buttonDeselect.setImage(this.configuration.getLeftImage());
        }
        if (this.configuration.getRightImage() != null) {
            this.buttonSelect.setImage(this.configuration.getRightImage());
        }
    }

    private void modifyButtonVisibility() {
        this.buttonMoveLast.setVisible(this.configuration.isDoubleDownVisible());
        this.buttonMoveFirst.setVisible(this.configuration.isDoubleUpVisible());
        this.buttonDeselectAll.setVisible(this.configuration.isDoubleLeftVisible());
        this.buttonSelectAll.setVisible(this.configuration.isDoubleRightVisible());
        this.buttonMoveDown.setVisible(this.configuration.isDownVisible());
        this.buttonMoveUp.setVisible(this.configuration.isUpVisible());
    }
}

