/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pgroup;

import org.eclipse.nebula.widgets.pgroup.AbstractGroupStrategy;
import org.eclipse.nebula.widgets.pgroup.AbstractToolItemRenderer;
import org.eclipse.nebula.widgets.pgroup.PGroup;
import org.eclipse.nebula.widgets.pgroup.PGroupToolItem;
import org.eclipse.nebula.widgets.pgroup.internal.GraphicUtils;
import org.eclipse.nebula.widgets.pgroup.internal.TextUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;

public class FormGroupStrategy
extends AbstractGroupStrategy {
    private Color initialBackColor;
    private Color initialBorderColor;
    private final int titleTextMargin = 2;
    private final int betweenSpacing = 6;
    private final int margin = 0;
    private final int vMargin = 2;
    private final int hMargin = 6;
    private Color borderColor;
    private int titleHeight;
    private int textWidth;
    private int fontHeight;
    private Rectangle toolItemArea;

    @Override
    public void initialize() {
        super.initialize();
        RGB borderRGB = GraphicUtils.blend(this.getGroup().getDisplay().getSystemColor(35).getRGB(), this.getGroup().getDisplay().getSystemColor(25).getRGB(), 100);
        this.borderColor = this.initialBorderColor = new Color(borderRGB);
        RGB backRGB = GraphicUtils.blend(this.getGroup().getDisplay().getSystemColor(32).getRGB(), this.getGroup().getDisplay().getSystemColor(25).getRGB(), 40);
        this.initialBackColor = new Color(backRGB);
    }

    @Deprecated
    public FormGroupStrategy() {
        this(null);
    }

    public FormGroupStrategy(PGroup g) {
        super(g);
    }

    @Override
    public void paint(GC gc) {
        Color back = this.getGroup().internalGetBackground();
        if (back != null) {
            gc.fillRectangle(0, 0, this.getGroup().getSize().x, this.getGroup().getSize().y);
            Region reg = new Region();
            reg.add(0, 0, 5, 1);
            reg.add(0, 1, 3, 1);
            reg.add(0, 2, 2, 1);
            reg.add(0, 3, 1, 1);
            reg.add(0, 4, 1, 1);
            reg.add(this.getGroup().getSize().x - 5, 0, 5, 1);
            reg.add(this.getGroup().getSize().x - 3, 1, 3, 1);
            reg.add(this.getGroup().getSize().x - 2, 2, 2, 1);
            reg.add(this.getGroup().getSize().x - 1, 3, 1, 1);
            reg.add(this.getGroup().getSize().x - 1, 4, 1, 1);
            gc.setClipping(reg);
            this.getGroup().drawBackground(gc, 0, 0, this.getGroup().getSize().x, 5);
            gc.setClipping(null);
            reg.dispose();
        }
        Point imagePoint = new Point(0, 0);
        if (this.getGroup().getToggleRenderer() != null) {
            Point p = this.getGroup().getToggleRenderer().getSize();
            int toggleY = 0;
            toggleY = (this.titleHeight - p.y) / 2;
            int toggleX = 0;
            toggleX = (this.getGroup().getTogglePosition() & 0x4000) != 0 ? 6 : this.getGroup().getSize().x - 6 - p.x;
            this.getGroup().getToggleRenderer().setLocation(new Point(toggleX, toggleY));
        }
        Region reg = new Region((Device)this.getGroup().getDisplay());
        reg.add(0, 0, this.getGroup().getSize().x, this.titleHeight);
        reg.subtract(0, 0, 5, 1);
        reg.subtract(0, 1, 3, 1);
        reg.subtract(0, 2, 2, 1);
        reg.subtract(0, 3, 1, 1);
        reg.subtract(0, 4, 1, 1);
        reg.subtract(this.getGroup().getSize().x - 5, 0, 5, 1);
        reg.subtract(this.getGroup().getSize().x - 3, 1, 3, 1);
        reg.subtract(this.getGroup().getSize().x - 2, 2, 2, 1);
        reg.subtract(this.getGroup().getSize().x - 1, 3, 1, 1);
        reg.subtract(this.getGroup().getSize().x - 1, 4, 1, 1);
        gc.setClipping(reg);
        back = gc.getBackground();
        Color fore = gc.getForeground();
        gc.setForeground(this.initialBackColor);
        gc.setBackground(this.getGroup().getParent().getBackground());
        Pattern p = new Pattern((Device)this.getGroup().getDisplay(), 0.0f, 0.0f, 0.0f, (float)this.titleHeight, this.initialBackColor, 255, this.getGroup().getBackground(), 0);
        gc.setBackgroundPattern(p);
        gc.fillRectangle(0, 0, this.getGroup().getSize().x, this.titleHeight);
        p.dispose();
        gc.setBackgroundPattern(null);
        if (this.getGroup().getExpanded() && this.getGroup().getSize().x > 1) {
            reg.subtract(1, this.titleHeight - 1, this.getGroup().getSize().x - 2, 1);
            gc.setClipping(reg);
        }
        gc.setForeground(this.borderColor);
        GraphicUtils.drawRoundRectangle(gc, 0, 0, this.getGroup().getSize().x - 1, this.titleHeight, null, true, false);
        reg.dispose();
        gc.setClipping(null);
        gc.setForeground(this.getGroup().getParent().getBackground());
        gc.setBackground(back);
        gc.setForeground(fore);
        Image image = this.getGroup().getImage();
        if (image != null) {
            imagePoint.x = 6;
            if ((this.getGroup().getImagePosition() & 0x4000) != 0) {
                if (this.getGroup().getToggleRenderer() != null && (this.getGroup().getTogglePosition() & 0x4000) != 0) {
                    imagePoint.x += this.getGroup().getToggleRenderer().getSize().x + 6;
                }
            } else {
                imagePoint.x = this.getGroup().getToggleRenderer() != null ? ((this.getGroup().getTogglePosition() & 0x4000) != 0 ? this.getGroup().getSize().x - (6 + image.getBounds().width) : this.getGroup().getSize().x - (6 + image.getBounds().width + this.getGroup().getToggleRenderer().getSize().x + 6)) : this.getGroup().getSize().x - (6 + image.getBounds().width);
            }
            imagePoint.y = (this.titleHeight - image.getBounds().height) / 2;
            gc.drawImage(image, imagePoint.x, imagePoint.y);
        }
        Rectangle textBounds = this.getTextBounds();
        String shortened = TextUtils.getShortString(gc, this.getGroup().getText(), textBounds.width);
        if (this.getGroup().getToolItems().length > 0 && this.getGroup().getToolItemRenderer() != null) {
            PGroupToolItem[] items = this.getGroup().getToolItems();
            AbstractToolItemRenderer renderer = this.getGroup().getToolItemRenderer();
            Point size = new Point(0, 0);
            Point minSize = new Point(0, 0);
            int spacing = 3;
            int i = 0;
            while (i < items.length) {
                PGroupToolItem item = items[i];
                Point s0 = renderer.computeSize(gc, item, 1);
                Point s1 = renderer.computeSize(gc, item, 2);
                size.x += s0.x + spacing;
                minSize.x += s1.x + spacing;
                ++i;
            }
            boolean min = false;
            if (shortened.length() != this.getGroup().getText().length()) {
                textBounds.width -= minSize.x;
                min = true;
            } else if (!TextUtils.getShortString(gc, this.getGroup().getText(), textBounds.width - size.x).equals(this.getGroup().getText())) {
                textBounds.width -= minSize.x;
                min = true;
            } else {
                textBounds.width -= size.x;
            }
            shortened = TextUtils.getShortString(gc, this.getGroup().getText(), textBounds.width);
            int x = textBounds.x + textBounds.width;
            this.toolItemArea = min ? new Rectangle(x, 2, minSize.x, this.titleHeight - 4) : new Rectangle(x, 2, size.x, this.titleHeight - 4);
        }
        gc.drawText(TextUtils.getShortString(gc, this.getGroup().getText(), textBounds.width), textBounds.x, textBounds.y, true);
    }

    @Override
    public Rectangle getToolItemArea() {
        return this.toolItemArea;
    }

    @Override
    public boolean isToggleLocation(int x, int y) {
        if (super.isToggleLocation(x, y)) {
            return true;
        }
        if (this.getGroup().getToggleRenderer() == null) {
            return false;
        }
        Rectangle textBounds = this.getTextBounds();
        textBounds.width = Math.min(this.textWidth, textBounds.width);
        return textBounds.contains(x, y);
    }

    private Rectangle getTextBounds() {
        Point textPoint = new Point(0, 0);
        textPoint.x = 6;
        textPoint.y = (this.titleHeight - this.fontHeight) / 2;
        if (this.getGroup().getImage() != null && (this.getGroup().getImagePosition() & 0x4000) != 0) {
            textPoint.x += this.getGroup().getImage().getBounds().width + 6;
        }
        if (this.getGroup().getToggleRenderer() != null && (this.getGroup().getTogglePosition() & 0x4000) != 0) {
            textPoint.x += this.getGroup().getToggleRenderer().getSize().x + 6;
        }
        int textWidth = this.getGroup().getSize().x - 12;
        if (this.getGroup().getImage() != null) {
            textWidth -= this.getGroup().getImage().getBounds().width + 6;
        }
        if (this.getGroup().getToggleRenderer() != null) {
            textWidth -= this.getGroup().getToggleRenderer().getSize().x + 6;
        }
        return new Rectangle(textPoint.x, textPoint.y, textWidth, this.fontHeight);
    }

    @Override
    public Rectangle getClientArea() {
        Rectangle area = this.getGroup().getBounds();
        area.x = 0;
        area.y = this.titleHeight;
        area.width -= 0;
        area.height -= this.titleHeight + 0;
        return area;
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle area = new Rectangle(x, y, Math.max(0, width), Math.max(0, height));
        area.x -= 0;
        area.y -= this.titleHeight;
        area.width += 0;
        area.height += this.titleHeight + 0;
        return area;
    }

    @Override
    public void dispose() {
        if (this.initialBackColor != null) {
            this.initialBackColor.dispose();
        }
        if (this.initialBorderColor != null) {
            this.initialBorderColor.dispose();
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @Override
    public void update() {
        GC gc = new GC((Drawable)this.getGroup());
        this.titleHeight = 0;
        if (this.getGroup().getImage() != null) {
            this.titleHeight = this.getGroup().getImage().getBounds().height + 4;
        }
        if (this.getGroup().getToggleRenderer() != null) {
            int toggleHeight = this.getGroup().getToggleRenderer().getSize().y;
            this.titleHeight = Math.max(toggleHeight + 4, this.titleHeight);
        }
        this.titleHeight = Math.max(gc.getFontMetrics().getHeight() + 4 + 4, this.titleHeight);
        this.textWidth = gc.stringExtent((String)this.getGroup().getText()).x;
        this.fontHeight = gc.getFontMetrics().getHeight();
        gc.dispose();
    }
}

