/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.floatingtext;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FloatingText
extends Composite {
    private Text fText;
    private Label fLabel;
    private int fStyle;
    private int fLabelToTextRatio = 90;
    private Font fLabelFont;

    public FloatingText(Composite pParent, int pStyle) {
        super(pParent, 0x20000000 | pStyle & 0x800);
        this.fStyle = pStyle;
        this.setLayout((Layout)this.createLayout(pStyle));
        this.fLabel = this.createLabel(pStyle);
        this.fLabel.addDisposeListener(e -> {
            if (this.fLabelFont != null) {
                this.fLabelFont.dispose();
            }
        });
        this.fText = new Text((Composite)this, this.removeStyles(pStyle, 2048, 2));
        this.fText.setLayoutData((Object)this.getTextLayoutData());
        this.fLabel.setBackground(this.fText.getBackground());
        this.fLabel.setForeground(this.fText.getForeground());
        this.fLabel.setLayoutData((Object)this.getLabelLayoutData());
        this.fText.addListener(15, e -> this.setLabelText(true));
        this.fText.addListener(16, e -> this.setLabelText(false));
        this.fText.addListener(24, e -> {
            if (!this.fText.getText().isEmpty() && this.fLabel.getText().isEmpty()) {
                this.fLabel.setText(this.fText.getMessage());
            }
            if (this.fText.getText().isEmpty() && !this.fLabel.getText().isEmpty() && this.getDisplay().getFocusControl() != this.fText) {
                this.fLabel.setText("");
            }
        });
    }

    public Point computeSize(int pWidthHint, int pHeightHint, boolean pChanged) {
        Point textSize = this.fText.computeSize(pWidthHint, pHeightHint, pChanged);
        Point labelSize = this.fLabel.computeSize(pWidthHint, pHeightHint == -1 ? -1 : textSize.y * this.fLabelToTextRatio / 100, pChanged);
        Point result = new Point(textSize.x + labelSize.x, textSize.y + labelSize.y);
        if ((this.fStyle & 0x800) == 2048) {
            result.x += 2;
            result.y += 6;
        }
        result.y += this.getLayout().verticalSpacing;
        return result;
    }

    private Label createLabel(int pStyle) {
        return new Label(this, ((pStyle & 0x2000000) > 0 ? 16384 : 0) | ((pStyle & 0x4000000) > 0 ? 131072 : 0)){

            protected void checkSubclass() {
            }

            public Point computeSize(int pWHint, int pHHint, boolean pChanged) {
                Point result = super.computeSize(pWHint, pHHint, pChanged);
                result.y = result.y = ((GridData)FloatingText.this.fLabel.getLayoutData()).heightHint;
                return result;
            }
        };
    }

    private GridLayout createLayout(int pStyle) {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        if ((pStyle & 2) == 2) {
            gridLayout.verticalSpacing = 1;
        }
        return gridLayout;
    }

    private void doSetLabelText() {
        String message = this.getMessage();
        if (message.isEmpty()) {
            return;
        }
        if (this.fLabel.getSize().y <= 0) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FloatingText.this.doSetLabelText();
                }
            });
            return;
        }
        this.fLabelFont = this.findFittingFont(this.fLabel);
        this.fLabel.getFont().dispose();
        this.fLabel.setFont(this.fLabelFont);
        this.fLabel.setText(message);
    }

    public Font findFittingFont(Label label) {
        int fontSize = label.getSize().y * 75 / 100;
        Font font = this.getFont(label, fontSize);
        GC gc = new GC((Drawable)label);
        gc.setFont(font);
        while (fontSize > 2) {
            int textHeight = gc.textExtent((String)"PQR").y;
            if (textHeight <= label.getBounds().height) {
                return font;
            }
            font.dispose();
            font = this.getFont(label, --fontSize);
            gc.setFont(font);
        }
        gc.dispose();
        return font;
    }

    private Font getFont(Label label, int fontSize) {
        FontData[] fontData = label.getFont().getFontData();
        FontData[] newFontData = new FontData[fontData.length];
        int i = 0;
        while (i < fontData.length) {
            newFontData[i] = new FontData(fontData[i].getName(), fontSize, fontData[i].getStyle());
            newFontData[i].setLocale(fontData[i].getLocale());
            ++i;
        }
        return new Font((Device)this.getDisplay(), newFontData);
    }

    public Label getLabel() {
        return this.fLabel;
    }

    private GridData getLabelLayoutData() {
        GridData gridData = new GridData(4, 4, true, false);
        gridData.heightHint = this.fText.computeSize((int)-1, (int)-1).y * this.fLabelToTextRatio / 100;
        return gridData;
    }

    public int getLabelRatio() {
        return this.fLabelToTextRatio;
    }

    public GridLayout getLayout() {
        return (GridLayout)super.getLayout();
    }

    private String getMessage() {
        String message = this.fText.getMessage();
        if (message == null || message.trim().isEmpty()) {
            message = this.fText.getMessage();
        }
        return message == null ? "" : message.trim();
    }

    public Text getText() {
        return this.fText;
    }

    private GridData getTextLayoutData() {
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        return gridData;
    }

    private int removeStyles(int pStyle, int ... styles) {
        int result = pStyle;
        int[] nArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if ((result & i) == i) {
                result ^= i;
            }
            ++n2;
        }
        return result;
    }

    public void setBackgroundColors(Color color) {
        this.fText.setBackground(color);
        this.fLabel.setBackground(color);
    }

    public void setEnabled(boolean pEnabled) {
        super.setEnabled(pEnabled);
        this.fText.setEnabled(pEnabled);
        this.fLabel.setEnabled(pEnabled);
    }

    public void setForegroundColors(Color color) {
        this.fText.setForeground(color);
        this.fLabel.setForeground(color);
    }

    private void setLabelText(boolean pFocus) {
        this.fLabel.setText("");
        String prompt = this.fText.getMessage();
        if (pFocus) {
            this.doSetLabelText();
        } else if (!this.fText.getText().isEmpty() && !this.fText.getText().equals(prompt)) {
            this.doSetLabelText();
        }
    }

    public void setRatio(int ratio) {
        this.fLabelToTextRatio = ratio;
        this.fLabel.setLayoutData((Object)this.getLabelLayoutData());
        this.requestLayout();
    }

    public FloatingText setSeparatorSpace(int space) {
        this.getLayout().verticalSpacing = space;
        this.requestLayout();
        return this;
    }
}

